/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.trust.impl.client;

import com.sun.xml.ws.api.security.trust.WSTrustException;
import com.sun.xml.ws.api.security.trust.client.IssuedTokenProvider;
import com.sun.xml.ws.api.security.trust.client.STSIssuedTokenConfiguration;
import com.sun.xml.ws.security.IssuedTokenContext;
import com.sun.xml.ws.security.trust.TrustPlugin;
import com.sun.xml.ws.security.trust.WSTrustFactory;
import com.sun.xml.ws.security.trust.logging.LogStringsMessages;
import com.sun.xml.wss.SubjectAccessor;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;

public class STSIssuedTokenProviderImpl
implements IssuedTokenProvider {
    private static final Logger log = Logger.getLogger("com.sun.xml.ws.security.trust", "com.sun.xml.ws.security.trust.logging.LogStrings");

    @Override
    public void issue(IssuedTokenContext ctx) throws WSTrustException {
        this.getIssuedTokenContext(ctx);
    }

    @Override
    public void cancel(IssuedTokenContext ctx) throws WSTrustException {
    }

    @Override
    public void renew(IssuedTokenContext ctx) throws WSTrustException {
    }

    @Override
    public void validate(IssuedTokenContext ctx) throws WSTrustException {
        TrustPlugin tp = WSTrustFactory.newTrustPlugin();
        tp.processValidate(ctx);
    }

    private void updateContext(IssuedTokenContext cached, IssuedTokenContext ctx) {
        ctx.setUnAttachedSecurityTokenReference(cached.getUnAttachedSecurityTokenReference());
        ctx.setSecurityToken(cached.getSecurityToken());
        ctx.setRequestorCertificate(cached.getRequestorCertificate());
        ctx.setProofKeyPair(cached.getProofKeyPair());
        ctx.setProofKey(cached.getProofKey());
        ctx.setExpirationTime(cached.getExpirationTime());
        ctx.setCreationTime(cached.getCreationTime());
        ctx.setAttachedSecurityTokenReference(cached.getAttachedSecurityTokenReference());
    }

    private void getIssuedTokenContext(IssuedTokenContext ctx) throws WSTrustException {
        STSIssuedTokenConfiguration config = (STSIssuedTokenConfiguration)ctx.getSecurityPolicy().get(0);
        ctx.setTokenIssuer(config.getSTSEndpoint());
        boolean shareToken = "true".equals(config.getOtherOptions().get("shareToken"));
        boolean renewExpiredToken = "true".equals(config.getOtherOptions().get("renewExpiredToken"));
        String maxClockSkew = (String)config.getOtherOptions().get("MaxClockSkew");
        Subject subject = SubjectAccessor.getRequesterSubject();
        if (shareToken && subject != null) {
            Set<IssuedTokenContext> pcs = subject.getPrivateCredentials(IssuedTokenContext.class);
            Iterator<IssuedTokenContext> iterator = pcs.iterator();
            while (iterator.hasNext()) {
                IssuedTokenContext obj;
                IssuedTokenContext cached = obj = iterator.next();
                GregorianCalendar c = new GregorianCalendar();
                long offset = c.get(15);
                if (((Calendar)c).getTimeZone().inDaylightTime(c.getTime())) {
                    offset += (long)((Calendar)c).getTimeZone().getDSTSavings();
                }
                long beforeTime = c.getTimeInMillis();
                long currentTime = beforeTime - offset;
                if (maxClockSkew != null) {
                    currentTime -= Long.parseLong(maxClockSkew);
                }
                c.setTimeInMillis(currentTime);
                Date currentTimeInDateFormat = c.getTime();
                if (cached.getExpirationTime() != null && currentTimeInDateFormat.after(cached.getExpirationTime())) {
                    subject.getPrivateCredentials().remove(cached);
                    if (renewExpiredToken) continue;
                    log.log(Level.SEVERE, LogStringsMessages.WST_0046_TOKEN_EXPIRED(cached.getCreationTime(), cached.getExpirationTime(), currentTimeInDateFormat));
                    throw new WSTrustException(LogStringsMessages.WST_0046_TOKEN_EXPIRED(cached.getCreationTime(), cached.getExpirationTime(), currentTimeInDateFormat));
                }
                if (!cached.getTokenIssuer().equals(ctx.getTokenIssuer())) continue;
                this.updateContext(cached, ctx);
                return;
            }
        }
        TrustPlugin tp = WSTrustFactory.newTrustPlugin();
        tp.process(ctx);
        if (shareToken) {
            if (subject == null) {
                subject = new Subject();
            }
            subject.getPrivateCredentials().add(ctx);
            SubjectAccessor.setRequesterSubject(subject);
        }
    }
}

