/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.dependencies;

import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.shared.dependency.tree.DependencyNode;
import org.apache.maven.shared.dependency.tree.traversal.DependencyNodeVisitor;

public class DependencyExcludeNodeVisitor
implements DependencyNodeVisitor {
    private DependencyNode root;
    private Set<DependencyNode> directs;
    private Stack<DependencyNode> path;
    private Set<Stack<DependencyNode>> allPaths;
    private String key;

    public DependencyExcludeNodeVisitor(String groupId, String artifactId, String type) {
        assert (groupId != null);
        assert (artifactId != null);
        this.key = groupId + ":" + artifactId + ":" + type;
    }

    public Set<DependencyNode> getDirectDependencies() {
        return this.directs;
    }

    public Set<Stack<DependencyNode>> getAllPaths() {
        return this.allPaths;
    }

    public boolean visit(DependencyNode node) {
        if (this.root == null) {
            this.root = node;
            this.directs = new HashSet<DependencyNode>();
            this.path = new Stack();
            this.allPaths = new HashSet<Stack<DependencyNode>>();
            return true;
        }
        this.path.push(node);
        Artifact artifact = node.getArtifact();
        if (this.key.equals(artifact.getDependencyConflictId())) {
            if (!this.path.isEmpty()) {
                this.directs.add((DependencyNode)this.path.firstElement());
                Stack<DependencyNode> copy = new Stack<DependencyNode>();
                copy.addAll(this.path);
                this.allPaths.add(copy);
            }
            return false;
        }
        return true;
    }

    public boolean endVisit(DependencyNode node) {
        if (this.root == node) {
            this.root = null;
            this.path = null;
            return true;
        }
        this.path.pop();
        return true;
    }
}

