/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.devops.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.devops.model.DeployStagePredecessorCollection;
import com.oracle.bmc.devops.model.UpdateDeployStageDetails;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="deployStageType")
@JsonFilter(value="explicitlySetFilter")
public final class UpdateFunctionDeployStageDetails
extends UpdateDeployStageDetails {
    @JsonProperty(value="functionDeployEnvironmentId")
    private final String functionDeployEnvironmentId;
    @JsonProperty(value="dockerImageDeployArtifactId")
    private final String dockerImageDeployArtifactId;
    @JsonProperty(value="config")
    private final Map<String, String> config;
    @JsonProperty(value="maxMemoryInMBs")
    private final Long maxMemoryInMBs;
    @JsonProperty(value="functionTimeoutInSeconds")
    private final Integer functionTimeoutInSeconds;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public UpdateFunctionDeployStageDetails(String description, String displayName, DeployStagePredecessorCollection deployStagePredecessorCollection, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, String functionDeployEnvironmentId, String dockerImageDeployArtifactId, Map<String, String> config, Long maxMemoryInMBs, Integer functionTimeoutInSeconds) {
        super(description, displayName, deployStagePredecessorCollection, freeformTags, definedTags);
        this.functionDeployEnvironmentId = functionDeployEnvironmentId;
        this.dockerImageDeployArtifactId = dockerImageDeployArtifactId;
        this.config = config;
        this.maxMemoryInMBs = maxMemoryInMBs;
        this.functionTimeoutInSeconds = functionTimeoutInSeconds;
    }

    public String getFunctionDeployEnvironmentId() {
        return this.functionDeployEnvironmentId;
    }

    public String getDockerImageDeployArtifactId() {
        return this.dockerImageDeployArtifactId;
    }

    public Map<String, String> getConfig() {
        return this.config;
    }

    public Long getMaxMemoryInMBs() {
        return this.maxMemoryInMBs;
    }

    public Integer getFunctionTimeoutInSeconds() {
        return this.functionTimeoutInSeconds;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("UpdateFunctionDeployStageDetails(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", functionDeployEnvironmentId=").append(String.valueOf(this.functionDeployEnvironmentId));
        sb.append(", dockerImageDeployArtifactId=").append(String.valueOf(this.dockerImageDeployArtifactId));
        sb.append(", config=").append(String.valueOf(this.config));
        sb.append(", maxMemoryInMBs=").append(String.valueOf(this.maxMemoryInMBs));
        sb.append(", functionTimeoutInSeconds=").append(String.valueOf(this.functionTimeoutInSeconds));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateFunctionDeployStageDetails)) {
            return false;
        }
        UpdateFunctionDeployStageDetails other = (UpdateFunctionDeployStageDetails)((Object)o);
        return Objects.equals(this.functionDeployEnvironmentId, other.functionDeployEnvironmentId) && Objects.equals(this.dockerImageDeployArtifactId, other.dockerImageDeployArtifactId) && Objects.equals(this.config, other.config) && Objects.equals(this.maxMemoryInMBs, other.maxMemoryInMBs) && Objects.equals(this.functionTimeoutInSeconds, other.functionTimeoutInSeconds) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.functionDeployEnvironmentId == null ? 43 : this.functionDeployEnvironmentId.hashCode());
        result = result * 59 + (this.dockerImageDeployArtifactId == null ? 43 : this.dockerImageDeployArtifactId.hashCode());
        result = result * 59 + (this.config == null ? 43 : this.config.hashCode());
        result = result * 59 + (this.maxMemoryInMBs == null ? 43 : this.maxMemoryInMBs.hashCode());
        result = result * 59 + (this.functionTimeoutInSeconds == null ? 43 : this.functionTimeoutInSeconds.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="deployStagePredecessorCollection")
        private DeployStagePredecessorCollection deployStagePredecessorCollection;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="functionDeployEnvironmentId")
        private String functionDeployEnvironmentId;
        @JsonProperty(value="dockerImageDeployArtifactId")
        private String dockerImageDeployArtifactId;
        @JsonProperty(value="config")
        private Map<String, String> config;
        @JsonProperty(value="maxMemoryInMBs")
        private Long maxMemoryInMBs;
        @JsonProperty(value="functionTimeoutInSeconds")
        private Integer functionTimeoutInSeconds;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder deployStagePredecessorCollection(DeployStagePredecessorCollection deployStagePredecessorCollection) {
            this.deployStagePredecessorCollection = deployStagePredecessorCollection;
            this.__explicitlySet__.add("deployStagePredecessorCollection");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder functionDeployEnvironmentId(String functionDeployEnvironmentId) {
            this.functionDeployEnvironmentId = functionDeployEnvironmentId;
            this.__explicitlySet__.add("functionDeployEnvironmentId");
            return this;
        }

        public Builder dockerImageDeployArtifactId(String dockerImageDeployArtifactId) {
            this.dockerImageDeployArtifactId = dockerImageDeployArtifactId;
            this.__explicitlySet__.add("dockerImageDeployArtifactId");
            return this;
        }

        public Builder config(Map<String, String> config) {
            this.config = config;
            this.__explicitlySet__.add("config");
            return this;
        }

        public Builder maxMemoryInMBs(Long maxMemoryInMBs) {
            this.maxMemoryInMBs = maxMemoryInMBs;
            this.__explicitlySet__.add("maxMemoryInMBs");
            return this;
        }

        public Builder functionTimeoutInSeconds(Integer functionTimeoutInSeconds) {
            this.functionTimeoutInSeconds = functionTimeoutInSeconds;
            this.__explicitlySet__.add("functionTimeoutInSeconds");
            return this;
        }

        public UpdateFunctionDeployStageDetails build() {
            UpdateFunctionDeployStageDetails model = new UpdateFunctionDeployStageDetails(this.description, this.displayName, this.deployStagePredecessorCollection, this.freeformTags, this.definedTags, this.functionDeployEnvironmentId, this.dockerImageDeployArtifactId, this.config, this.maxMemoryInMBs, this.functionTimeoutInSeconds);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(UpdateFunctionDeployStageDetails model) {
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("deployStagePredecessorCollection")) {
                this.deployStagePredecessorCollection(model.getDeployStagePredecessorCollection());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("functionDeployEnvironmentId")) {
                this.functionDeployEnvironmentId(model.getFunctionDeployEnvironmentId());
            }
            if (model.wasPropertyExplicitlySet("dockerImageDeployArtifactId")) {
                this.dockerImageDeployArtifactId(model.getDockerImageDeployArtifactId());
            }
            if (model.wasPropertyExplicitlySet("config")) {
                this.config(model.getConfig());
            }
            if (model.wasPropertyExplicitlySet("maxMemoryInMBs")) {
                this.maxMemoryInMBs(model.getMaxMemoryInMBs());
            }
            if (model.wasPropertyExplicitlySet("functionTimeoutInSeconds")) {
                this.functionTimeoutInSeconds(model.getFunctionTimeoutInSeconds());
            }
            return this;
        }
    }
}

