/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.wizards;

import java.awt.BorderLayout;
import java.nio.charset.Charset;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.MutableComboBoxModel;
import javax.swing.event.ChangeEvent;
import org.netbeans.modules.php.api.PhpVersion;
import org.netbeans.modules.php.project.ui.LocalServer;
import org.netbeans.modules.php.project.ui.LocalServerController;
import org.netbeans.modules.php.project.ui.Utils;
import org.netbeans.modules.php.project.ui.options.PhpOptions;
import org.netbeans.modules.php.project.ui.wizards.ConfigurableProjectPanel;
import org.netbeans.modules.php.project.ui.wizards.ConfigureProjectPanel;
import org.netbeans.modules.php.project.ui.wizards.NewPhpProjectWizardIterator;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

class ConfigureNewProjectPanelVisual
extends ConfigurableProjectPanel {
    private static final long serialVersionUID = 5558754132375479L;
    private final LocalServerController localServerComponent;
    private JComboBox<Charset> encodingComboBox;
    private JLabel encodingLabel;
    private JButton localServerButton;
    private JComboBox<LocalServer> localServerComboBox;
    private JLabel localServerInfoLabel;
    private JComboBox<PhpVersion> phpVersionComboBox;
    private JLabel phpVersionInfoLabel;
    private JLabel phpVersionLabel;
    private JPanel projectFolderPanel;
    private JLabel projectNameLabel;
    protected JTextField projectNameTextField;
    private JSeparator separator;
    private JLabel sourcesLabel;

    ConfigureNewProjectPanelVisual(ConfigureProjectPanel wizardPanel) {
        super(wizardPanel);
        this.initComponents();
        this.localServerComponent = LocalServerController.create(this.localServerComboBox, this.localServerButton, new BrowseSources(), NbBundle.getMessage(ConfigureNewProjectPanelVisual.class, (String)"LBL_SelectSourceFolderTitle"), new LocalServer[0]);
        this.projectFolderPanel.add("Center", this.projectFolderComponent);
        this.init(wizardPanel.getWizardType());
    }

    private void init(NewPhpProjectWizardIterator.WizardType wizardType) {
        this.projectNameTextField.getDocument().addDocumentListener(this);
        this.localServerComponent.addChangeListener(this);
        this.phpVersionComboBox.setModel(new Utils.PhpVersionComboBoxModel(wizardType.equals((Object)NewPhpProjectWizardIterator.WizardType.NEW) ? PhpOptions.getInstance().getDefaultPhpVersion() : PhpVersion.getLegacy()));
        this.encodingComboBox.setModel(ProjectCustomizer.encodingModel((String)Charset.defaultCharset().name()));
        this.encodingComboBox.setRenderer(ProjectCustomizer.encodingRenderer());
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.projectNameTextField.requestFocus();
    }

    private void initComponents() {
        this.projectNameLabel = new JLabel();
        this.projectNameTextField = new JTextField();
        this.sourcesLabel = new JLabel();
        this.localServerComboBox = new JComboBox();
        this.localServerButton = new JButton();
        this.localServerInfoLabel = new JLabel();
        this.phpVersionLabel = new JLabel();
        this.phpVersionComboBox = new JComboBox();
        this.phpVersionInfoLabel = new JLabel();
        this.encodingLabel = new JLabel();
        this.encodingComboBox = new JComboBox();
        this.separator = new JSeparator();
        this.projectFolderPanel = new JPanel();
        this.projectNameLabel.setHorizontalAlignment(2);
        this.projectNameLabel.setLabelFor(this.projectNameTextField);
        Mnemonics.setLocalizedText((JLabel)this.projectNameLabel, (String)NbBundle.getMessage(ConfigureNewProjectPanelVisual.class, (String)"LBL_ProjectName"));
        this.projectNameLabel.setVerticalAlignment(1);
        this.projectNameTextField.setColumns(20);
        this.sourcesLabel.setLabelFor(this.localServerComboBox);
        Mnemonics.setLocalizedText((JLabel)this.sourcesLabel, (String)NbBundle.getMessage(ConfigureNewProjectPanelVisual.class, (String)"LBL_Sources"));
        this.sourcesLabel.setVerticalAlignment(1);
        this.localServerComboBox.setEditable(true);
        Mnemonics.setLocalizedText((AbstractButton)this.localServerButton, (String)NbBundle.getMessage(ConfigureNewProjectPanelVisual.class, (String)"LBL_LocalServerBrowse"));
        Mnemonics.setLocalizedText((JLabel)this.localServerInfoLabel, (String)"dummy");
        Mnemonics.setLocalizedText((JLabel)this.phpVersionLabel, (String)NbBundle.getMessage(ConfigureNewProjectPanelVisual.class, (String)"ConfigureNewProjectPanelVisual.phpVersionLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.phpVersionInfoLabel, (String)NbBundle.getMessage(ConfigureNewProjectPanelVisual.class, (String)"ConfigureNewProjectPanelVisual.phpVersionInfoLabel.text"));
        this.encodingLabel.setLabelFor(this.encodingComboBox);
        Mnemonics.setLocalizedText((JLabel)this.encodingLabel, (String)NbBundle.getMessage(ConfigureNewProjectPanelVisual.class, (String)"LBL_Encoding"));
        this.projectFolderPanel.setLayout(new BorderLayout());
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.separator).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.projectNameLabel).addComponent(this.sourcesLabel).addComponent(this.encodingLabel).addComponent(this.phpVersionLabel)).addGap(24, 24, 24).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.phpVersionInfoLabel).addContainerGap()).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.phpVersionComboBox, 0, -1, Short.MAX_VALUE).addComponent(this.projectNameTextField, -2, 1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.localServerComboBox, 0, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.localServerButton)).addGroup(layout.createSequentialGroup().addComponent(this.localServerInfoLabel).addContainerGap()).addComponent(this.encodingComboBox, 0, -1, Short.MAX_VALUE)))).addComponent(this.projectFolderPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(0, 0, 0).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.projectNameTextField, -2, -1, -2).addComponent(this.projectNameLabel)).addGap(7, 7, 7).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.localServerComboBox, -2, -1, -2).addComponent(this.localServerButton).addComponent(this.sourcesLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.localServerInfoLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.phpVersionComboBox, -2, -1, -2).addComponent(this.phpVersionLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.phpVersionInfoLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.encodingComboBox, -2, -1, -2).addComponent(this.encodingLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.separator, -2, 2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.projectFolderPanel, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.projectNameLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ConfigureNewProjectPanelVisual.class, (String)"ConfigureNewProjectPanelVisual.projectNameLabel.AccessibleContext.accessibleName"));
        this.projectNameLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConfigureNewProjectPanelVisual.class, (String)"ConfigureNewProjectPanelVisual.projectNameLabel.AccessibleContext.accessibleDescription"));
        this.projectNameTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ConfigureNewProjectPanelVisual.class, (String)"ConfigureNewProjectPanelVisual.projectNameTextField.AccessibleContext.accessibleName"));
        this.projectNameTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConfigureNewProjectPanelVisual.class, (String)"ConfigureNewProjectPanelVisual.projectNameTextField.AccessibleContext.accessibleDescription"));
        this.sourcesLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ConfigureNewProjectPanelVisual.class, (String)"ConfigureNewProjectPanelVisual.sourcesLabel.AccessibleContext.accessibleName"));
        this.sourcesLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConfigureNewProjectPanelVisual.class, (String)"ConfigureNewProjectPanelVisual.sourcesLabel.AccessibleContext.accessibleDescription"));
        this.localServerComboBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ConfigureNewProjectPanelVisual.class, (String)"ConfigureNewProjectPanelVisual.localServerComboBox.AccessibleContext.accessibleName"));
        this.localServerComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConfigureNewProjectPanelVisual.class, (String)"ConfigureNewProjectPanelVisual.localServerComboBox.AccessibleContext.accessibleDescription"));
        this.localServerButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ConfigureNewProjectPanelVisual.class, (String)"ConfigureNewProjectPanelVisual.localServerButton.AccessibleContext.accessibleName"));
        this.localServerButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConfigureNewProjectPanelVisual.class, (String)"ConfigureNewProjectPanelVisual.localServerButton.AccessibleContext.accessibleDescription"));
        this.localServerInfoLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ConfigureNewProjectPanelVisual.class, (String)"ConfigureNewProjectPanelVisual.localServerInfoLabel.AccessibleContext.accessibleName"));
        this.localServerInfoLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConfigureNewProjectPanelVisual.class, (String)"ConfigureNewProjectPanelVisual.localServerInfoLabel.AccessibleContext.accessibleDescription"));
        this.phpVersionLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ConfigureNewProjectPanelVisual.class, (String)"ConfigureNewProjectPanelVisual.phpVersionLabel.AccessibleContext.accessibleName"));
        this.phpVersionLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConfigureNewProjectPanelVisual.class, (String)"ConfigureNewProjectPanelVisual.phpVersionLabel.AccessibleContext.accessibleDescription"));
        this.phpVersionComboBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ConfigureNewProjectPanelVisual.class, (String)"ConfigureNewProjectPanelVisual.phpVersionComboBox.AccessibleContext.accessibleName"));
        this.phpVersionComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConfigureNewProjectPanelVisual.class, (String)"ConfigureNewProjectPanelVisual.phpVersionComboBox.AccessibleContext.accessibleDescription"));
        this.phpVersionInfoLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ConfigureNewProjectPanelVisual.class, (String)"ConfigureNewProjectPanelVisual.phpVersionInfoLabel.AccessibleContext.accessibleName"));
        this.phpVersionInfoLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConfigureNewProjectPanelVisual.class, (String)"ConfigureNewProjectPanelVisual.phpVersionInfoLabel.AccessibleContext.accessibleDescription"));
        this.encodingLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ConfigureNewProjectPanelVisual.class, (String)"ConfigureNewProjectPanelVisual.encodingLabel.AccessibleContext.accessibleName"));
        this.encodingLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConfigureNewProjectPanelVisual.class, (String)"ConfigureNewProjectPanelVisual.encodingLabel.AccessibleContext.accessibleDescription"));
        this.encodingComboBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ConfigureNewProjectPanelVisual.class, (String)"ConfigureNewProjectPanelVisual.encodingComboBox.AccessibleContext.accessibleName"));
        this.encodingComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConfigureNewProjectPanelVisual.class, (String)"ConfigureNewProjectPanelVisual.encodingComboBox.AccessibleContext.accessibleDescription"));
        this.separator.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ConfigureNewProjectPanelVisual.class, (String)"ConfigureNewProjectPanelVisual.separator.AccessibleContext.accessibleName"));
        this.separator.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConfigureNewProjectPanelVisual.class, (String)"ConfigureNewProjectPanelVisual.separator.AccessibleContext.accessibleDescription"));
        this.projectFolderPanel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ConfigureNewProjectPanelVisual.class, (String)"ConfigureNewProjectPanelVisual.projectFolderPanel.AccessibleContext.accessibleName"));
        this.projectFolderPanel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConfigureNewProjectPanelVisual.class, (String)"ConfigureNewProjectPanelVisual.projectFolderPanel.AccessibleContext.accessibleDescription"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ConfigureNewProjectPanelVisual.class, (String)"ConfigureNewProjectPanelVisual.AccessibleContext.accessibleName"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConfigureNewProjectPanelVisual.class, (String)"ConfigureNewProjectPanelVisual.AccessibleContext.accessibleDescription"));
    }

    @Override
    public String getProjectName() {
        return this.projectNameTextField.getText().trim();
    }

    @Override
    public void setProjectName(String projectName) {
        this.projectNameTextField.setText(projectName);
        this.projectNameTextField.selectAll();
    }

    @Override
    public String getSourcesFolder() {
        return this.localServerComponent.getLocalServer().getSrcRoot();
    }

    @Override
    public LocalServer getSourcesLocation() {
        return this.localServerComponent.getLocalServer();
    }

    @Override
    public MutableComboBoxModel<LocalServer> getLocalServerModel() {
        return this.localServerComponent.getLocalServerModel();
    }

    @Override
    public void setLocalServerModel(MutableComboBoxModel<LocalServer> localServers) {
        this.localServerComponent.setLocalServerModel(localServers);
    }

    @Override
    public void selectSourcesLocation(LocalServer localServer) {
        this.localServerComponent.selectLocalServer(localServer);
    }

    @Override
    public PhpVersion getPhpVersion() {
        return (PhpVersion)this.phpVersionComboBox.getSelectedItem();
    }

    @Override
    public void setPhpVersion(PhpVersion phpVersion) {
        this.phpVersionComboBox.setSelectedItem(phpVersion);
    }

    @Override
    public Charset getEncoding() {
        return (Charset)this.encodingComboBox.getSelectedItem();
    }

    @Override
    public void setEncoding(Charset encoding) {
        this.encodingComboBox.setSelectedItem(encoding);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        String hint = this.localServerComponent.getLocalServer().getHint();
        this.localServerInfoLabel.setText(hint);
        super.stateChanged(e);
    }

    @Override
    public void setState(boolean enabled) {
        this.projectNameTextField.setEnabled(enabled);
        this.localServerComponent.setEnabled(enabled);
    }

    @Override
    public boolean getState() {
        return this.projectNameTextField.isEnabled();
    }

    private static class BrowseSources
    implements LocalServerController.BrowseHandler {
        private BrowseSources() {
        }

        @Override
        public String getDirKey() {
            return "nb.php.localServer.documentRoot";
        }
    }
}

