/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.cdnjs;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.project.Project;
import org.netbeans.modules.javascript.cdnjs.Bundle;
import org.netbeans.modules.javascript.cdnjs.Library;
import org.netbeans.modules.javascript.cdnjs.LibraryPersistence;
import org.netbeans.modules.javascript.cdnjs.LibraryProvider;
import org.netbeans.modules.javascript.cdnjs.LibraryUtils;
import org.netbeans.modules.javascript.cdnjs.ui.SelectionPanel;
import org.netbeans.modules.web.common.api.WebUtils;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;

public class LibraryCustomizer
implements ProjectCustomizer.CompositeCategoryProvider {
    public static final String CATEGORY_NAME = "CDNJS";
    private final boolean checkWebRoot;

    public LibraryCustomizer() {
        this(false);
    }

    public LibraryCustomizer(boolean checkWebRoot) {
        this.checkWebRoot = checkWebRoot;
    }

    public ProjectCustomizer.Category createCategory(Lookup context) {
        if (this.checkWebRoot && !WebUtils.hasWebRoot((Project)((Project)context.lookup(Project.class)))) {
            return null;
        }
        return ProjectCustomizer.Category.create((String)CATEGORY_NAME, (String)Bundle.LibraryCustomizer_displayName(), null, (ProjectCustomizer.Category[])new ProjectCustomizer.Category[0]);
    }

    public JComponent createComponent(ProjectCustomizer.Category category, Lookup context) {
        Project project = (Project)context.lookup(Project.class);
        Library.Version[] libraries = LibraryPersistence.getDefault().loadLibraries(project);
        File webRoot = LibraryUtils.getWebRoot(project);
        assert (webRoot != null) : project;
        String libraryFolder = LibraryUtils.getLibraryFolder(project);
        SelectionPanel customizer = new SelectionPanel(project, libraries, webRoot, libraryFolder);
        category.setStoreListener((ActionListener)new StoreListener(project, webRoot, customizer));
        return customizer;
    }

    private static class StoreListener
    implements ActionListener,
    Runnable {
        static final Logger LOGGER = Logger.getLogger(StoreListener.class.getName());
        private final Project project;
        private final File webRoot;
        private final SelectionPanel customizer;
        private ProgressHandle progressHandle;

        StoreListener(Project project, File webRoot, SelectionPanel customizer) {
            this.project = project;
            this.webRoot = webRoot;
            this.customizer = customizer;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RequestProcessor.getDefault().post((Runnable)this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.progressHandle = ProgressHandle.createHandle((String)Bundle.LibraryCustomizer_updatingLibraries());
            this.progressHandle.start();
            try {
                Library.Version[] selectedVersions = this.customizer.getSelectedLibraries();
                Library.Version[] versionsToStore = this.updateLibraries(selectedVersions);
                try {
                    LibraryPersistence.getDefault().storeLibraries(this.project, versionsToStore);
                }
                catch (IOException ex) {
                    Logger.getLogger(StoreListener.class.getName()).log(Level.INFO, "Cannot store libraries", ex);
                }
                String libraryFolder = this.customizer.getLibraryFolder();
                LibraryUtils.storeLibraryFolder(this.project, libraryFolder);
            }
            finally {
                this.progressHandle.finish();
            }
        }

        private Library.Version[] updateLibraries(Library.Version[] newLibraries) {
            String oldLibraryFolder;
            ArrayList<String> errors = new ArrayList<String>();
            Library.Version[] oldLibraries = LibraryPersistence.getDefault().loadLibraries(this.project);
            Map<String, Library.Version> oldMap = this.toMap(oldLibraries);
            Map<String, Library.Version> newMap = this.toMap(newLibraries);
            ArrayList<Library.Version> toInstall = new ArrayList<Library.Version>();
            ArrayList<String> toKeep = new ArrayList<String>();
            for (Library.Version newVersion : newLibraries) {
                String libraryName = newVersion.getLibrary().getName();
                Library.Version oldVersion = oldMap.get(libraryName);
                if (oldVersion == null) {
                    toInstall.add(newVersion);
                    continue;
                }
                if (oldVersion.getName().equals(newVersion.getName())) {
                    toKeep.add(libraryName);
                    continue;
                }
                toInstall.add(newVersion);
            }
            HashMap<String, File[]> downloadedFiles = new HashMap<String, File[]>();
            for (Library.Version version : toInstall) {
                String libraryName = version.getLibrary().getName();
                try {
                    String[] fileNames = version.getFiles();
                    File[] files = new File[fileNames.length];
                    for (int fileIndex = 0; fileIndex < files.length; ++fileIndex) {
                        this.progressHandle.progress(Bundle.LibraryCustomizer_downloadingFile(libraryName, fileNames[fileIndex]));
                        files[fileIndex] = LibraryProvider.getInstance().downloadLibraryFile(version, fileIndex);
                    }
                    downloadedFiles.put(libraryName, files);
                }
                catch (IOException ioex) {
                    String errorMessage = Bundle.LibraryCustomizer_downloadFailed(libraryName, version.getName());
                    errors.add(errorMessage);
                    Logger.getLogger(LibraryCustomizer.class.getName()).log(Level.INFO, errorMessage, ioex);
                    Library.Version oldVersion = oldMap.get(libraryName);
                    if (oldVersion == null) {
                        newMap.remove(libraryName);
                        continue;
                    }
                    newMap.put(libraryName, oldVersion);
                }
            }
            ArrayList<Library.Version> toRemove = new ArrayList<Library.Version>();
            for (Library.Version oldVersion : oldLibraries) {
                String libraryName = oldVersion.getLibrary().getName();
                Library.Version newVersion = newMap.get(libraryName);
                if (newVersion != null && newVersion.getName().equals(oldVersion.getName())) continue;
                toRemove.add(oldVersion);
                oldMap.remove(libraryName);
            }
            this.uninstallLibraries(toRemove);
            FileObject librariesFob = null;
            if (!(toInstall.isEmpty() && toKeep.isEmpty() || (librariesFob = this.createLibrariesFolder(errors)) != null)) {
                this.reportErrors(errors);
                return oldMap.values().toArray(new Library.Version[oldMap.size()]);
            }
            for (Library.Version version : toInstall) {
                String libraryName = version.getLibrary().getName();
                File[] files = (File[])downloadedFiles.get(libraryName);
                if (files == null) continue;
                try {
                    this.installLibrary(librariesFob, version, files);
                    newMap.put(libraryName, version);
                }
                catch (IOException ioex) {
                    String errorMessage = Bundle.LibraryCustomizer_installationFailed(libraryName, version.getName());
                    errors.add(errorMessage);
                    Logger.getLogger(LibraryCustomizer.class.getName()).log(Level.INFO, errorMessage, ioex);
                    newMap.remove(libraryName);
                }
            }
            String newLibraryFolder = this.customizer.getLibraryFolder();
            boolean libFolderChanged = !newLibraryFolder.equals(oldLibraryFolder = LibraryUtils.getLibraryFolder(this.project));
            for (String libraryName : toKeep) {
                Library.Version newVersion;
                Library.Version versionToStore;
                Library.Version oldVersion = oldMap.get(libraryName);
                if (libFolderChanged) {
                    this.moveLibrary(librariesFob, oldVersion, errors);
                }
                if ((versionToStore = this.updateLibrary(librariesFob, oldVersion, newVersion = newMap.get(libraryName), errors)) == null) continue;
                newMap.put(libraryName, versionToStore);
            }
            this.reportErrors(errors);
            return newMap.values().toArray(new Library.Version[newMap.size()]);
        }

        private void reportErrors(List<String> errors) {
            if (!errors.isEmpty()) {
                StringBuilder message = new StringBuilder();
                for (String error : errors) {
                    if (message.length() != 0) {
                        message.append('\n');
                    }
                    message.append(error);
                }
                NotifyDescriptor.Message descriptor = new NotifyDescriptor.Message((Object)message.toString(), 0);
                DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)descriptor);
            }
        }

        private FileObject createLibrariesFolder(List<String> errors) {
            this.progressHandle.progress(Bundle.LibraryCustomizer_creatingLibraryFolder());
            FileObject librariesFob = null;
            try {
                String librariesFolderName = this.customizer.getLibraryFolder();
                FileObject webRootFob = FileUtil.toFileObject((File)this.webRoot);
                librariesFob = FileUtil.createFolder((FileObject)webRootFob, (String)librariesFolderName);
            }
            catch (IOException ioex) {
                String errorMessage = Bundle.LibraryCustomizer_libraryFolderFailure();
                errors.add(errorMessage);
                Logger.getLogger(LibraryCustomizer.class.getName()).log(Level.INFO, errorMessage, ioex);
            }
            return librariesFob;
        }

        private void moveLibrary(FileObject librariesFolder, Library.Version version, List<String> errors) {
            String libraryName = version.getLibrary().getName();
            this.progressHandle.progress(Bundle.LibraryCustomizer_movingLibrary(libraryName));
            FileObject projectFob = this.project.getProjectDirectory();
            try {
                FileObject libraryFolder = FileUtil.createFolder((FileObject)librariesFolder, (String)libraryName);
                File projectDir = FileUtil.toFile((FileObject)projectFob);
                String[] files = version.getFiles();
                String[] localFiles = version.getLocalFiles();
                for (int i = 0; i < files.length; ++i) {
                    File file = PropertyUtils.resolveFile((File)projectDir, (String)localFiles[i]);
                    if (!file.exists()) continue;
                    try {
                        FileObject fob = FileUtil.toFileObject((File)file);
                        String[] pathElements = files[i].split("/");
                        FileObject fileFolder = libraryFolder;
                        for (int j = 0; j < pathElements.length - 1; ++j) {
                            fileFolder = FileUtil.createFolder((FileObject)fileFolder, (String)pathElements[j]);
                        }
                        String fileName = pathElements[pathElements.length - 1];
                        fob = FileUtil.moveFile((FileObject)fob, (FileObject)fileFolder, (String)fileName);
                        localFiles[i] = PropertyUtils.relativizeFile((File)projectDir, (File)FileUtil.toFile((FileObject)fob));
                        this.removeFile(file.getParentFile());
                        continue;
                    }
                    catch (IOException ioex) {
                        String errorMessage = Bundle.LibraryCustomizer_moveFailed(libraryName, files[i]);
                        errors.add(errorMessage);
                        Logger.getLogger(LibraryCustomizer.class.getName()).log(Level.INFO, errorMessage, ioex);
                    }
                }
            }
            catch (IOException ioex) {
                String errorMessage = Bundle.LibraryCustomizer_libraryFolderCreationFailed(libraryName);
                errors.add(errorMessage);
                Logger.getLogger(LibraryCustomizer.class.getName()).log(Level.INFO, errorMessage, ioex);
            }
        }

        @CheckForNull
        private Library.Version updateLibrary(FileObject librariesFolder, Library.Version oldVersion, Library.Version newVersion, List<String> errors) {
            FileObject projectFob = this.project.getProjectDirectory();
            File projectDir = FileUtil.toFile((FileObject)projectFob);
            LibraryProvider libraryProvider = LibraryProvider.getInstance();
            String libraryName = oldVersion.getLibrary().getName();
            FileObject libraryFolder = librariesFolder.getFileObject(libraryName);
            if (libraryFolder == null) {
                assert (LibraryUtils.isBroken(this.project, oldVersion)) : "This library should be broken: " + oldVersion.getLibrary().getName();
                try {
                    libraryFolder = FileUtil.createFolder((FileObject)librariesFolder, (String)libraryName);
                }
                catch (IOException ex) {
                    LOGGER.log(Level.INFO, "Cannot created folder '" + libraryName + "' in '" + FileUtil.getFileDisplayName((FileObject)librariesFolder) + "'", ex);
                    errors.add(Bundle.LibraryCustomizer_folderNotCreated(libraryName));
                    return null;
                }
            }
            HashMap<String, String> oldFilesMap = new HashMap<String, String>();
            String[] oldFiles = oldVersion.getFiles();
            String[] oldLocalFiles = oldVersion.getLocalFiles();
            for (int i = 0; i < oldFiles.length; ++i) {
                File file = PropertyUtils.resolveFile((File)projectDir, (String)oldLocalFiles[i]);
                if (!file.exists()) continue;
                oldFilesMap.put(oldFiles[i], oldLocalFiles[i]);
            }
            ArrayList<String> fileList = new ArrayList<String>();
            ArrayList<String> localFileList = new ArrayList<String>();
            String[] filesToInstall = newVersion.getFiles();
            for (int fileIndex = 0; fileIndex < filesToInstall.length; ++fileIndex) {
                String filePath = filesToInstall[fileIndex];
                try {
                    String localPath = (String)oldFilesMap.get(filePath);
                    if (localPath == null) {
                        String[] pathElements = filePath.split("/");
                        FileObject fileFolder = libraryFolder;
                        for (int j = 0; j < pathElements.length - 1; ++j) {
                            fileFolder = FileUtil.createFolder((FileObject)fileFolder, (String)pathElements[j]);
                        }
                        this.progressHandle.progress(Bundle.LibraryCustomizer_downloadingFile(libraryName, filePath));
                        File file = libraryProvider.downloadLibraryFile(newVersion, fileIndex);
                        FileObject tmpFob = FileUtil.toFileObject((File)file);
                        String fileName = pathElements[pathElements.length - 1];
                        FileObject fob = FileUtil.copyFile((FileObject)tmpFob, (FileObject)fileFolder, (String)fileName);
                        if (!file.delete()) {
                            LOGGER.log(Level.INFO, "Cannot delete file {0}", file);
                        }
                        localPath = PropertyUtils.relativizeFile((File)projectDir, (File)FileUtil.toFile((FileObject)fob));
                    }
                    fileList.add(filePath);
                    localFileList.add(localPath);
                    continue;
                }
                catch (IOException ioex) {
                    String errorMessage = Bundle.LibraryCustomizer_updateFailed(libraryName, filePath);
                    errors.add(errorMessage);
                    LOGGER.log(Level.INFO, errorMessage, ioex);
                    return null;
                }
            }
            for (int i = 0; i < oldFiles.length; ++i) {
                if (fileList.contains(oldFiles[i])) continue;
                this.progressHandle.progress(Bundle.LibraryCustomizer_deletingFile(libraryName, oldLocalFiles[i]));
                this.uninstallFile(oldLocalFiles[i]);
            }
            Library.Version versionToStore = newVersion.filterVersion(Collections.emptySet());
            versionToStore.setFileInfo((String[])fileList.toArray(String[]::new), (String[])localFileList.toArray(String[]::new));
            return versionToStore;
        }

        private void uninstallLibraries(List<Library.Version> libraries) {
            for (Library.Version version : libraries) {
                this.progressHandle.progress(Bundle.LibraryCustomizer_removingLibrary(version.getLibrary().getName(), version.getName()));
                for (String fileName : version.getLocalFiles()) {
                    this.uninstallFile(fileName);
                }
            }
        }

        private void removeFile(File file) {
            File targetFile = file;
            while (!this.webRoot.equals(targetFile)) {
                File parent = targetFile.getParentFile();
                if (!targetFile.delete()) break;
                targetFile = parent;
            }
        }

        private void uninstallFile(String filePath) {
            File projectDir = FileUtil.toFile((FileObject)this.project.getProjectDirectory());
            File file = PropertyUtils.resolveFile((File)projectDir, (String)filePath);
            if (file.exists()) {
                this.removeFile(file);
            } else {
                Logger.getLogger(LibraryCustomizer.class.getName()).log(Level.INFO, "Cannot delete file {0}. It no longer exists.", new Object[]{file.getAbsolutePath()});
            }
        }

        private void installLibrary(FileObject librariesFolder, Library.Version version, File[] libraryFiles) throws IOException {
            this.progressHandle.progress(Bundle.LibraryCustomizer_installingLibrary(version.getLibrary().getName(), version.getName()));
            String libraryName = version.getLibrary().getName();
            FileObject libraryFob = FileUtil.createFolder((FileObject)librariesFolder, (String)libraryName);
            FileObject projectFob = this.project.getProjectDirectory();
            File projectDir = FileUtil.toFile((FileObject)projectFob);
            String[] fileNames = version.getFiles();
            String[] localFiles = new String[fileNames.length];
            for (int i = 0; i < fileNames.length; ++i) {
                FileObject tmpFob = FileUtil.toFileObject((File)libraryFiles[i]);
                String fileName = fileNames[i];
                String[] path = fileName.split("/");
                FileObject fileFolder = libraryFob;
                for (int j = 0; j < path.length - 1; ++j) {
                    fileFolder = FileUtil.createFolder((FileObject)fileFolder, (String)path[j]);
                }
                FileObject fob = FileUtil.copyFile((FileObject)tmpFob, (FileObject)fileFolder, (String)path[path.length - 1]);
                if (!libraryFiles[i].delete()) {
                    LOGGER.log(Level.INFO, "Cannot delete file {0}", libraryFiles[i]);
                }
                File file = FileUtil.toFile((FileObject)fob);
                localFiles[i] = PropertyUtils.relativizeFile((File)projectDir, (File)file);
            }
            version.setFileInfo(fileNames, localFiles);
        }

        private Map<String, Library.Version> toMap(Library.Version[] libraries) {
            HashMap<String, Library.Version> map = new HashMap<String, Library.Version>();
            for (Library.Version library : libraries) {
                map.put(library.getLibrary().getName(), library);
            }
            return map;
        }
    }
}

