/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jshell.maven;

import java.io.IOException;
import org.netbeans.api.project.Project;
import org.netbeans.modules.jshell.support.SnippetStorage;
import org.netbeans.spi.project.AuxiliaryProperties;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;

public class MavenSnippetStorage
implements SnippetStorage {
    public static final String SNIPPET_FOLDER = "org.netbeans.jshell.snippetsRoot";
    private final Project project;
    private final Lookup lookup;

    public MavenSnippetStorage(Project project, Lookup lookup) {
        this.project = project;
        this.lookup = lookup;
    }

    private String evaluate(String s) {
        AuxiliaryProperties props = (AuxiliaryProperties)this.project.getLookup().lookup(AuxiliaryProperties.class);
        return props.get(s, true);
    }

    private String[] snippetsFolderName() {
        String val = this.evaluate(SNIPPET_FOLDER);
        if (val == null) {
            return null;
        }
        int lastSlash = val.lastIndexOf(47);
        if (lastSlash == -1 || lastSlash == val.length() - 1) {
            return new String[]{null, val, val};
        }
        return new String[]{val.substring(0, lastSlash), val.substring(lastSlash + 1), val};
    }

    @Override
    public FileObject getStorageFolder(boolean createIfMissing) {
        FileObject snippets;
        FileObject root = this.project.getProjectDirectory();
        String[] place = this.snippetsFolderName();
        if (place == null) {
            return null;
        }
        FileObject fileObject = snippets = place[0] == null ? root : root.getFileObject(place[0]);
        if (snippets == null) {
            if (!createIfMissing) {
                return null;
            }
            try {
                FileObject target = FileUtil.createFolder((FileObject)this.project.getProjectDirectory(), (String)place[2]);
                return target.getParent();
            }
            catch (IOException ex) {
                return null;
            }
        }
        return snippets;
    }

    @Override
    public String resourcePrefix() {
        String[] place = this.snippetsFolderName();
        if (place == null) {
            return null;
        }
        return place[1];
    }

    @Override
    public String startupSnippets(String runAction) {
        return "startup";
    }
}

