/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.customizer;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.modules.apisupport.project.ui.ApisupportAntUIUtils;
import org.netbeans.modules.apisupport.project.ui.customizer.NbPropertyPanel;
import org.netbeans.modules.apisupport.project.ui.customizer.SingleModuleProperties;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.awt.Mnemonics;
import org.openide.modules.SpecificationVersion;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

final class CustomizerSources
extends NbPropertyPanel.Single {
    private boolean srcLevelValueBeingUpdated;
    private JLabel filler;
    private JLabel moduleSuite;
    private JTextField moduleSuiteValue;
    private JLabel prjFolder;
    private JTextField prjFolderValue;
    private JLabel srcLevel;
    private JComboBox srcLevelValue;

    CustomizerSources(SingleModuleProperties props, ProjectCustomizer.Category category) {
        super(props, CustomizerSources.class, category);
        this.initComponents();
        this.initAccessibility();
        this.refresh();
        this.srcLevelValue.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (CustomizerSources.this.srcLevelValueBeingUpdated) {
                    return;
                }
                String oldLevel = CustomizerSources.this.getProperty(CustomizerSources.this.getJavacLanguageLevelKey());
                String newLevel = (String)CustomizerSources.this.srcLevelValue.getSelectedItem();
                SpecificationVersion jdk5 = new SpecificationVersion("1.5");
                if (new SpecificationVersion(oldLevel).compareTo(jdk5) < 0 && new SpecificationVersion(newLevel).compareTo(jdk5) >= 0) {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (!ApisupportAntUIUtils.showAcceptCancelDialog(CustomizerSources.getMessage("CustomizerSources.title.enable_lint"), CustomizerSources.getMessage("CustomizerSources.text.enable_lint"), CustomizerSources.getMessage("CustomizerSources.button.enable_lint"), CustomizerSources.getMessage("CustomizerSources.button.skip_lint"), 3)) {
                                return;
                            }
                            Object options = CustomizerSources.this.getProperty("javac.compilerargs");
                            String added = "-Xlint -Xlint:-serial";
                            options = options == null || ((String)options).length() == 0 ? added : (String)options + " " + added;
                            CustomizerSources.this.setProperty("javac.compilerargs", (String)options);
                        }
                    });
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void refresh() {
        if (this.getProperties().getSuiteDirectoryPath() == null) {
            this.moduleSuite.setVisible(false);
            this.moduleSuiteValue.setVisible(false);
        } else {
            ApisupportAntUIUtils.setText(this.moduleSuiteValue, this.getProperties().getSuiteDirectoryPath());
        }
        assert (!this.srcLevelValueBeingUpdated);
        this.srcLevelValueBeingUpdated = true;
        try {
            String[] levels;
            this.srcLevelValue.removeAllItems();
            for (String level : levels = this.sourceLevels(this.getProperties().getActiveJavaPlatform())) {
                this.srcLevelValue.addItem(level);
            }
            this.srcLevelValue.setSelectedItem(this.getProperty(this.getJavacLanguageLevelKey()));
        }
        finally {
            this.srcLevelValueBeingUpdated = false;
        }
        ApisupportAntUIUtils.setText(this.prjFolderValue, this.getProperties().getProjectDirectory());
    }

    @Override
    public void store() {
        this.setProperty(this.getJavacLanguageLevelKey(), (String)this.srcLevelValue.getSelectedItem());
    }

    private String getJavacLanguageLevelKey() {
        return this.containsProperty("javac.release") ? "javac.release" : "javac.source";
    }

    private void initComponents() {
        this.prjFolder = new JLabel();
        this.srcLevel = new JLabel();
        this.srcLevelValue = new JComboBox();
        this.filler = new JLabel();
        this.prjFolderValue = new JTextField();
        this.moduleSuite = new JLabel();
        this.moduleSuiteValue = new JTextField();
        this.setLayout(new GridBagLayout());
        this.prjFolder.setLabelFor(this.prjFolderValue);
        Mnemonics.setLocalizedText((JLabel)this.prjFolder, (String)NbBundle.getMessage(CustomizerSources.class, (String)"LBL_ProjectFolder"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.add((Component)this.prjFolder, gridBagConstraints);
        this.srcLevel.setLabelFor(this.srcLevelValue);
        Mnemonics.setLocalizedText((JLabel)this.srcLevel, (String)NbBundle.getMessage(CustomizerSources.class, (String)"LBL_SourceLevel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(18, 0, 0, 12);
        this.add((Component)this.srcLevel, gridBagConstraints);
        this.srcLevelValue.setPrototypeDisplayValue("mmm");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(18, 0, 0, 0);
        this.add((Component)this.srcLevelValue, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.filler, gridBagConstraints);
        this.prjFolderValue.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.prjFolderValue, gridBagConstraints);
        this.moduleSuite.setLabelFor(this.moduleSuiteValue);
        Mnemonics.setLocalizedText((JLabel)this.moduleSuite, (String)NbBundle.getMessage(CustomizerSources.class, (String)"LBL_ModeleSuite"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 12);
        this.add((Component)this.moduleSuite, gridBagConstraints);
        this.moduleSuiteValue.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.moduleSuiteValue, gridBagConstraints);
    }

    private static String getMessage(String key) {
        return NbBundle.getMessage(CustomizerSources.class, (String)key);
    }

    private void initAccessibility() {
        this.srcLevelValue.getAccessibleContext().setAccessibleDescription(CustomizerSources.getMessage("ACS_SrcLevelValue"));
        this.moduleSuiteValue.getAccessibleContext().setAccessibleDescription(CustomizerSources.getMessage("ACS_ModuleSuiteValue"));
        this.prjFolderValue.getAccessibleContext().setAccessibleDescription(CustomizerSources.getMessage("ACS_PrjFolderValue"));
    }

    private String[] sourceLevels(JavaPlatform platform) {
        ArrayList<String> levels = new ArrayList<String>();
        levels.add("1.4");
        levels.add("1.5");
        levels.add("1.6");
        levels.add("1.7");
        levels.add("1.8");
        try {
            String platformVersion = platform.getSpecification().getVersion().toString();
            int maxLevel = Integer.parseInt(platformVersion.split("\\.")[0]);
            for (int level = 9; level <= maxLevel; ++level) {
                levels.add(Integer.toString(level));
            }
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return levels.toArray(new String[0]);
    }
}

