/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.elements;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.php.api.PhpVersion;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.editor.api.elements.ParameterElement;
import org.netbeans.modules.php.editor.api.elements.TypeNameResolver;
import org.netbeans.modules.php.editor.api.elements.TypeResolver;
import org.netbeans.modules.php.editor.elements.MethodElementImpl;
import org.netbeans.modules.php.editor.elements.PhpElementImpl;
import org.netbeans.modules.php.editor.elements.TypeNameResolverImpl;
import org.netbeans.modules.php.editor.elements.TypeResolverImpl;
import org.netbeans.modules.php.editor.model.impl.Type;
import org.netbeans.modules.php.editor.parser.astnodes.BodyDeclaration;
import org.openide.util.Exceptions;

public final class ParameterElementImpl
implements ParameterElement {
    private final String name;
    private final String defaultValue;
    private final String declaredType;
    private final String phpdocType;
    private final Set<TypeResolver> types;
    private final int offset;
    private final boolean isRawType;
    private final boolean isMandatory;
    private final boolean isReference;
    private final boolean isVariadic;
    private final boolean isUnionType;
    private final boolean isIntersectionType;
    private final int modifier;
    private boolean isMagicMethod = false;

    public ParameterElementImpl(String name, String defaultValue, int offset, String declaredType, String phpdocType, Set<TypeResolver> types, boolean isMandatory, boolean isRawType, boolean isReference, boolean isVariadic, boolean isUnionType, int modifier, boolean isIntersectionType) {
        this.name = name;
        this.isMandatory = isMandatory;
        this.defaultValue = !isMandatory && defaultValue != null ? ParameterElementImpl.decode(defaultValue) : "";
        this.offset = offset;
        this.declaredType = declaredType;
        this.phpdocType = phpdocType != null ? ParameterElementImpl.decode(phpdocType) : null;
        this.types = types;
        this.isRawType = isRawType;
        this.isReference = isReference;
        this.isVariadic = isVariadic;
        this.isUnionType = isUnionType;
        this.isIntersectionType = isIntersectionType;
        this.modifier = modifier;
    }

    private ParameterElementImpl(Builder builder) {
        this.name = builder.name;
        this.isMandatory = builder.isMandatory;
        this.defaultValue = builder.defaultValue;
        this.offset = builder.offset;
        this.declaredType = builder.declaredType;
        this.phpdocType = builder.phpdocType;
        this.types = builder.types;
        this.isRawType = builder.isRawType;
        this.isReference = builder.isReference;
        this.isVariadic = builder.isVariadic;
        this.isUnionType = builder.isUnionType;
        this.isIntersectionType = builder.isIntersectionType;
        this.modifier = builder.modifier;
        this.isMagicMethod = builder.isMagicMethod;
    }

    static List<ParameterElement> parseParameters(String signature) {
        ArrayList<ParameterElement> retval = new ArrayList<ParameterElement>();
        if (signature != null && signature.length() > 0) {
            String regexp = String.format("\\%s", PhpElementImpl.Separator.COMMA.toString());
            for (String sign : signature.split(regexp)) {
                try {
                    ParameterElement param = ParameterElementImpl.parseOneParameter(sign);
                    if (param == null) continue;
                    retval.add(param);
                }
                catch (NumberFormatException originalException) {
                    String message = String.format("%s [for signature: %s]", originalException.getMessage(), signature);
                    NumberFormatException formatException = new NumberFormatException(message);
                    formatException.initCause(originalException);
                    throw formatException;
                }
            }
        }
        return retval;
    }

    private static ParameterElement parseOneParameter(String sig) {
        ParameterElementImpl retval = null;
        String regexp = String.format("\\%s", PhpElementImpl.Separator.COLON.toString());
        String[] parts = sig.split(regexp);
        if (parts.length > 0) {
            String paramName = parts[0];
            Set<TypeResolver> types = TypeResolverImpl.parseTypes(parts[1]);
            boolean isRawType = Integer.parseInt(parts[2]) > 0;
            boolean isMandatory = Integer.parseInt(parts[4]) > 0;
            boolean isReference = Integer.parseInt(parts[5]) > 0;
            boolean isVariadic = Integer.parseInt(parts[6]) > 0;
            boolean isUnionType = Integer.parseInt(parts[7]) > 0;
            int modifier = Integer.parseInt(parts[8]);
            boolean isIntersectionType = Integer.parseInt(parts[9]) > 0;
            String defValue = parts.length > 3 ? parts[3] : null;
            String declaredType = parts.length > 10 ? parts[10] : null;
            String phpdocType = parts.length > 11 ? parts[11] : null;
            retval = new ParameterElementImpl(paramName, defValue, -1, declaredType, phpdocType, types, isMandatory, isRawType, isReference, isVariadic, isUnionType, modifier, isIntersectionType);
        }
        return retval;
    }

    public String getSignature() {
        StringBuilder sb = new StringBuilder();
        String parameterName = this.getName().trim();
        assert (parameterName.equals(ParameterElementImpl.encode(parameterName))) : parameterName;
        sb.append(parameterName).append((Object)PhpElementImpl.Separator.COLON);
        StringBuilder typeBuilder = new StringBuilder();
        for (TypeResolver typeResolver : this.getTypes()) {
            TypeResolverImpl resolverImpl = (TypeResolverImpl)typeResolver;
            if (typeBuilder.length() > 0) {
                typeBuilder.append(Type.getTypeSeparator(this.isIntersectionType));
            }
            typeBuilder.append(resolverImpl.getSignature());
        }
        String typeSignatures = typeBuilder.toString().trim();
        sb.append(typeSignatures);
        sb.append((Object)PhpElementImpl.Separator.COLON);
        sb.append(this.isRawType ? 1 : 0);
        sb.append((Object)PhpElementImpl.Separator.COLON);
        if (!this.isMandatory()) {
            String defVal = this.getDefaultValue();
            assert (defVal != null);
            sb.append(ParameterElementImpl.encode(defVal));
        }
        sb.append((Object)PhpElementImpl.Separator.COLON);
        sb.append(this.isMandatory ? 1 : 0);
        sb.append((Object)PhpElementImpl.Separator.COLON);
        sb.append(this.isReference ? 1 : 0);
        sb.append((Object)PhpElementImpl.Separator.COLON);
        sb.append(this.isVariadic ? 1 : 0);
        sb.append((Object)PhpElementImpl.Separator.COLON);
        sb.append(this.isUnionType ? 1 : 0);
        sb.append((Object)PhpElementImpl.Separator.COLON);
        sb.append(this.modifier);
        sb.append((Object)PhpElementImpl.Separator.COLON);
        sb.append(this.isIntersectionType ? 1 : 0);
        sb.append((Object)PhpElementImpl.Separator.COLON);
        sb.append(this.declaredType != null ? this.declaredType : "");
        sb.append((Object)PhpElementImpl.Separator.COLON);
        sb.append(this.phpdocType != null ? ParameterElementImpl.encode(this.phpdocType) : "");
        this.checkSignature(sb);
        return sb.toString();
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Set<TypeResolver> getTypes() {
        return new LinkedHashSet<TypeResolver>(this.types);
    }

    @Override
    @CheckForNull
    public String getDeclaredType() {
        return this.declaredType;
    }

    @Override
    @CheckForNull
    public String getPhpdocType() {
        return this.phpdocType;
    }

    @Override
    public String getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public boolean hasDeclaredType() {
        return this.isRawType;
    }

    @Override
    public boolean isMandatory() {
        return this.isMandatory;
    }

    static String encode(String inStr) {
        return ParameterElementImpl.encode(inStr, PhpElementImpl.Separator.toEnumSet());
    }

    static String encode(String inStr, EnumSet<PhpElementImpl.Separator> separators) {
        StringBuilder outStr = new StringBuilder(6 * inStr.length());
        for (int i = 0; i < inStr.length(); ++i) {
            char charAt = inStr.charAt(i);
            boolean encode = ParameterElementImpl.isEncodedChar(i, inStr);
            if (!encode) {
                for (PhpElementImpl.Separator separator : separators) {
                    char separatorChar = separator.toString().charAt(0);
                    if (charAt != separatorChar) continue;
                    encode = true;
                    break;
                }
            }
            if (encode) {
                outStr.append(ParameterElementImpl.encodeChar(inStr.charAt(i)));
                continue;
            }
            outStr.append(inStr.charAt(i));
        }
        return outStr.toString();
    }

    private static String encodeChar(char ch) {
        String encChar = Integer.toString(ch, 16);
        return "\\u" + "0000".substring(0, "0000".length() - encChar.length()).concat(encChar);
    }

    private static String decode(String inStr) {
        StringBuilder outStr = new StringBuilder(inStr.length());
        try {
            for (int i = 0; i < inStr.length(); ++i) {
                if (ParameterElementImpl.isEncodedChar(i, inStr)) {
                    String decChar = inStr.substring(i + 2, i + 6);
                    outStr.append((char)Integer.parseInt(decChar, 16));
                    i += 5;
                    continue;
                }
                outStr.append(inStr.charAt(i));
            }
        }
        catch (NumberFormatException e) {
            Exceptions.printStackTrace((Throwable)e);
            return inStr;
        }
        return outStr.toString();
    }

    private static boolean isEncodedChar(int currentPosition, String inStr) {
        boolean isEncodedChar;
        boolean bl = isEncodedChar = currentPosition + 5 < inStr.length();
        if (isEncodedChar) {
            char c;
            isEncodedChar &= inStr.charAt(currentPosition) == '\\' && inStr.charAt(currentPosition + 1) == 'u';
            for (int i = currentPosition + 2; isEncodedChar && i < currentPosition + 6; isEncodedChar &= Character.digit(c = inStr.charAt(i), 16) != -1, ++i) {
            }
        }
        return isEncodedChar;
    }

    private void checkSignature(StringBuilder sb) {
        boolean checkEnabled = false;
        if (!$assertionsDisabled) {
            checkEnabled = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (checkEnabled) {
            String signature = sb.toString();
            try {
                String docType;
                ParameterElement parsedParameter = ParameterElementImpl.parseOneParameter(signature);
                assert (this.getName().equals(parsedParameter.getName())) : signature;
                assert (this.hasDeclaredType() == parsedParameter.hasDeclaredType()) : signature;
                String defValue = this.getDefaultValue();
                if (defValue != null) {
                    String paramDefaultValue = parsedParameter.getDefaultValue();
                    assert (paramDefaultValue != null && defValue.equals(paramDefaultValue)) : signature;
                }
                assert (this.isMandatory() == parsedParameter.isMandatory()) : signature;
                assert (this.isReference() == parsedParameter.isReference()) : signature;
                assert (this.isVariadic() == parsedParameter.isVariadic()) : signature;
                assert (this.isUnionType() == parsedParameter.isUnionType()) : signature;
                assert (this.getModifier() == parsedParameter.getModifier()) : signature;
                assert (this.isIntersectionType() == parsedParameter.isIntersectionType()) : signature;
                String declType = this.getDeclaredType();
                if (declType != null) {
                    String paramDeclaredType = parsedParameter.getDeclaredType();
                    assert (paramDeclaredType != null && declType.equals(paramDeclaredType)) : signature;
                }
                if ((docType = this.getPhpdocType()) != null) {
                    String paramPhpDocType = parsedParameter.getPhpdocType();
                    assert (paramPhpDocType != null && docType.equals(paramPhpDocType)) : "signature:" + signature + ", paramPhpDocType: " + paramPhpDocType + ", docType: " + docType;
                }
            }
            catch (NumberFormatException originalException) {
                String message = String.format("%s [for signature: %s]", originalException.getMessage(), signature);
                NumberFormatException formatException = new NumberFormatException(message);
                formatException.initCause(originalException);
                throw formatException;
            }
        }
    }

    @Override
    public OffsetRange getOffsetRange() {
        int endOffset = this.getOffset() + this.getName().length();
        return new OffsetRange(this.offset, endOffset);
    }

    @Override
    public String asString(ParameterElement.OutputType outputType) {
        return this.asString(outputType, TypeNameResolverImpl.forNull());
    }

    @Override
    public String asString(ParameterElement.OutputType outputType, TypeNameResolver typeNameResolver) {
        return this.asString(outputType, typeNameResolver, null);
    }

    @Override
    public String asString(ParameterElement.OutputType outputType, TypeNameResolver typeNameResolver, @NullAllowed PhpVersion phpVersion) {
        String modifierString;
        boolean forDeclaration;
        StringBuilder sb = new StringBuilder();
        Set<TypeResolver> typesResolvers = this.getTypes();
        boolean bl = forDeclaration = outputType == ParameterElement.OutputType.COMPLETE_DECLARATION || outputType == ParameterElement.OutputType.COMPLETE_DECLARATION_WITH_MODIFIER || outputType == ParameterElement.OutputType.SHORTEN_DECLARATION || outputType == ParameterElement.OutputType.SHORTEN_DECLARATION_WITH_MODIFIER;
        if (!(outputType != ParameterElement.OutputType.COMPLETE_DECLARATION_WITH_MODIFIER && outputType != ParameterElement.OutputType.SHORTEN_DECLARATION_WITH_MODIFIER || (modifierString = BodyDeclaration.Modifier.toString(this.modifier)) == null || modifierString.isEmpty())) {
            sb.append(modifierString).append(" ");
        }
        if (forDeclaration && this.hasDeclaredType() && StringUtils.hasText((String)this.getDeclaredType())) {
            String[] splitTypes = Type.splitTypes(this.getDeclaredType());
            ArrayList<String> resolvedTypes = new ArrayList<String>();
            if (this.isMagicMethod && phpVersion != null) {
                String validType = MethodElementImpl.getValidType(this.getDeclaredType(), phpVersion);
                if (StringUtils.hasText((String)validType)) {
                    sb.append(validType).append(' ');
                }
            } else if (splitTypes.length == typesResolvers.size()) {
                String template = Type.toTypeTemplate(this.getDeclaredType());
                for (TypeResolver typeResolver : typesResolvers) {
                    resolvedTypes.add(typeNameResolver.resolve(typeResolver.getTypeName(false)).toString());
                }
                sb.append(String.format(template, resolvedTypes.toArray(new String[0]))).append(' ');
            } else {
                sb.append(this.getDeclaredType()).append(' ');
            }
        }
        if (forDeclaration) {
            if (this.isReference()) {
                sb.append("&");
            }
            if (this.isVariadic()) {
                sb.append("...");
            }
        }
        sb.append(this.getName());
        if (forDeclaration) {
            String defVal = this.getDefaultValue();
            if (!this.isMandatory() && StringUtils.hasText((String)defVal)) {
                sb.append(" = ");
                if (outputType == ParameterElement.OutputType.COMPLETE_DECLARATION || outputType == ParameterElement.OutputType.COMPLETE_DECLARATION_WITH_MODIFIER) {
                    sb.append(defVal);
                } else {
                    sb.append(defVal.length() > 20 ? "..." : defVal);
                }
            }
        }
        return sb.toString();
    }

    @Override
    public boolean isReference() {
        return this.isReference;
    }

    @Override
    public boolean isVariadic() {
        return this.isVariadic;
    }

    @Override
    public boolean isUnionType() {
        return this.isUnionType;
    }

    @Override
    public int getModifier() {
        return this.modifier;
    }

    @Override
    public boolean isIntersectionType() {
        return this.isIntersectionType;
    }

    static class Builder {
        private final String name;
        private String defaultValue = null;
        private String declaredType = null;
        private String phpdocType = null;
        private Set<TypeResolver> types = Collections.emptySet();
        private int offset = 0;
        private int modifier = 0;
        private boolean isRawType = false;
        private boolean isMandatory = false;
        private boolean isReference = false;
        private boolean isVariadic = false;
        private boolean isUnionType = false;
        private boolean isIntersectionType = false;
        private boolean isMagicMethod = false;

        public Builder(String name) {
            this.name = name;
        }

        public ParameterElement build() {
            return new ParameterElementImpl(this);
        }

        public Builder defaultValue(@NullAllowed String defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public Builder declaredType(@NullAllowed String declaredType) {
            this.declaredType = declaredType;
            return this;
        }

        public Builder setPhpdocType(String phpdocType) {
            this.phpdocType = phpdocType;
            return this;
        }

        public Builder setTypes(Set<TypeResolver> types) {
            this.types = new HashSet<TypeResolver>(types);
            return this;
        }

        public Builder offset(int offset) {
            this.offset = offset;
            return this;
        }

        public Builder isRawType(boolean isRawType) {
            this.isRawType = isRawType;
            return this;
        }

        public Builder isMandatory(boolean isMandatory) {
            this.isMandatory = isMandatory;
            return this;
        }

        public Builder isReference(boolean isReference) {
            this.isReference = isReference;
            return this;
        }

        public Builder isVariadic(boolean isVariadic) {
            this.isVariadic = isVariadic;
            return this;
        }

        public Builder isUnionType(boolean isUnionType) {
            this.isUnionType = isUnionType;
            return this;
        }

        public Builder isIntersectionType(boolean isIntersectionType) {
            this.isIntersectionType = isIntersectionType;
            return this;
        }

        public Builder modifier(int modifier) {
            this.modifier = modifier;
            return this;
        }

        public Builder isMagicMethod(boolean isMagicMethod) {
            this.isMagicMethod = isMagicMethod;
            return this;
        }
    }
}

