/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.models;

import com.sun.jdi.ArrayType;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Mirror;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ThreadGroupReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Value;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.models.AbstractVariable;
import org.netbeans.modules.debugger.jpda.models.JPDAArrayTypeImpl;
import org.netbeans.modules.debugger.jpda.models.JPDAClassTypeImpl;
import org.netbeans.modules.debugger.jpda.models.JPDAThreadGroupImpl;
import org.netbeans.modules.debugger.jpda.models.JPDAThreadImpl;
import org.netbeans.modules.debugger.jpda.models.Local;
import org.netbeans.modules.debugger.jpda.models.ObjectLocalVariable;

public final class ObjectTranslation {
    private static final int THREAD_ID = 0;
    private static final int LOCALS_ID = 2;
    private JPDADebuggerImpl debugger;
    private int translationID;
    private final Map<Mirror, WeakReference<Object>> cache = new WeakHashMap<Mirror, WeakReference<Object>>();
    private final Map<JPDAThread, Map<Mirror, WeakReference<Object>>> threadCache = new WeakHashMap<JPDAThread, Map<Mirror, WeakReference<Object>>>();

    private ObjectTranslation(JPDADebuggerImpl debugger, int translationID) {
        this.debugger = debugger;
        this.translationID = translationID;
    }

    private Object createTranslation(Object o) {
        switch (this.translationID) {
            case 0: {
                if (o instanceof ThreadReference) {
                    return new JPDAThreadImpl((ThreadReference)o, this.debugger);
                }
                if (o instanceof ThreadGroupReference) {
                    return new JPDAThreadGroupImpl((ThreadGroupReference)o, this.debugger);
                }
                return null;
            }
            case 2: {
                if (o instanceof ArrayType) {
                    return new JPDAArrayTypeImpl(this.debugger, (ArrayType)o);
                }
                if (!(o instanceof ReferenceType)) break;
                return new JPDAClassTypeImpl(this.debugger, (ReferenceType)o);
            }
        }
        throw new IllegalStateException("" + o);
    }

    private Object createTranslation(Object o, Object v) {
        switch (this.translationID) {
            case 2: {
                if (!(o instanceof LocalVariable) || v != null && !(v instanceof Value)) break;
                LocalVariable lv = (LocalVariable)o;
                AbstractVariable local = v instanceof ObjectReference || v == null ? new ObjectLocalVariable(this.debugger, (ObjectReference)v, null, lv, JPDADebuggerImpl.getGenericSignature(lv), null) : new Local(this.debugger, (PrimitiveValue)v, null, lv, null);
                return local;
            }
        }
        throw new IllegalStateException("" + o);
    }

    private void verifyTranslation(Object t, Object o, Object v) {
        switch (this.translationID) {
            case 2: {
                if (!(t instanceof AbstractVariable)) break;
                AbstractVariable local = (AbstractVariable)t;
                Value lv = local.getInnerValue();
                if (lv == null && v != null || lv != null && !lv.equals(v)) {
                    local.setInnerValue((Value)v);
                }
                return;
            }
        }
        throw new IllegalStateException("" + o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object translate(Mirror o) {
        Object r = null;
        boolean create = false;
        Map<Mirror, WeakReference<Object>> map = this.cache;
        synchronized (map) {
            WeakReference<Object> wr = this.cache.get(o);
            if (wr != null) {
                r = wr.get();
            }
            if (r == null) {
                r = new TranslationFuture();
                create = true;
                this.cache.put(o, new WeakReference<TranslationFuture>((TranslationFuture)r));
            }
        }
        if (r instanceof TranslationFuture) {
            TranslationFuture tf = r;
            if (create) {
                r = this.createTranslation(o);
                tf.complete(r);
                Map<Mirror, WeakReference<Object>> map2 = this.cache;
                synchronized (map2) {
                    this.cache.put(o, new WeakReference<Object>(r));
                }
            } else {
                r = tf.get();
            }
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object translateExisting(Mirror o) {
        Object r = null;
        Map<Mirror, WeakReference<Object>> map = this.cache;
        synchronized (map) {
            WeakReference<Object> wr = this.cache.get(o);
            if (wr != null && (r = (Object)wr.get()) instanceof TranslationFuture) {
                r = ((TranslationFuture)r).get();
            }
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getTranslated() {
        HashSet translated = new HashSet();
        Map<Mirror, WeakReference<Object>> map = this.cache;
        synchronized (map) {
            Collection<WeakReference<Object>> references = this.cache.values();
            for (WeakReference<Object> wr : references) {
                Object r = wr.get();
                if (r instanceof TranslationFuture) {
                    r = ((TranslationFuture)r).get();
                }
                if (r == null) continue;
                translated.add(r);
            }
        }
        return translated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> List<? extends T> getTranslated(Function<Object, T> test) {
        ArrayList<T> translated = new ArrayList<T>();
        Map<Mirror, WeakReference<Object>> map = this.cache;
        synchronized (map) {
            Collection<WeakReference<Object>> references = this.cache.values();
            for (WeakReference<Object> wr : references) {
                T t;
                Object r = wr.get();
                if (r instanceof TranslationFuture) {
                    r = ((TranslationFuture)r).get();
                }
                if (r == null || (t = test.apply(r)) == null) continue;
                translated.add(t);
            }
        }
        return translated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object translate(Mirror o, Object v) {
        Object r = null;
        boolean verify = false;
        boolean create = false;
        Map<Mirror, WeakReference<Object>> map = this.cache;
        synchronized (map) {
            WeakReference<Object> wr = this.cache.get(o);
            if (wr != null) {
                r = wr.get();
            }
            if (r == null) {
                r = new TranslationFuture();
                create = true;
                this.cache.put(o, new WeakReference<TranslationFuture>((TranslationFuture)r));
            } else {
                verify = true;
            }
        }
        if (r instanceof TranslationFuture) {
            TranslationFuture tf = r;
            if (create) {
                r = this.createTranslation(o, v);
                tf.complete(r);
                Map<Mirror, WeakReference<Object>> map2 = this.cache;
                synchronized (map2) {
                    this.cache.put(o, new WeakReference<Object>(r));
                }
            } else {
                r = tf.get();
            }
        }
        if (verify) {
            this.verifyTranslation(r, o, v);
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object translateOnThread(JPDAThread thread, Mirror o, Object v) {
        Object r = null;
        boolean verify = false;
        Map<JPDAThread, Map<Mirror, WeakReference<Object>>> map = this.threadCache;
        synchronized (map) {
            WeakReference<Object> wr;
            Map<Mirror, WeakReference<Object>> cache = this.threadCache.get(thread);
            if (cache == null) {
                cache = new WeakHashMap<Mirror, WeakReference<Object>>();
                this.threadCache.put(thread, cache);
            }
            if ((wr = cache.get(o)) != null) {
                r = wr.get();
            }
            if (r == null) {
                r = this.createTranslation(o, v);
                cache.put(o, new WeakReference<Object>(r));
            } else {
                verify = true;
            }
        }
        if (verify) {
            this.verifyTranslation(r, o, v);
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Mirror o) {
        Map<Mirror, WeakReference<Object>> map = this.cache;
        synchronized (map) {
            this.cache.remove(o);
        }
    }

    public static ObjectTranslation createThreadTranslation(JPDADebuggerImpl debugger) {
        return new ObjectTranslation(debugger, 0);
    }

    public static ObjectTranslation createLocalsTranslation(JPDADebuggerImpl debugger) {
        return new ObjectTranslation(debugger, 2);
    }

    private static final class TranslationFuture
    extends CompletableFuture<Object> {
        private TranslationFuture() {
        }

        @Override
        public Object get() {
            try {
                return super.get();
            }
            catch (InterruptedException | ExecutionException ex) {
                throw new RuntimeException(ex);
            }
        }
    }
}

