/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.hcl.ast;

import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.stream.Stream;
import org.netbeans.modules.languages.hcl.ast.HCLExpression;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface HCLCollection<T>
extends HCLExpression {

    public record Object(List<ObjectElement> elements) implements HCLCollection<ObjectElement>
    {
        public Object {
            elements = List.copyOf(elements);
        }

        @Override
        public String asString() {
            StringJoiner sj = new StringJoiner(",", "{", "}");
            for (ObjectElement element : this.elements) {
                sj.add(HCLExpression.asString(element));
            }
            return sj.toString();
        }
    }

    public record ObjectElement(HCLExpression key, HCLExpression value) implements HCLExpression
    {
        @Override
        public String asString() {
            return HCLExpression.asString(this.key) + "=" + HCLExpression.asString(this.value);
        }

        @Override
        public List<? extends HCLExpression> elements() {
            return Stream.of(this.key, this.value).filter(Objects::nonNull).toList();
        }
    }

    public record Tuple(List<HCLExpression> elements) implements HCLCollection<HCLExpression>
    {
        public Tuple {
            elements = List.copyOf(elements);
        }

        @Override
        public String asString() {
            StringJoiner sj = new StringJoiner(",", "[", "]");
            for (HCLExpression element : this.elements) {
                sj.add(HCLExpression.asString(element));
            }
            return sj.toString();
        }
    }
}

