/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.keymanagement.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class GeneratedKey
extends ExplicitlySetBmcModel {
    @JsonProperty(value="ciphertext")
    private final String ciphertext;
    @JsonProperty(value="plaintext")
    private final String plaintext;
    @JsonProperty(value="plaintextChecksum")
    private final String plaintextChecksum;

    @Deprecated
    @ConstructorProperties(value={"ciphertext", "plaintext", "plaintextChecksum"})
    public GeneratedKey(String ciphertext, String plaintext, String plaintextChecksum) {
        this.ciphertext = ciphertext;
        this.plaintext = plaintext;
        this.plaintextChecksum = plaintextChecksum;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getCiphertext() {
        return this.ciphertext;
    }

    public String getPlaintext() {
        return this.plaintext;
    }

    public String getPlaintextChecksum() {
        return this.plaintextChecksum;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("GeneratedKey(");
        sb.append("super=").append(super.toString());
        sb.append("ciphertext=").append(String.valueOf(this.ciphertext));
        sb.append(", plaintext=").append(String.valueOf(this.plaintext));
        sb.append(", plaintextChecksum=").append(String.valueOf(this.plaintextChecksum));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GeneratedKey)) {
            return false;
        }
        GeneratedKey other = (GeneratedKey)((Object)o);
        return Objects.equals(this.ciphertext, other.ciphertext) && Objects.equals(this.plaintext, other.plaintext) && Objects.equals(this.plaintextChecksum, other.plaintextChecksum) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.ciphertext == null ? 43 : this.ciphertext.hashCode());
        result = result * 59 + (this.plaintext == null ? 43 : this.plaintext.hashCode());
        result = result * 59 + (this.plaintextChecksum == null ? 43 : this.plaintextChecksum.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="ciphertext")
        private String ciphertext;
        @JsonProperty(value="plaintext")
        private String plaintext;
        @JsonProperty(value="plaintextChecksum")
        private String plaintextChecksum;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder ciphertext(String ciphertext) {
            this.ciphertext = ciphertext;
            this.__explicitlySet__.add("ciphertext");
            return this;
        }

        public Builder plaintext(String plaintext) {
            this.plaintext = plaintext;
            this.__explicitlySet__.add("plaintext");
            return this;
        }

        public Builder plaintextChecksum(String plaintextChecksum) {
            this.plaintextChecksum = plaintextChecksum;
            this.__explicitlySet__.add("plaintextChecksum");
            return this;
        }

        public GeneratedKey build() {
            GeneratedKey model = new GeneratedKey(this.ciphertext, this.plaintext, this.plaintextChecksum);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(GeneratedKey model) {
            if (model.wasPropertyExplicitlySet("ciphertext")) {
                this.ciphertext(model.getCiphertext());
            }
            if (model.wasPropertyExplicitlySet("plaintext")) {
                this.plaintext(model.getPlaintext());
            }
            if (model.wasPropertyExplicitlySet("plaintextChecksum")) {
                this.plaintextChecksum(model.getPlaintextChecksum());
            }
            return this;
        }
    }
}

