/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.antlr.v4;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.logging.Logger;
import org.antlr.parser.antlr4.ANTLRv4Lexer;
import org.antlr.parser.antlr4.ANTLRv4Parser;
import org.antlr.parser.antlr4.ANTLRv4ParserBaseListener;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CodePointCharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.ConsoleErrorListener;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Severity;
import org.netbeans.modules.csl.spi.DefaultError;
import org.netbeans.modules.languages.antlr.AntlrParser;
import org.netbeans.modules.languages.antlr.AntlrParserResult;
import org.netbeans.modules.languages.antlr.AntlrStructureItem;
import org.netbeans.modules.parsing.api.Snapshot;
import org.openide.filesystems.FileObject;

public final class Antlr4ParserResult
extends AntlrParserResult<ANTLRv4Parser> {
    private final List<String> imports = new ArrayList<String>();
    private static final Logger LOG = Logger.getLogger(Antlr4ParserResult.class.getName());
    public static final AntlrParserResult.Reference HIDDEN = new AntlrParserResult.Reference(AntlrParserResult.ReferenceType.CHANNEL, "HIDDEN", OffsetRange.NONE);
    public static final AntlrParserResult.Reference DEFAULT_MODE = new AntlrParserResult.Reference(AntlrParserResult.ReferenceType.MODE, "DEFAULT_MODE", OffsetRange.NONE);
    final Set<String> unknownReferences = new HashSet<String>();

    public Antlr4ParserResult(Snapshot snapshot) {
        super(snapshot);
        this.references.put(Antlr4ParserResult.HIDDEN.name, HIDDEN);
        this.references.put(Antlr4ParserResult.DEFAULT_MODE.name, DEFAULT_MODE);
    }

    @Override
    protected ANTLRv4Parser createParser(Snapshot snapshot) {
        CodePointCharStream cs = CharStreams.fromString((String)String.valueOf(snapshot.getText()));
        ANTLRv4Lexer lexer = new ANTLRv4Lexer((CharStream)cs);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        ANTLRv4Parser ret = new ANTLRv4Parser((TokenStream)tokens);
        ret.removeErrorListener((ANTLRErrorListener)ConsoleErrorListener.INSTANCE);
        return ret;
    }

    @Override
    protected void evaluateParser(ANTLRv4Parser parser) {
        parser.grammarSpec();
        this.checkReferences();
    }

    private void checkReferences() {
        HashMap allRefs = new HashMap(this.references.size() * 2);
        for (Antlr4ParserResult pr : this.allImports().values()) {
            allRefs.putAll(pr.references);
        }
        this.occurrences.forEach((refName, offsets) -> {
            if (!allRefs.containsKey(refName)) {
                this.unknownReferences.add((String)refName);
                for (OffsetRange offset : offsets) {
                    this.errors.add(new DefaultError(null, "Unknown Reference: " + refName, null, this.getFileObject(), offset.getStart(), offset.getEnd(), Severity.ERROR));
                }
            }
        });
    }

    public List<String> getImports() {
        return Collections.unmodifiableList(this.imports);
    }

    private static Token getIdentifierToken(ANTLRv4Parser.IdentifierContext ctx) {
        TerminalNode tn = ctx.RULE_REF() != null ? ctx.RULE_REF() : ctx.TOKEN_REF();
        return tn.getSymbol();
    }

    @Override
    protected ParseTreeListener createReferenceListener() {
        return new ANTLRv4ParserBaseListener(){

            @Override
            public void exitGrammarType(ANTLRv4Parser.GrammarTypeContext ctx) {
                Antlr4ParserResult.this.grammarType = AntlrParserResult.GrammarType.MIXED;
                if (ctx.LEXER() != null) {
                    Antlr4ParserResult.this.grammarType = AntlrParserResult.GrammarType.LEXER;
                }
                if (ctx.PARSER() != null) {
                    Antlr4ParserResult.this.grammarType = AntlrParserResult.GrammarType.PARSER;
                }
            }

            @Override
            public void exitParserRuleSpec(ANTLRv4Parser.ParserRuleSpecContext ctx) {
                if (ctx.RULE_REF() != null) {
                    Token token = ctx.RULE_REF().getSymbol();
                    this.addReference(AntlrParserResult.ReferenceType.RULE, token);
                }
            }

            @Override
            public void exitLexerRuleSpec(ANTLRv4Parser.LexerRuleSpecContext ctx) {
                if (ctx.TOKEN_REF() != null) {
                    AntlrParserResult.ReferenceType type = ctx.FRAGMENT() != null ? AntlrParserResult.ReferenceType.FRAGMENT : AntlrParserResult.ReferenceType.TOKEN;
                    Token token = ctx.TOKEN_REF().getSymbol();
                    this.addReference(type, token);
                }
            }

            @Override
            public void exitTokensSpec(ANTLRv4Parser.TokensSpecContext ctx) {
                List<ANTLRv4Parser.IdentifierContext> ids = ctx.idList().identifier();
                for (ANTLRv4Parser.IdentifierContext id : ids) {
                    if (id.TOKEN_REF() == null) continue;
                    this.addReference(AntlrParserResult.ReferenceType.TOKEN, id.TOKEN_REF().getSymbol());
                }
            }

            @Override
            public void exitChannelsSpec(ANTLRv4Parser.ChannelsSpecContext ctx) {
                List<ANTLRv4Parser.IdentifierContext> ids = ctx.idList().identifier();
                for (ANTLRv4Parser.IdentifierContext id : ids) {
                    this.addReference(AntlrParserResult.ReferenceType.CHANNEL, Antlr4ParserResult.getIdentifierToken(id));
                }
            }

            @Override
            public void exitModeSpec(ANTLRv4Parser.ModeSpecContext ctx) {
                if (ctx.identifier() != null) {
                    this.addReference(AntlrParserResult.ReferenceType.MODE, Antlr4ParserResult.getIdentifierToken(ctx.identifier()));
                }
            }

            public void addReference(AntlrParserResult.ReferenceType type, Token token) {
                OffsetRange range = new OffsetRange(token.getStartIndex(), token.getStopIndex() + 1);
                String name = token.getText();
                AntlrParserResult.Reference ref = new AntlrParserResult.Reference(type, name, range);
                Antlr4ParserResult.this.references.put(ref.name, ref);
            }
        };
    }

    @Override
    protected ParseTreeListener createImportListener() {
        return new ANTLRv4ParserBaseListener(){

            private void addImport(String importedGrammar) {
                Antlr4ParserResult.this.imports.add(importedGrammar);
            }

            @Override
            public void exitDelegateGrammar(ANTLRv4Parser.DelegateGrammarContext ctx) {
                this.addImport(ctx.identifier(0).getText());
            }

            @Override
            public void exitOption(ANTLRv4Parser.OptionContext ctx) {
                if ("tokenVocab".equals(ctx.identifier().getText())) {
                    this.addImport(ctx.optionValue().getText());
                }
            }
        };
    }

    @Override
    protected ParseTreeListener createFoldListener() {
        return new ANTLRv4ParserBaseListener(){

            private void addFold(Token startToken, Token stopToken) {
                int stop;
                int start = startToken.getStopIndex() + 1;
                if (start >= (stop = stopToken.getStartIndex())) {
                    return;
                }
                OffsetRange range = new OffsetRange(start, stop);
                if (!Antlr4ParserResult.this.folds.contains(range)) {
                    Antlr4ParserResult.this.folds.add(range);
                }
            }

            @Override
            public void exitLexerRuleSpec(ANTLRv4Parser.LexerRuleSpecContext ctx) {
                if (ctx.TOKEN_REF() != null && ctx.TOKEN_REF().getSymbol() != null && ctx.SEMI() != null && ctx.SEMI().getSymbol() != null) {
                    this.addFold(ctx.TOKEN_REF().getSymbol(), ctx.SEMI().getSymbol());
                }
            }

            @Override
            public void exitActionBlock(ANTLRv4Parser.ActionBlockContext ctx) {
                if (ctx.BEGIN_ACTION() != null && ctx.BEGIN_ACTION().getSymbol() != null && ctx.END_ACTION() != null && ctx.END_ACTION().getSymbol() != null) {
                    this.addFold(ctx.BEGIN_ACTION().getSymbol(), ctx.END_ACTION().getSymbol());
                }
            }

            @Override
            public void exitParserRuleSpec(ANTLRv4Parser.ParserRuleSpecContext ctx) {
                if (ctx.RULE_REF() != null && ctx.RULE_REF().getSymbol() != null && ctx.SEMI() != null && ctx.SEMI().getSymbol() != null) {
                    this.addFold(ctx.RULE_REF().getSymbol(), ctx.SEMI().getSymbol());
                }
            }

            @Override
            public void exitRules(ANTLRv4Parser.RulesContext ctx) {
                if (ctx.getStart() != null && ctx.getStop() != null) {
                    this.addFold(ctx.getStart(), ctx.getStop());
                }
            }

            @Override
            public void exitModeSpec(ANTLRv4Parser.ModeSpecContext ctx) {
                if (ctx.identifier() != null && ctx.identifier().getStop() != null && ctx.getStop() != null) {
                    this.addFold(ctx.identifier().getStop(), ctx.getStop());
                }
            }
        };
    }

    @Override
    protected ParseTreeListener createStructureListener() {
        return new ANTLRv4ParserBaseListener(){
            final List<AntlrStructureItem.RuleStructureItem> lexerStructure = new ArrayList<AntlrStructureItem.RuleStructureItem>();

            @Override
            public void exitLexerRuleSpec(ANTLRv4Parser.LexerRuleSpecContext ctx) {
                boolean fragment;
                boolean bl = fragment = ctx.FRAGMENT() != null;
                if (ctx.TOKEN_REF() != null) {
                    AntlrStructureItem.RuleStructureItem rule = new AntlrStructureItem.RuleStructureItem(ctx.TOKEN_REF().getText(), fragment, Antlr4ParserResult.this.getFileObject(), ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex() + 1);
                    if (fragment) {
                        Antlr4ParserResult.this.structure.add(rule);
                    } else {
                        this.lexerStructure.add(rule);
                    }
                }
            }

            @Override
            public void exitParserRuleSpec(ANTLRv4Parser.ParserRuleSpecContext ctx) {
                if (ctx.RULE_REF() != null) {
                    AntlrStructureItem.RuleStructureItem rule = new AntlrStructureItem.RuleStructureItem(ctx.RULE_REF().getText(), false, Antlr4ParserResult.this.getFileObject(), ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex() + 1);
                    Antlr4ParserResult.this.structure.add(rule);
                }
            }

            @Override
            public void exitRules(ANTLRv4Parser.RulesContext ctx) {
                if (!this.lexerStructure.isEmpty()) {
                    AntlrStructureItem.ModeStructureItem mode = new AntlrStructureItem.ModeStructureItem(Antlr4ParserResult.this.getFileObject(), ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex() + 1);
                    mode.rules.addAll(this.lexerStructure);
                    Antlr4ParserResult.this.structure.add(mode);
                    this.lexerStructure.clear();
                }
            }

            @Override
            public void exitModeSpec(ANTLRv4Parser.ModeSpecContext ctx) {
                AntlrStructureItem.ModeStructureItem mode = new AntlrStructureItem.ModeStructureItem(ctx.identifier().getText(), Antlr4ParserResult.this.getFileObject(), ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex() + 1);
                mode.rules.addAll(this.lexerStructure);
                Antlr4ParserResult.this.structure.add(mode);
                this.lexerStructure.clear();
            }
        };
    }

    private void addOccurance(Token token) {
        String refName = token.getText();
        OffsetRange or = new OffsetRange(token.getStartIndex(), token.getStopIndex() + 1);
        this.markOccurrence(refName, or);
    }

    @Override
    protected ParseTreeListener createOccurancesListener() {
        return new ANTLRv4OccuranceListener(this::addOccurance);
    }

    private Optional<Antlr4ParserResult> getParserResult(String grammarName) {
        Optional<Antlr4ParserResult> ret = Optional.empty();
        FileObject fo = this.getFileObject().getParent().getFileObject(grammarName + ".g4");
        if (fo != null) {
            ret = Optional.of(fo.equals(this.getFileObject()) ? this : (Antlr4ParserResult)AntlrParser.getParserResult(fo));
        }
        return ret;
    }

    private void addImports(Set<String> visited, String importedGrammar) {
        if (visited.add(importedGrammar)) {
            this.getParserResult(importedGrammar).ifPresent(result -> {
                for (String im : result.getImports()) {
                    this.addImports(visited, im);
                }
            });
        }
    }

    public Map<String, Antlr4ParserResult> allImports() {
        HashSet<String> visited = new HashSet<String>();
        this.addImports(visited, this.getFileObject().getName());
        HashMap<String, Antlr4ParserResult> ret = new HashMap<String, Antlr4ParserResult>();
        for (String im : visited) {
            this.getParserResult(im).ifPresent(result -> ret.put(im, (Antlr4ParserResult)((Object)result)));
        }
        return ret;
    }

    private static class ANTLRv4OccuranceListener
    extends ANTLRv4ParserBaseListener {
        private final Consumer<Token> onOccurance;

        public ANTLRv4OccuranceListener(Consumer<Token> onOccurance) {
            this.onOccurance = onOccurance;
        }

        @Override
        public void exitTerminal(ANTLRv4Parser.TerminalContext ctx) {
            if (ctx.TOKEN_REF() != null) {
                this.onOccurance.accept(ctx.TOKEN_REF().getSymbol());
            }
        }

        @Override
        public void exitRuleref(ANTLRv4Parser.RulerefContext ctx) {
            if (ctx.RULE_REF() != null) {
                this.onOccurance.accept(ctx.RULE_REF().getSymbol());
            }
        }

        @Override
        public void exitLexerCommandExpr(ANTLRv4Parser.LexerCommandExprContext ctx) {
            if (ctx.identifier() != null) {
                this.onOccurance.accept(Antlr4ParserResult.getIdentifierToken(ctx.identifier()));
            }
        }

        @Override
        public void exitChannelsSpec(ANTLRv4Parser.ChannelsSpecContext ctx) {
            List<ANTLRv4Parser.IdentifierContext> ids = ctx.idList().identifier();
            for (ANTLRv4Parser.IdentifierContext id : ids) {
                this.onOccurance.accept(Antlr4ParserResult.getIdentifierToken(id));
            }
        }
    }
}

