/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.llmInstaller.ui.promo;

import com.intellij.openapi.ui.panel.ComponentPanelBuilder;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.dsl.builder.HyperlinkEventAction;
import com.intellij.ui.dsl.builder.impl.DslComponentPropertyInternal;
import com.intellij.util.ui.ExtendableHTMLViewFactory;
import com.intellij.util.ui.HTMLEditorKitBuilder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.beans.PropertyChangeEvent;
import java.util.List;
import javax.swing.JEditorPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.text.Caret;
import javax.swing.text.DefaultCaret;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u0011\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0010H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0014H\u0016J\u0012\u0010\u0016\u001a\u00020\u000e2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u0010H\u0002J\b\u0010\u001a\u001a\u00020\u000eH\u0002J\b\u0010\u001b\u001a\u00020\u000eH\u0002J\b\u0010\u001c\u001a\u00020\u0003H\u0002J\u0010\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u0010H\u0002R\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0012\u0010\f\u001a\u0004\u0018\u00010\u00038\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/intellij/llmInstaller/ui/promo/CommentLabel;", "Ljavax/swing/JEditorPane;", "text", "", "<init>", "(Ljava/lang/String;)V", "action", "Lcom/intellij/ui/dsl/builder/HyperlinkEventAction;", "getAction", "()Lcom/intellij/ui/dsl/builder/HyperlinkEventAction;", "setAction", "(Lcom/intellij/ui/dsl/builder/HyperlinkEventAction;)V", "userText", "updateUI", "", "getBaseline", "", "width", "height", "getMinimumSize", "Ljava/awt/Dimension;", "getPreferredSize", "setForeground", "fg", "Ljava/awt/Color;", "getPreferredColumnsWordWrap", "updateEditorPaneText", "patchFont", "createCss", "getSupposedWidth", "charCount", "Companion", "intellij.llmInstaller"})
public final class CommentLabel
extends JEditorPane {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private HyperlinkEventAction action;
    @Nls
    @Nullable
    private final String userText;
    @NotNull
    public static final String LINK_COLOR = "commentLabel.linkColor";

    public CommentLabel(@NlsContexts.Label @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.setContentType("text/html");
        Function2[] function2Array = new Function2[]{ExtendableHTMLViewFactory.Extensions.WORD_WRAP};
        this.setEditorKit(new HTMLEditorKitBuilder().withUnderlinedHoveredHyperlink(false).withViewFactoryExtensions(function2Array).build());
        this.putClientProperty("caretWidth", 0);
        this.addHyperlinkListener(arg_0 -> CommentLabel._init_$lambda$0(this, arg_0));
        this.patchFont();
        this.userText = text;
        this.setForeground(JBUI.CurrentTheme.ContextHelp.FOREGROUND);
        this.updateEditorPaneText();
        this.addPropertyChangeListener(arg_0 -> CommentLabel._init_$lambda$1(this, arg_0));
    }

    @Nullable
    public final HyperlinkEventAction getAction() {
        return this.action;
    }

    public final void setAction(@Nullable HyperlinkEventAction hyperlinkEventAction) {
        this.action = hyperlinkEventAction;
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.setFocusable(false);
        this.setEditable(false);
        this.setBorder(null);
        this.setBackground(UIUtil.TRANSPARENT_COLOR);
        this.setOpaque(false);
        this.setDisabledTextColor(JBUI.CurrentTheme.Label.disabledForeground());
        Caret caret = this.getCaret();
        Intrinsics.checkNotNull((Object)caret, (String)"null cannot be cast to non-null type javax.swing.text.DefaultCaret");
        ((DefaultCaret)caret).setUpdatePolicy(1);
        this.patchFont();
        this.updateEditorPaneText();
    }

    @Override
    public int getBaseline(int width, int height) {
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        return fontMetrics.getAscent();
    }

    @Override
    @NotNull
    public Dimension getMinimumSize() {
        Dimension result = super.getMinimumSize();
        return new Dimension(Math.min(this.getSupposedWidth(35), result.width), result.height);
    }

    @Override
    @NotNull
    public Dimension getPreferredSize() {
        Dimension result = super.getPreferredSize();
        return new Dimension(Math.min(this.getSupposedWidth(this.getPreferredColumnsWordWrap()), result.width), result.height);
    }

    @Override
    public void setForeground(@Nullable Color fg) {
        super.setForeground(fg);
        this.updateEditorPaneText();
    }

    private final int getPreferredColumnsWordWrap() {
        Integer n = (Integer)this.getClientProperty(DslComponentPropertyInternal.PREFERRED_COLUMNS_LABEL_WORD_WRAP);
        return n != null ? n : 70;
    }

    private final void updateEditorPaneText() {
        String string = this.userText;
        if (string == null) {
            return;
        }
        String text = string;
        String processedText = StringsKt.replace((String)text, (String)"<a>", (String)"<a href=''>", (boolean)true);
        HtmlChunk.Element element = HtmlChunk.body();
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"body(...)");
        HtmlChunk.Element body = element;
        String css = this.createCss();
        super.setText(new HtmlBuilder().append(HtmlChunk.raw((String)css)).append((HtmlChunk)HtmlChunk.raw((String)processedText).wrapWith(body)).wrapWith(HtmlChunk.html()).toString());
    }

    private final void patchFont() {
        this.setFont(ComponentPanelBuilder.getCommentFont((Font)this.getFont()));
    }

    private final String createCss() {
        Object[] objectArray = this.getClientProperty(LINK_COLOR);
        Color color = objectArray instanceof Color ? (Color)objectArray : null;
        if (color == null) {
            Color color2 = JBUI.CurrentTheme.Link.Foreground.ENABLED;
            color = color2;
            Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"ENABLED");
        }
        Color linkColor = color;
        objectArray = new String[]{"a, a:link, a:visited, a:hover, a:active { color:#" + ColorUtil.toHex((Color)linkColor) + "; text-decoration: underline; }"};
        List styles = CollectionsKt.mutableListOf((Object[])objectArray);
        return CollectionsKt.joinToString$default((Iterable)styles, (CharSequence)" ", (CharSequence)"<head><style type='text/css'>", (CharSequence)"</style></head>", (int)0, null, null, (int)56, null);
    }

    private final int getSupposedWidth(int charCount) {
        return this.getFontMetrics(this.getFont()).charWidth('0') * charCount;
    }

    private static final void _init_$lambda$0(CommentLabel this$0, HyperlinkEvent e) {
        block2: {
            HyperlinkEvent.EventType eventType;
            block3: {
                block1: {
                    HyperlinkEvent hyperlinkEvent = e;
                    HyperlinkEvent.EventType eventType2 = eventType = hyperlinkEvent != null ? hyperlinkEvent.getEventType() : null;
                    if (!Intrinsics.areEqual((Object)eventType, (Object)HyperlinkEvent.EventType.ACTIVATED)) break block1;
                    HyperlinkEventAction hyperlinkEventAction = this$0.action;
                    if (hyperlinkEventAction == null) break block2;
                    hyperlinkEventAction.hyperlinkActivated(e);
                    break block2;
                }
                if (!Intrinsics.areEqual((Object)eventType, (Object)HyperlinkEvent.EventType.ENTERED)) break block3;
                HyperlinkEventAction hyperlinkEventAction = this$0.action;
                if (hyperlinkEventAction == null) break block2;
                hyperlinkEventAction.hyperlinkEntered(e);
                break block2;
            }
            if (!Intrinsics.areEqual((Object)eventType, (Object)HyperlinkEvent.EventType.EXITED)) break block2;
            HyperlinkEventAction hyperlinkEventAction = this$0.action;
            if (hyperlinkEventAction != null) {
                hyperlinkEventAction.hyperlinkExited(e);
            }
        }
    }

    private static final void _init_$lambda$1(CommentLabel this$0, PropertyChangeEvent evt) {
        if (Intrinsics.areEqual((Object)evt.getPropertyName(), (Object)LINK_COLOR)) {
            this$0.updateEditorPaneText();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/llmInstaller/ui/promo/CommentLabel$Companion;", "", "<init>", "()V", "LINK_COLOR", "", "intellij.llmInstaller"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

