/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.aalto.async;

import com.fasterxml.aalto.in.PName;
import com.fasterxml.aalto.in.PName1;
import com.fasterxml.aalto.in.PName2;
import com.fasterxml.aalto.in.PName3;

public class AsyncXmlDeclHelper {
    private static final int QUAD_XML = AsyncXmlDeclHelper.asciiQuads("xml")[0];
    private static final int QUAD_VERSION1;
    private static final int QUAD_VERSION2;
    private static final int QUAD_STANDALONE1;
    private static final int QUAD_STANDALONE2;
    private static final int QUAD_STANDALONE3;
    private static final int QUAD_ENCODING1;
    private static final int QUAD_ENCODING2;
    private static final PName1 NAME_XML;
    private static final PName2 NAME_VERSION;
    private static final PName3 NAME_STANDALONE;
    private static final PName2 NAME_ENCODING;

    public static PName find(int quad1) {
        if (quad1 == QUAD_XML) {
            return NAME_XML;
        }
        return null;
    }

    public static PName find(int quad1, int quad2) {
        if (quad1 == QUAD_VERSION1) {
            if (quad2 == QUAD_VERSION2) {
                return NAME_VERSION;
            }
        } else if (quad1 == QUAD_ENCODING1 && quad2 == QUAD_ENCODING2) {
            return NAME_ENCODING;
        }
        return null;
    }

    public static PName find(int quad1, int quad2, int quad3) {
        if (quad1 == QUAD_STANDALONE1 && quad2 == QUAD_STANDALONE2 && quad3 == QUAD_STANDALONE3) {
            return NAME_STANDALONE;
        }
        return null;
    }

    static int[] asciiQuads(String word) {
        int blen = word.length();
        int[] result2 = new int[(blen + 3) / 4];
        for (int i = 0; i < blen; ++i) {
            int x = word.charAt(i);
            if (++i < blen) {
                x = x << 8 | word.charAt(i);
                if (++i < blen) {
                    x = x << 8 | word.charAt(i);
                    if (++i < blen) {
                        x = x << 8 | word.charAt(i);
                    }
                }
            }
            result2[i / 4] = x;
        }
        return result2;
    }

    static {
        int[] q = AsyncXmlDeclHelper.asciiQuads("version");
        QUAD_VERSION1 = q[0];
        QUAD_VERSION2 = q[1];
        q = AsyncXmlDeclHelper.asciiQuads("standalone");
        QUAD_STANDALONE1 = q[0];
        QUAD_STANDALONE2 = q[1];
        QUAD_STANDALONE3 = q[2];
        q = AsyncXmlDeclHelper.asciiQuads("encoding");
        QUAD_ENCODING1 = q[0];
        QUAD_ENCODING2 = q[1];
        NAME_XML = new PName1("xml", null, "xml", 0, QUAD_XML);
        NAME_VERSION = new PName2("version", null, "version", 0, QUAD_VERSION1, QUAD_VERSION2);
        NAME_STANDALONE = new PName3("standalone", null, "standalone", 0, QUAD_STANDALONE1, QUAD_STANDALONE2, QUAD_STANDALONE3);
        NAME_ENCODING = new PName2("encoding", null, "encoding", 0, QUAD_ENCODING1, QUAD_ENCODING2);
    }
}

