/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.builder;

import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.data.DataKey;
import com.vladsch.flexmark.util.data.MutableDataHolder;
import com.vladsch.flexmark.util.data.MutableDataSet;
import com.vladsch.flexmark.util.data.NullableDataKey;
import com.vladsch.flexmark.util.data.SharedDataKeys;
import com.vladsch.flexmark.util.misc.Extension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BuilderBase<T extends BuilderBase<T>>
extends MutableDataSet {
    private final HashSet<Class<?>> loadedExtensions = new HashSet();
    private final HashMap<Class<?>, HashSet<Object>> extensionApiPoints = new HashMap();
    private Extension currentExtension;

    protected abstract void removeApiPoint(@NotNull Object var1);

    protected abstract void preloadExtension(@NotNull Extension var1);

    protected abstract boolean loadExtension(@NotNull Extension var1);

    @NotNull
    public final T extensions(@NotNull Collection<? extends Extension> extensions) {
        Extension extension;
        ArrayList<Extension> addedExtensions = new ArrayList<Extension>(SharedDataKeys.EXTENSIONS.get(this).size() + extensions.size());
        Iterator<? extends Extension> iterator2 = extensions.iterator();
        while (iterator2.hasNext()) {
            this.currentExtension = extension = iterator2.next();
            if (!this.loadedExtensions.contains(extension.getClass())) {
                this.preloadExtension(extension);
                addedExtensions.add(extension);
            }
            this.currentExtension = null;
        }
        iterator2 = extensions.iterator();
        while (iterator2.hasNext()) {
            this.currentExtension = extension = iterator2.next();
            Class<?> extensionClass = extension.getClass();
            if (!this.loadedExtensions.contains(extensionClass) && this.loadExtension(extension)) {
                this.loadedExtensions.add(extensionClass);
                addedExtensions.add(extension);
            }
            this.currentExtension = null;
        }
        if (!addedExtensions.isEmpty()) {
            addedExtensions.addAll(0, SharedDataKeys.EXTENSIONS.get(this));
            this.set((DataKey)SharedDataKeys.EXTENSIONS, (Object)addedExtensions);
        }
        return (T)this;
    }

    @NotNull
    public abstract Object build();

    protected void addExtensionApiPoint(@NotNull Object apiPoint) {
        Extension extension = this.currentExtension;
        if (extension != null) {
            Class<?> extensionClass = extension.getClass();
            HashSet apiPoints = this.extensionApiPoints.computeIfAbsent(extensionClass, k -> new HashSet());
            apiPoints.add(apiPoint);
        }
    }

    @NotNull
    public <V> MutableDataSet set(@NotNull DataKey<V> key, @NotNull V value2) {
        this.addExtensionApiPoint(key);
        return super.set((DataKey)key, (Object)value2);
    }

    @NotNull
    public <V> MutableDataSet set(@NotNull NullableDataKey<V> key, @Nullable V value2) {
        this.addExtensionApiPoint(key);
        return super.set((NullableDataKey)key, (Object)value2);
    }

    @Deprecated
    public <V> V get(@NotNull DataKey<V> key) {
        return key.get(this);
    }

    protected BuilderBase(@Nullable DataHolder options) {
        super(options);
    }

    protected void loadExtensions() {
        if (this.contains(SharedDataKeys.EXTENSIONS)) {
            this.extensions(SharedDataKeys.EXTENSIONS.get(this));
        }
    }

    protected BuilderBase() {
    }

    public static DataHolder removeExtensions(@NotNull DataHolder options, @NotNull Collection<Class<? extends Extension>> excludeExtensions) {
        ArrayList<Extension> extensions;
        boolean removed;
        if (options.contains(SharedDataKeys.EXTENSIONS) && (removed = (extensions = new ArrayList<Extension>(SharedDataKeys.EXTENSIONS.get(options))).removeIf(it -> excludeExtensions.contains(it.getClass())))) {
            if (options instanceof MutableDataHolder) {
                return ((MutableDataHolder)options).set(SharedDataKeys.EXTENSIONS, extensions);
            }
            return options.toMutable().set(SharedDataKeys.EXTENSIONS, extensions).toImmutable();
        }
        return options;
    }
}

