/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk.poetry;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.Topic;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.packaging.PyPackage;
import com.jetbrains.python.packaging.PyPackageManager;
import com.jetbrains.python.packaging.PyRequirement;
import com.jetbrains.python.packaging.PyRequirementParser;
import com.jetbrains.python.sdk.PySdkExtKt;
import com.jetbrains.python.sdk.PythonSdkType;
import com.jetbrains.python.sdk.poetry.PoetryCommandExecutorKt;
import com.jetbrains.python.sdk.poetry.PoetryOutdatedVersion;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Triple;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\bH\u0016J&\u0010\u0014\u001a\u00020\u00112\u000e\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u00072\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016J\u0016\u0010\u0017\u001a\u00020\u00112\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007H\u0016J\b\u0010\u0018\u001a\u00020\u0011H\u0016J\u0018\u0010\u0019\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\u0013H\u0016J\u0010\u0010\u001c\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\u0007H\u0016J\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000f0\u000eJ\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\n0\u00072\u0006\u0010\u001f\u001a\u00020\u0013H\u0016J\u0018\u0010 \u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u00072\u0006\u0010!\u001a\u00020\"H\u0016J\u0016\u0010#\u001a\b\u0012\u0004\u0012\u00020\f0\u00072\u0006\u0010$\u001a\u00020\bH\u0016J\u0012\u0010%\u001a\u0004\u0018\u00010\f2\u0006\u0010&\u001a\u00020\bH\u0016J\u0016\u0010#\u001a\b\u0012\u0004\u0012\u00020\f0\u00072\u0006\u0010'\u001a\u00020(H\u0016J\u0016\u0010)\u001a\b\u0012\u0004\u0012\u00020\n0*2\u0006\u0010+\u001a\u00020\nH\u0016J\u0010\u0010,\u001a\u00020\b2\u0006\u0010-\u001a\u00020\bH\u0002J(\u0010.\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u00070/2\u0006\u00100\u001a\u00020\bH\u0002J\u001c\u00101\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u00100\u001a\u00020\bH\u0002R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcom/jetbrains/python/sdk/poetry/PyPoetryPackageManager;", "Lcom/jetbrains/python/packaging/PyPackageManager;", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "<init>", "(Lcom/intellij/openapi/projectRoots/Sdk;)V", "installedLines", "", "", "packages", "Lcom/jetbrains/python/packaging/PyPackage;", "requirements", "Lcom/jetbrains/python/packaging/PyRequirement;", "outdatedPackages", "", "Lcom/jetbrains/python/sdk/poetry/PoetryOutdatedVersion;", "installManagement", "", "hasManagement", "", "install", "requirementString", "extraArgs", "uninstall", "refresh", "createVirtualEnv", "destinationDir", "useGlobalSite", "getPackages", "getOutdatedPackages", "refreshAndGetPackages", "alwaysRefresh", "getRequirements", "module", "Lcom/intellij/openapi/module/Module;", "parseRequirements", "text", "parseRequirement", "line", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "getDependents", "", "pkg", "getVersion", "version", "parsePoetryInstallDryRun", "Lkotlin/Pair;", "input", "parsePoetryShowOutdated", "intellij.python.community.impl"})
@SourceDebugExtension(value={"SMAP\nPyPoetryPackageManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyPoetryPackageManager.kt\ncom/jetbrains/python/sdk/poetry/PyPoetryPackageManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,197:1\n1557#2:198\n1628#2,3:199\n1557#2:204\n1628#2,3:205\n1755#2,3:211\n1611#2,9:216\n1863#2:225\n1864#2:227\n1620#2:228\n1755#2,3:229\n37#3,2:202\n37#3,2:208\n1317#4:210\n1318#4:215\n1#5:214\n1#5:226\n*S KotlinDebug\n*F\n+ 1 PyPoetryPackageManager.kt\ncom/jetbrains/python/sdk/poetry/PyPoetryPackageManager\n*L\n55#1:198\n55#1:199,3\n71#1:204\n71#1:205,3\n174#1:211,3\n192#1:216,9\n192#1:225\n192#1:227\n192#1:228\n171#1:229,3\n61#1:202,2\n73#1:208,2\n172#1:210\n172#1:215\n192#1:226\n*E\n"})
public final class PyPoetryPackageManager
extends PyPackageManager {
    @NotNull
    private final List<String> installedLines;
    @Nullable
    private volatile List<PyPackage> packages;
    @Nullable
    private List<? extends PyRequirement> requirements;
    @NotNull
    private Map<String, PoetryOutdatedVersion> outdatedPackages;

    public PyPoetryPackageManager(@NotNull Sdk sdk2) {
        Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
        super(sdk2);
        Object[] objectArray = new String[]{"Already installed", "Skipping", "Updating"};
        this.installedLines = CollectionsKt.listOf((Object[])objectArray);
        this.outdatedPackages = MapsKt.emptyMap();
    }

    @Override
    public void installManagement() {
    }

    @Override
    public boolean hasManagement() {
        return true;
    }

    @Override
    public void install(@NotNull String requirementString) {
        Intrinsics.checkNotNullParameter((Object)requirementString, (String)"requirementString");
        this.install((List<? extends PyRequirement>)this.parseRequirements(requirementString), (List<String>)CollectionsKt.emptyList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void install(@Nullable List<? extends PyRequirement> requirements, @NotNull List<String> extraArgs) {
        List list;
        Intrinsics.checkNotNullParameter(extraArgs, (String)"extraArgs");
        Object[] objectArray = (Object[])requirements;
        if (objectArray == null || objectArray.isEmpty()) {
            objectArray = new List[]{CollectionsKt.listOf((Object)"install"), extraArgs};
            list = CollectionsKt.flatten((Iterable)CollectionsKt.listOfNotNull((Object[])objectArray));
        } else {
            Collection<String> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            objectArray = new List[3];
            objectArray[0] = CollectionsKt.listOf((Object)"add");
            Iterable iterable = requirements;
            int n = 1;
            Object[] objectArray2 = objectArray;
            boolean $i$f$map = false;
            void var7_9 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                PyRequirement pyRequirement = (PyRequirement)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getName());
            }
            collection = (List)destination$iv$iv;
            objectArray2[n] = collection;
            objectArray[2] = extraArgs;
            list = CollectionsKt.flatten((Iterable)CollectionsKt.listOfNotNull((Object[])objectArray));
        }
        List args = list;
        try {
            Sdk sdk2 = this.getSdk();
            Intrinsics.checkNotNullExpressionValue((Object)sdk2, (String)"getSdk(...)");
            Collection $this$toTypedArray$iv = args;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            objectArray = thisCollection$iv.toArray(new String[0]);
            PoetryCommandExecutorKt.runPoetry(sdk2, (String[])Arrays.copyOf(objectArray, objectArray.length));
        }
        finally {
            Sdk sdk3 = this.getSdk();
            Intrinsics.checkNotNullExpressionValue((Object)sdk3, (String)"getSdk(...)");
            VirtualFile virtualFile = PySdkExtKt.getAssociatedModuleDir(sdk3);
            if (virtualFile != null) {
                virtualFile.refresh(true, false);
            }
            this.refreshAndGetPackages(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void uninstall(@NotNull List<PyPackage> packages) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(packages, (String)"packages");
        String[] stringArray = (String[])packages;
        Collection collection = CollectionsKt.listOf((Object)"remove");
        boolean $i$f$map = false;
        void var5_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PyPackage pyPackage = (PyPackage)((Object)item$iv$iv);
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            String string = it.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            collection2.add(string);
        }
        List args = CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv));
        try {
            Sdk sdk2 = this.getSdk();
            Intrinsics.checkNotNullExpressionValue((Object)sdk2, (String)"getSdk(...)");
            Collection $this$toTypedArray$iv = args;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            stringArray = thisCollection$iv.toArray(new String[0]);
            PoetryCommandExecutorKt.runPoetry(sdk2, Arrays.copyOf(stringArray, stringArray.length));
        }
        finally {
            Sdk sdk3 = this.getSdk();
            Intrinsics.checkNotNullExpressionValue((Object)sdk3, (String)"getSdk(...)");
            VirtualFile virtualFile = PySdkExtKt.getAssociatedModuleDir(sdk3);
            if (virtualFile != null) {
                virtualFile.refresh(true, false);
            }
            this.refreshAndGetPackages(true);
        }
    }

    @Override
    public void refresh() {
        Application $this$refresh_u24lambda_u244 = ApplicationManager.getApplication();
        boolean bl = false;
        $this$refresh_u24lambda_u244.invokeLater(() -> PyPoetryPackageManager.refresh$lambda$4$lambda$3($this$refresh_u24lambda_u244, this));
    }

    @Override
    @NotNull
    public String createVirtualEnv(@NotNull String destinationDir, boolean useGlobalSite) {
        Intrinsics.checkNotNullParameter((Object)destinationDir, (String)"destinationDir");
        throw new ExecutionException(PyBundle.message("python.sdk.dialog.message.creating.virtual.environments.based.on.poetry.environments.not.supported", new Object[0]));
    }

    @Override
    @Nullable
    public List<PyPackage> getPackages() {
        return this.packages;
    }

    @NotNull
    public final Map<String, PoetryOutdatedVersion> getOutdatedPackages() {
        return this.outdatedPackages;
    }

    @Override
    @NotNull
    public List<PyPackage> refreshAndGetPackages(boolean alwaysRefresh) {
        List list;
        if (alwaysRefresh || this.packages == null) {
            String[] stringArray;
            Object outputInstallDryRun;
            Object object;
            this.packages = null;
            try {
                Sdk sdk2 = this.getSdk();
                Intrinsics.checkNotNullExpressionValue((Object)sdk2, (String)"getSdk(...)");
                object = new String[]{"install", "--dry-run", "--no-root"};
                object = PoetryCommandExecutorKt.runPoetry(sdk2, object);
            }
            catch (ExecutionException e) {
                this.packages = CollectionsKt.emptyList();
                List list2 = this.packages;
                if (list2 == null) {
                    list2 = CollectionsKt.emptyList();
                }
                return list2;
            }
            Object e = outputInstallDryRun = object;
            ResultKt.throwOnFailure((Object)e);
            Pair<List<PyPackage>, List<PyRequirement>> allPackage = this.parsePoetryInstallDryRun((String)e);
            this.packages = (List)allPackage.getFirst();
            this.requirements = (List)allPackage.getSecond();
            try {
                Sdk sdk3 = this.getSdk();
                Intrinsics.checkNotNullExpressionValue((Object)sdk3, (String)"getSdk(...)");
                stringArray = new String[]{"show", "--outdated"};
                stringArray = Result.box-impl((Object)PoetryCommandExecutorKt.runPoetry(sdk3, stringArray));
            }
            catch (ExecutionException e2) {
                this.outdatedPackages = MapsKt.emptyMap();
                stringArray = Unit.INSTANCE;
            }
            String[] outputOutdatedPackages = stringArray;
            if (outputOutdatedPackages instanceof String) {
                this.outdatedPackages = this.parsePoetryShowOutdated((String)outputOutdatedPackages);
            }
            MessageBus messageBus = ApplicationManager.getApplication().getMessageBus();
            Topic<PyPackageManager.Listener> topic = PyPackageManager.PACKAGE_MANAGER_TOPIC;
            Intrinsics.checkNotNullExpressionValue(topic, (String)"PACKAGE_MANAGER_TOPIC");
            ((PyPackageManager.Listener)messageBus.syncPublisher(topic)).packagesRefreshed(this.getSdk());
        }
        if ((list = this.packages) == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @Override
    @Nullable
    public List<PyRequirement> getRequirements(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return this.requirements;
    }

    @Override
    @NotNull
    public List<PyRequirement> parseRequirements(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        List<PyRequirement> list = PyRequirementParser.fromText(text);
        Intrinsics.checkNotNullExpressionValue(list, (String)"fromText(...)");
        return list;
    }

    @Override
    @Nullable
    public PyRequirement parseRequirement(@NotNull String line) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        return PyRequirementParser.fromLine(line);
    }

    @Override
    @NotNull
    public List<PyRequirement> parseRequirements(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        List<PyRequirement> list = PyRequirementParser.fromFile(file);
        Intrinsics.checkNotNullExpressionValue(list, (String)"fromFile(...)");
        return list;
    }

    @Override
    @NotNull
    public Set<PyPackage> getDependents(@NotNull PyPackage pkg) {
        Intrinsics.checkNotNullParameter((Object)((Object)pkg), (String)"pkg");
        return SetsKt.emptySet();
    }

    private final String getVersion(String version2) {
        return new Regex("^[0-9]").containsMatchIn((CharSequence)version2) ? "==" + version2 : version2;
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<List<PyPackage>, List<PyRequirement>> parsePoetryInstallDryRun(String input) {
        void $this$forEach$iv;
        List pyPackages = new ArrayList();
        List pyRequirements = new ArrayList();
        Sequence sequence = SequencesKt.filter((Sequence)StringsKt.lineSequence((CharSequence)input), PyPoetryPackageManager::parsePoetryInstallDryRun$lambda$7);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PyRequirement pyRequirement;
            boolean bl;
            Triple<String, String, String> it;
            String line;
            block6: {
                Triple<String, String, String> triple;
                line = (String)element$iv;
                boolean bl2 = false;
                it = triple = PyPoetryPackageManager.parsePoetryInstallDryRun$getNameAndVersion(line);
                boolean bl3 = false;
                Iterable $this$any$iv = this.installedLines;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv2 : $this$any$iv) {
                        String installedLine = (String)element$iv2;
                        boolean bl4 = false;
                        if (!StringsKt.contains$default((CharSequence)line, (CharSequence)installedLine, (boolean)false, (int)2, null)) continue;
                        bl = true;
                        break block6;
                    }
                    bl = false;
                }
            }
            if (bl) {
                pyPackages.add(new PyPackage((String)it.getFirst(), (String)it.getSecond(), null, CollectionsKt.emptyList()));
                if (this.parseRequirement(it.getFirst() + this.getVersion((String)it.getThird())) != null) {
                    boolean bl5 = false;
                    pyRequirements.add(pyRequirement);
                }
                continue;
            }
            if (!StringsKt.contains$default((CharSequence)line, (CharSequence)"Installing", (boolean)false, (int)2, null)) continue;
            if (this.parseRequirement(it.getFirst() + this.getVersion((String)it.getThird())) == null) continue;
            boolean bl6 = false;
            pyRequirements.add(pyRequirement);
        }
        return new Pair((Object)CollectionsKt.toList((Iterable)CollectionsKt.distinct((Iterable)pyPackages)), (Object)CollectionsKt.toList((Iterable)CollectionsKt.distinct((Iterable)pyRequirements)));
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, PoetryOutdatedVersion> parsePoetryShowOutdated(String input) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = StringsKt.lines((CharSequence)input);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Pair pair;
            List list;
            List list2;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String line = (String)element$iv$iv;
            boolean bl2 = false;
            CharSequence charSequence = line;
            Pattern pattern = Pattern.compile(" +");
            Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(...)");
            List it = list2 = StringsKt.split$default((CharSequence)charSequence, (Pattern)pattern, (int)0, (int)2, null);
            boolean bl3 = false;
            List list3 = list = it.size() > 3 ? list2 : null;
            if (list != null) {
                it = list;
                boolean bl4 = false;
                pair = TuplesKt.to(it.get(0), (Object)new PoetryOutdatedVersion((String)it.get(1), (String)it.get(2)));
            } else {
                pair = null;
            }
            if (pair == null) continue;
            Pair it$iv$iv = pair;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return MapsKt.toMap((Iterable)((List)destination$iv$iv));
    }

    private static final void refresh$lambda$4$lambda$3$lambda$2(PyPoetryPackageManager this$0) {
        VirtualFile[] virtualFileArray = this$0.getSdk().getRootProvider().getFiles(OrderRootType.CLASSES);
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getFiles(...)");
        VirtualFile[] files = virtualFileArray;
        VfsUtil.markDirtyAndRefresh((boolean)true, (boolean)true, (boolean)true, (VirtualFile[])Arrays.copyOf(files, files.length));
    }

    private static final void refresh$lambda$4$lambda$3(Application $this_with, PyPoetryPackageManager this$0) {
        $this_with.runWriteAction(() -> PyPoetryPackageManager.refresh$lambda$4$lambda$3$lambda$2(this$0));
        PythonSdkType.getInstance().setupSdkPaths(this$0.getSdk());
    }

    private static final Triple<String, String, String> parsePoetryInstallDryRun$getNameAndVersion(String line) {
        String string;
        String[] stringArray = new String[]{" "};
        List it = StringsKt.split$default((CharSequence)line, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean bl = false;
        CharSequence charSequence = (CharSequence)it.get(5);
        Object object = new Regex("[():]");
        String string2 = "";
        String installedVersion = object.replace(charSequence, string2);
        if (it.size() > 7 && Intrinsics.areEqual(it.get(6), (Object)"->")) {
            object = (CharSequence)it.get(7);
            string2 = new Regex("[():]");
            String string3 = "";
            string = string2.replace((CharSequence)object, string3);
        } else {
            string = installedVersion;
        }
        String requiredVersion = string;
        return new Triple(it.get(4), (Object)installedVersion, (Object)requiredVersion);
    }

    private static final boolean parsePoetryInstallDryRun$lambda$7(String it) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            Object[] objectArray = new String[]{")", "Already installed"};
            Iterable $this$any$iv = CollectionsKt.listOf((Object[])objectArray);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String lastWords = (String)element$iv;
                    boolean bl2 = false;
                    if (!StringsKt.endsWith$default((String)it, (String)lastWords, (boolean)false, (int)2, null)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }
}

