/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.debugger.coroutines;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public final class CoroutinesDebugHelper {
    private static final String COROUTINE_OWNER_CLASS = "CoroutineOwner";

    public static long[] getCoroutinesRunningOnCurrentThread(Object debugProbes, Thread currentThread) throws ReflectiveOperationException {
        ArrayList<Long> coroutinesIds = new ArrayList<Long>();
        List infos = (List)CoroutinesDebugHelper.invoke(debugProbes, "dumpCoroutinesInfo");
        for (Object info : infos) {
            if (CoroutinesDebugHelper.invoke(info, "getLastObservedThread") != currentThread) continue;
            coroutinesIds.add((Long)CoroutinesDebugHelper.invoke(info, "getSequenceNumber"));
        }
        long[] res = new long[coroutinesIds.size()];
        for (int i = 0; i < res.length; ++i) {
            res[i] = (Long)coroutinesIds.get(i);
        }
        return res;
    }

    public static long tryGetContinuationId(Object continuation) throws ReflectiveOperationException {
        Object rootContinuation = CoroutinesDebugHelper.getCoroutineOwner(continuation, true);
        if (rootContinuation.getClass().getSimpleName().contains(COROUTINE_OWNER_CLASS)) {
            Object debugCoroutineInfo = CoroutinesDebugHelper.getField(rootContinuation, "info");
            return (Long)CoroutinesDebugHelper.getField(debugCoroutineInfo, "sequenceNumber");
        }
        return -1L;
    }

    private static Object getCoroutineOwner(Object continuation, boolean checkForCoroutineOwner) throws ReflectiveOperationException {
        Method getCallerFrame = Class.forName("kotlin.coroutines.jvm.internal.CoroutineStackFrame", false, continuation.getClass().getClassLoader()).getDeclaredMethod("getCallerFrame", new Class[0]);
        getCallerFrame.setAccessible(true);
        Object current = continuation;
        while (true) {
            if (checkForCoroutineOwner && current.getClass().getSimpleName().equals(COROUTINE_OWNER_CLASS)) {
                return current;
            }
            Object parentFrame = getCallerFrame.invoke(current, new Object[0]);
            if (parentFrame == null) break;
            current = parentFrame;
        }
        return current;
    }

    public static Object getRootContinuation(Object continuation) throws ReflectiveOperationException {
        return CoroutinesDebugHelper.getCoroutineOwner(continuation, false);
    }

    public static Object getCallerFrame(Object continuation) throws ReflectiveOperationException {
        Class<?> coroutineStackFrame = Class.forName("kotlin.coroutines.jvm.internal.CoroutineStackFrame", false, continuation.getClass().getClassLoader());
        Method getCallerFrame = coroutineStackFrame.getDeclaredMethod("getCallerFrame", new Class[0]);
        getCallerFrame.setAccessible(true);
        Object callerFrame = getCallerFrame.invoke(continuation, new Object[0]);
        if (callerFrame == null || callerFrame.getClass().getSimpleName().contains(COROUTINE_OWNER_CLASS)) {
            return continuation;
        }
        Class<?> scopeCoroutine = Class.forName("kotlinx.coroutines.internal.ScopeCoroutine", false, continuation.getClass().getClassLoader());
        if (scopeCoroutine.isInstance(callerFrame)) {
            return getCallerFrame.invoke(callerFrame, new Object[0]);
        }
        return callerFrame;
    }

    private static Object getField(Object object, String fieldName) throws ReflectiveOperationException {
        Field field = object.getClass().getField(fieldName);
        field.setAccessible(true);
        return field.get(object);
    }

    private static Object invoke(Object object, String methodName) throws ReflectiveOperationException {
        Method method = object.getClass().getMethod(methodName, new Class[0]);
        method.setAccessible(true);
        return method.invoke(object, new Object[0]);
    }
}

