/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.modules.appui.about;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.graalvm.visualvm.modules.appui.about.AboutDialog;
import org.graalvm.visualvm.modules.appui.about.AboutDialogControls;
import org.graalvm.visualvm.modules.appui.about.TextViewerComponent;
import org.graalvm.visualvm.uisupport.HTMLTextArea;
import org.graalvm.visualvm.uisupport.SeparatorLine;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class TextBrowser {
    private boolean copyingAllHtmlToClipboard = false;
    private static TextBrowser instance;
    private JDialog dialog;
    private JComponent contentPane;
    private JPanel buttonsContainer;
    private JButton closeButton;
    private JButton helperButton;
    private TextViewerComponent textDisplayer;
    private HTMLTextArea htmlTextDisplayer;
    private JScrollPane displayerScrollPane;
    private Dimension preferredSize = new Dimension(400, 300);

    static synchronized TextBrowser getInstance() {
        if (instance == null) {
            instance = new TextBrowser();
            instance.initComponents();
        }
        return instance;
    }

    void setCaption(String caption) {
        this.dialog.setTitle(caption);
    }

    void setPreferredBrowserSize(Dimension preferredSize) {
        this.preferredSize = preferredSize;
    }

    void showCodeText(String text) {
        this.textDisplayer.setText(text);
        this.displayerScrollPane.setViewportView(this.textDisplayer);
        try {
            this.textDisplayer.setCaretPosition(0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.displayerScrollPane.setPreferredSize(this.preferredSize);
        this.dialog.pack();
        this.closeButton.requestFocusInWindow();
        this.dialog.setLocationRelativeTo(null);
        this.dialog.setResizable(true);
        this.dialog.setVisible(true);
    }

    void showHTMLText(String text) {
        this.htmlTextDisplayer.setText(text);
        this.displayerScrollPane.setViewportView((Component)this.htmlTextDisplayer);
        try {
            this.htmlTextDisplayer.setCaretPosition(0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Dimension htmlSize = this.htmlTextDisplayer.getPreferredSize();
        htmlSize.width = Math.min(htmlSize.width, 700);
        htmlSize.height = Math.min(htmlSize.height, 500);
        this.displayerScrollPane.setPreferredSize(htmlSize);
        this.dialog.pack();
        this.closeButton.requestFocusInWindow();
        this.dialog.setLocationRelativeTo(null);
        this.dialog.setResizable(false);
        this.dialog.setVisible(true);
    }

    void setHelperButton(JButton helperButton) {
        if (this.helperButton != null && helperButton == null) {
            this.buttonsContainer.remove(this.helperButton);
        } else if (this.helperButton == null && helperButton != null) {
            this.buttonsContainer.add((Component)helperButton, "West");
        }
        this.helperButton = helperButton;
    }

    void close() {
        this.dialog.setVisible(false);
        this.dialog.dispose();
    }

    void copyAllHtmlToClipboard() {
        if (!this.htmlTextDisplayer.getText().isEmpty()) {
            this.copyingAllHtmlToClipboard = true;
            try {
                this.htmlTextDisplayer.copy();
            }
            finally {
                this.copyingAllHtmlToClipboard = false;
            }
        }
    }

    private TextBrowser() {
    }

    private void initComponents() {
        this.dialog = new JDialog(AboutDialog.getInstance().getDialog(), "", true);
        this.dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                TextBrowser.this.cleanup();
            }
        });
        this.contentPane = (JComponent)this.dialog.getContentPane();
        this.contentPane.setLayout(new BorderLayout());
        this.contentPane.getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), "CLOSE_ACTION");
        this.contentPane.getActionMap().put("CLOSE_ACTION", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TextBrowser.this.close();
            }
        });
        this.textDisplayer = new TextViewerComponent();
        this.htmlTextDisplayer = new HTMLTextArea(){

            public int getSelectionStart() {
                if (TextBrowser.this.copyingAllHtmlToClipboard) {
                    return 0;
                }
                return super.getSelectionStart();
            }

            public int getSelectionEnd() {
                if (TextBrowser.this.copyingAllHtmlToClipboard) {
                    return this.getText().length();
                }
                return super.getSelectionEnd();
            }
        };
        this.displayerScrollPane = new JScrollPane(20, 30);
        this.displayerScrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.displayerScrollPane.setViewportBorder(BorderFactory.createEmptyBorder());
        this.textDisplayer.setForeground(this.htmlTextDisplayer.getForeground());
        this.textDisplayer.setBackground(this.htmlTextDisplayer.getBackground());
        this.textDisplayer.setSelectionColor(this.htmlTextDisplayer.getSelectionColor());
        this.textDisplayer.setSelectedTextColor(this.htmlTextDisplayer.getSelectedTextColor());
        this.closeButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.closeButton, (String)NbBundle.getMessage(AboutDialogControls.class, (String)"LBL_Close"));
        this.closeButton.setDefaultCapable(true);
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TextBrowser.this.close();
                    }
                });
            }
        });
        this.buttonsContainer = new JPanel(new BorderLayout());
        this.buttonsContainer.setBorder(BorderFactory.createEmptyBorder(10, 10, 6, 10));
        this.buttonsContainer.add((Component)this.closeButton, "East");
        JPanel bottomPanel = new JPanel(new BorderLayout());
        final SeparatorLine separator = new SeparatorLine();
        bottomPanel.add((Component)separator, "North");
        bottomPanel.add((Component)this.buttonsContainer, "Center");
        final JScrollBar horizontalScroll = this.displayerScrollPane.getHorizontalScrollBar();
        if (horizontalScroll != null) {
            horizontalScroll.addHierarchyListener(new HierarchyListener(){

                @Override
                public void hierarchyChanged(HierarchyEvent e) {
                    if ((e.getChangeFlags() & 4L) != 0L) {
                        separator.setVisible(!horizontalScroll.isShowing());
                    }
                }
            });
        }
        this.contentPane.add((Component)this.displayerScrollPane, "Center");
        this.contentPane.add((Component)bottomPanel, "South");
        this.dialog.getRootPane().setDefaultButton(this.closeButton);
        this.dialog.setResizable(true);
        this.dialog.setDefaultCloseOperation(2);
    }

    private void cleanup() {
        this.setHelperButton(null);
        this.displayerScrollPane.getViewport().removeAll();
        this.textDisplayer.setText("");
        this.htmlTextDisplayer.setText("");
    }
}

