/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.util;

import com.adobe.epubcheck.util.outWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;

public class Archive {
    private ArrayList<String> paths;
    private ArrayList<String> names;
    private final File baseDir;
    private File epubFile;
    private String epubName;

    public Archive(String base, boolean save) {
        boolean deleteOnExit = !save;
        this.baseDir = this.makeCanonical(new File(base));
        if (!this.baseDir.exists() || !this.baseDir.isDirectory()) {
            throw new RuntimeException("The path specified for the archive is invalid");
        }
        this.epubName = this.baseDir.getName() + ".epub";
        this.epubFile = new File(this.baseDir.getParent() + File.separator + this.epubName);
        if (deleteOnExit) {
            this.epubFile.deleteOnExit();
        }
        this.paths = new ArrayList();
        this.names = new ArrayList();
    }

    public Archive(String base) {
        this(base, false);
    }

    public String getEpubName() {
        return this.epubName;
    }

    public File getEpubFile() {
        return this.epubFile;
    }

    public void deleteEpubFile() {
        if (!this.epubFile.delete()) {
            System.err.println("Unable to delete generated archive.");
        }
    }

    public void createArchive(File absoluteEpubFilePath) {
        this.epubFile = absoluteEpubFilePath;
        this.createArchive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createArchive() {
        ZipArchiveOutputStream out = null;
        try {
            this.collectFiles(this.baseDir, "");
            int mimetype = this.names.indexOf("mimetype");
            if (mimetype > -1) {
                String name = this.names.remove(mimetype);
                String path = this.paths.remove(mimetype);
                this.names.add(0, name);
                this.paths.add(0, path);
            }
            out = new ZipArchiveOutputStream(this.epubFile);
            out.setEncoding("UTF-8");
            for (int i = 0; i < this.paths.size(); ++i) {
                ZipArchiveEntry entry = new ZipArchiveEntry(new File(this.paths.get(i)), this.names.get(i));
                if (i == 0 && mimetype > -1) {
                    entry.setMethod(0);
                    entry.setSize(this.getSize(this.paths.get(i)));
                    entry.setCrc(this.getCRC(this.paths.get(i)));
                } else {
                    entry.setMethod(8);
                }
                out.putArchiveEntry((ArchiveEntry)entry);
                try (FileInputStream in = null;){
                    int len;
                    in = new FileInputStream(this.paths.get(i));
                    byte[] buf = new byte[1024];
                    while ((len = in.read(buf)) > 0) {
                        out.write(buf, 0, len);
                    }
                    out.closeArchiveEntry();
                    continue;
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        finally {
            try {
                if (out != null) {
                    out.flush();
                    out.finish();
                    out.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private File makeCanonical(File f) {
        if (f == null) {
            return null;
        }
        try {
            return f.getCanonicalFile();
        }
        catch (IOException ignored) {
            return f.getAbsoluteFile();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getSize(String path) throws IOException {
        try (FileInputStream in = null;){
            int len;
            in = new FileInputStream(path);
            byte[] buf = new byte[1024];
            int size = 0;
            while ((len = in.read(buf)) > 0) {
                size += len;
            }
            long l = size;
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getCRC(String path) throws IOException {
        FilterInputStream cis = null;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(path);
            cis = new CheckedInputStream(fis, new CRC32());
            byte[] buf = new byte[128];
            while (cis.read(buf) >= 0) {
            }
        }
        finally {
            if (fis != null) {
                fis.close();
            }
            if (cis != null) {
                cis.close();
            }
        }
        return ((CheckedInputStream)cis).getChecksum().getValue();
    }

    private void collectFiles(File dir, String dirName) {
        if (!dirName.equals("") && !dirName.endsWith("/")) {
            dirName = dirName + "/";
        }
        File[] files = dir.listFiles();
        assert (files != null);
        for (int i = 0; i < files.length; ++i) {
            if (!(!files[i].isFile() || files[i].getName().equals(".DS_Store") || files[i].getName().equals("._DS_Store") || files[i].getName().equals("Thumbs.db") || files[i].getName().equals("ehthumbs.db"))) {
                this.names.add(dirName + files[i].getName());
                this.paths.add(files[i].getAbsolutePath());
                continue;
            }
            if (!files[i].isDirectory() || files[i].getName().equals(".svn") || files[i].getName().equals(".git")) continue;
            this.collectFiles(files[i], dirName + files[i].getName() + "/");
        }
    }

    public void listFiles() {
        for (String name : this.names) {
            outWriter.println(name);
        }
    }
}

