/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.maven.polyglot.mapping;

import java.io.File;
import java.net.URL;
import java.util.Map;
import javax.inject.Inject;
import org.apache.maven.model.building.ModelSource;
import org.apache.maven.model.io.ModelReader;
import org.apache.maven.model.io.ModelWriter;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.sonatype.maven.polyglot.mapping.Mapping;

public abstract class MappingSupport
implements Mapping {
    private static final String[] EMPTY = new String[0];
    private String roleHint;
    private String[] pomNames = EMPTY;
    private String[] acceptOptionKeys = EMPTY;
    private String[] acceptLocationExtensions = EMPTY;
    private float priority;
    @Inject
    private PlexusContainer container;
    private ModelReader reader;
    private ModelWriter writer;

    protected MappingSupport(String roleHint) {
        this.roleHint = roleHint == null ? "default" : roleHint;
    }

    @Override
    public String getFlavour() {
        return this.roleHint;
    }

    @Override
    public ModelReader getReader() {
        if (this.reader == null) {
            try {
                assert (this.container != null);
                this.reader = (ModelReader)this.container.lookup(ModelReader.class, this.roleHint);
            }
            catch (ComponentLookupException e) {
                throw new RuntimeException(e);
            }
        }
        return this.reader;
    }

    @Override
    public ModelWriter getWriter() {
        if (this.writer == null) {
            try {
                assert (this.container != null);
                this.writer = (ModelWriter)this.container.lookup(ModelWriter.class, this.roleHint);
            }
            catch (ComponentLookupException e) {
                throw new RuntimeException(e);
            }
        }
        return this.writer;
    }

    public String[] getAcceptLocationExtensions() {
        return this.acceptLocationExtensions;
    }

    public void setAcceptLocationExtensions(String ... accept) {
        this.acceptLocationExtensions = accept;
    }

    public String[] getAcceptOptionKeys() {
        return this.acceptOptionKeys;
    }

    public void setAcceptOptionKeys(String ... accept) {
        this.acceptOptionKeys = accept;
    }

    public String[] getPomNames() {
        return this.pomNames;
    }

    public void setPomNames(String ... names) {
        this.pomNames = names;
    }

    @Override
    public File locatePom(File dir) {
        assert (dir != null);
        String[] stringArray = this.getPomNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            File file = new File(dir, name);
            if (file.exists()) {
                return file;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public boolean accept(Map<String, ?> options) {
        if (options != null) {
            String[] stringArray = this.getAcceptOptionKeys();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                if (options.containsKey(key)) {
                    return true;
                }
                ++n2;
            }
            String location = this.getLocation(options);
            if (location != null) {
                String[] stringArray2 = this.getAcceptLocationExtensions();
                int n3 = stringArray2.length;
                n = 0;
                while (n < n3) {
                    String ext = stringArray2[n];
                    if (location.endsWith(ext)) {
                        return true;
                    }
                    ++n;
                }
            }
        }
        return false;
    }

    @Override
    public float getPriority() {
        return this.priority;
    }

    protected void setPriority(float priority) {
        this.priority = priority;
    }

    public String getLocation(Map<?, ?> options) {
        if (options != null) {
            Object tmp = options.get("org.apache.maven.model.building.source");
            if (tmp instanceof String) {
                return (String)tmp;
            }
            if (tmp instanceof URL) {
                return ((URL)tmp).toExternalForm();
            }
            if (tmp instanceof File) {
                return ((File)tmp).getAbsolutePath();
            }
            if (tmp instanceof ModelSource) {
                return ((ModelSource)tmp).getLocation();
            }
        }
        return null;
    }
}

