/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.sql.dictionary;

import org.apache.derby.catalog.AliasInfo;
import org.apache.derby.catalog.DependableFinder;
import org.apache.derby.catalog.UUID;
import org.apache.derby.catalog.types.AggregateAliasInfo;
import org.apache.derby.catalog.types.RoutineAliasInfo;
import org.apache.derby.catalog.types.UDTAliasInfo;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.depend.DependencyManager;
import org.apache.derby.iapi.sql.depend.Dependent;
import org.apache.derby.iapi.sql.depend.Provider;
import org.apache.derby.iapi.sql.dictionary.DataDescriptorGenerator;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.PrivilegedSQLObject;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.util.IdUtil;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

public final class AliasDescriptor
extends PrivilegedSQLObject
implements Provider,
Dependent {
    private final UUID aliasID;
    private final String aliasName;
    private final UUID schemaID;
    private final String javaClassName;
    private final char aliasType;
    private final char nameSpace;
    private final boolean systemAlias;
    private final AliasInfo aliasInfo;
    private final String specificName;
    private final SchemaDescriptor schemaDescriptor;

    public AliasDescriptor(DataDictionary dataDictionary, UUID aliasID, String aliasName, UUID schemaID, String javaClassName, char aliasType, char nameSpace, boolean systemAlias, AliasInfo aliasInfo, String specificName) throws StandardException {
        super(dataDictionary);
        this.aliasID = aliasID;
        this.aliasName = aliasName;
        this.schemaID = schemaID;
        this.schemaDescriptor = dataDictionary.getSchemaDescriptor(schemaID, null);
        this.javaClassName = javaClassName;
        this.aliasType = aliasType;
        this.nameSpace = nameSpace;
        this.systemAlias = systemAlias;
        this.aliasInfo = aliasInfo;
        if (specificName == null) {
            specificName = dataDictionary.getSystemSQLName();
        }
        this.specificName = specificName;
    }

    @Override
    public UUID getUUID() {
        return this.aliasID;
    }

    @Override
    public String getObjectTypeName() {
        if (this.aliasInfo instanceof UDTAliasInfo) {
            return "TYPE";
        }
        if (this.aliasInfo instanceof AggregateAliasInfo) {
            return "DERBY AGGREGATE";
        }
        SanityManager.THROWASSERT((String)("Unsupported alias type: " + this.aliasInfo.getClass().getName()));
        return null;
    }

    public UUID getSchemaUUID() {
        return this.schemaID;
    }

    @Override
    public final SchemaDescriptor getSchemaDescriptor() {
        return this.schemaDescriptor;
    }

    @Override
    public final String getName() {
        return this.aliasName;
    }

    public String getSchemaName() {
        return this.schemaDescriptor.getSchemaName();
    }

    public String getQualifiedName() {
        return IdUtil.mkQualifiedName(this.getSchemaName(), this.aliasName);
    }

    public String getJavaClassName() {
        return this.javaClassName;
    }

    public char getAliasType() {
        return this.aliasType;
    }

    public char getNameSpace() {
        return this.nameSpace;
    }

    public boolean getSystemAlias() {
        return this.systemAlias;
    }

    public AliasInfo getAliasInfo() {
        return this.aliasInfo;
    }

    public String toString() {
        return "aliasID: " + String.valueOf(this.aliasID) + "\naliasName: " + this.aliasName + "\nschemaID: " + String.valueOf(this.schemaID) + "\njavaClassName: " + this.javaClassName + "\naliasType: " + this.aliasType + "\nnameSpace: " + this.nameSpace + "\nsystemAlias: " + this.systemAlias + "\naliasInfo: " + String.valueOf(this.aliasInfo) + "\n";
    }

    public boolean equals(Object otherObject) {
        if (!(otherObject instanceof AliasDescriptor)) {
            return false;
        }
        AliasDescriptor other = (AliasDescriptor)otherObject;
        return this.aliasID.equals(other.getUUID());
    }

    public int hashCode() {
        return this.aliasID.hashCode();
    }

    @Override
    public DependableFinder getDependableFinder() {
        return this.getDependableFinder(136);
    }

    @Override
    public String getObjectName() {
        return this.aliasName;
    }

    @Override
    public UUID getObjectID() {
        return this.aliasID;
    }

    @Override
    public String getClassType() {
        return "Alias";
    }

    @Override
    public String getDescriptorType() {
        return AliasDescriptor.getAliasType(this.aliasType);
    }

    public static final String getAliasType(char nameSpace) {
        switch (nameSpace) {
            case 'P': {
                return "PROCEDURE";
            }
            case 'F': {
                return "FUNCTION";
            }
            case 'S': {
                return "SYNONYM";
            }
            case 'A': {
                return "TYPE";
            }
            case 'G': {
                return "DERBY AGGREGATE";
            }
        }
        return null;
    }

    @Override
    public String getDescriptorName() {
        return this.aliasName;
    }

    public String getSpecificName() {
        return this.specificName;
    }

    @Override
    public boolean isPersistent() {
        return !this.getSchemaUUID().toString().equals("c013800d-00fb-2642-07ec-000000134f30");
    }

    public boolean isTableFunction() {
        if (this.getAliasType() != 'F') {
            return false;
        }
        RoutineAliasInfo rai = (RoutineAliasInfo)this.getAliasInfo();
        return rai.getReturnType().isRowMultiSet();
    }

    public void drop(LanguageConnectionContext lcc) throws StandardException {
        DataDictionary dd = this.getDataDictionary();
        TransactionController tc = lcc.getTransactionExecute();
        DependencyManager dm = dd.getDependencyManager();
        int invalidationType = 0;
        switch (this.getAliasType()) {
            case 'F': 
            case 'P': {
                invalidationType = 6;
                break;
            }
            case 'S': {
                invalidationType = 43;
                break;
            }
            case 'A': {
                invalidationType = 50;
                break;
            }
            case 'G': {
                invalidationType = 51;
            }
        }
        dm.invalidateFor(this, invalidationType, lcc);
        if (this.getAliasType() == 'S') {
            SchemaDescriptor sd = dd.getSchemaDescriptor(this.schemaID, tc);
            DataDescriptorGenerator ddg = dd.getDataDescriptorGenerator();
            TableDescriptor td = ddg.newTableDescriptor(this.aliasName, sd, 4, 'R');
            dd.dropTableDescriptor(td, sd, tc);
        } else {
            dd.dropAllRoutinePermDescriptors(this.getUUID(), tc);
        }
        dd.dropAliasDescriptor(this, tc);
    }

    @Override
    public synchronized boolean isValid() {
        return true;
    }

    @Override
    public void prepareToInvalidate(Provider p, int action, LanguageConnectionContext lcc) throws StandardException {
        DependencyManager dm = this.getDataDictionary().getDependencyManager();
        switch (action) {
            default: 
        }
        throw StandardException.newException((String)"X0Y30.S", (Object[])new Object[]{dm.getActionString(action), p.getObjectName(), this.getQualifiedName()});
    }

    @Override
    public void makeInvalid(int action, LanguageConnectionContext lcc) throws StandardException {
        DependencyManager dm = this.getDataDictionary().getDependencyManager();
        SanityManager.THROWASSERT((String)("makeInvalid(" + dm.getActionString(action) + ") not expected to get called"));
    }
}

