/*
 * Decompiled with CFR 0.152.
 */
package com.jrjackson;

import com.fasterxml.jackson.core.JsonParser;
import com.jrjackson.IParseHandler;
import com.jrjackson.ParseError;
import com.jrjackson.RubyConverter;
import com.jrjackson.RubyNameConverter;
import com.jrjackson.RubyStringConverter;
import java.io.IOException;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyHash;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class RubyHandler
implements IParseHandler<IRubyObject, RubyArray, RubyHash> {
    private final Ruby _ruby;
    private final ThreadContext _ctx;
    private final RubyNameConverter _keyConv;
    private final RubyConverter _intConv;
    private final RubyConverter _floatConv;
    private final RubyConverter _strConv;
    private IRubyObject _result;

    public RubyHandler(ThreadContext ctx, RubyNameConverter keyConverter, RubyConverter intConverter, RubyConverter floatConverter) {
        this._ctx = ctx;
        this._ruby = ctx.runtime;
        this._keyConv = keyConverter;
        this._intConv = intConverter;
        this._floatConv = floatConverter;
        this._strConv = new RubyStringConverter();
    }

    @Override
    public void addValue(IRubyObject value) {
        this._result = value;
    }

    @Override
    public IRubyObject hashStart() {
        return RubyHash.newHash((Ruby)this._ruby);
    }

    @Override
    public void hashEnd() {
    }

    @Override
    public IRubyObject hashKey(String key) {
        return this._keyConv.convert(this._ruby, key);
    }

    @Override
    public void hashSet(RubyHash hash, IRubyObject key, IRubyObject value) {
        hash.fastASet(key, value);
    }

    @Override
    public IRubyObject arrayStart() {
        return RubyArray.newArray((Ruby)this._ruby);
    }

    @Override
    public void arrayEnd() {
    }

    @Override
    public void arrayAppend(RubyArray array, IRubyObject value) {
        array.append(value);
    }

    @Override
    public IRubyObject treatNull() {
        return this._ctx.nil;
    }

    @Override
    public IRubyObject treatInt(JsonParser jp) throws IOException {
        return this._intConv.convert(this._ruby, jp);
    }

    @Override
    public IRubyObject treatFloat(JsonParser jp) throws IOException {
        return this._floatConv.convert(this._ruby, jp);
    }

    @Override
    public IRubyObject treatString(JsonParser jp) throws IOException {
        return this._strConv.convert(this._ruby, jp);
    }

    @Override
    public IRubyObject trueValue() {
        return this._ruby.newBoolean(true);
    }

    @Override
    public IRubyObject falseValue() {
        return this._ruby.newBoolean(false);
    }

    @Override
    public IRubyObject getResult() {
        return this._result == null ? this._ctx.nil : this._result;
    }

    @Override
    public void raiseError(String e) {
        throw ParseError.newParseError(this._ruby, e);
    }
}

