/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.ackedqueue;

public class Checkpoint {
    public static final int VERSION = 1;
    private final int pageNum;
    private final int firstUnackedPageNum;
    private final long firstUnackedSeqNum;
    private final long minSeqNum;
    private final int elementCount;

    public Checkpoint(int pageNum, int firstUnackedPageNum, long firstUnackedSeqNum, long minSeqNum, int elementCount) {
        this.pageNum = pageNum;
        this.firstUnackedPageNum = firstUnackedPageNum;
        this.firstUnackedSeqNum = firstUnackedSeqNum;
        this.minSeqNum = minSeqNum;
        this.elementCount = elementCount;
    }

    public int getPageNum() {
        return this.pageNum;
    }

    public int getFirstUnackedPageNum() {
        return this.firstUnackedPageNum;
    }

    public long getFirstUnackedSeqNum() {
        return this.firstUnackedSeqNum;
    }

    public long getMinSeqNum() {
        return this.minSeqNum;
    }

    public int getElementCount() {
        return this.elementCount;
    }

    public boolean isFullyAcked() {
        return this.elementCount > 0 && this.firstUnackedSeqNum >= this.minSeqNum + (long)this.elementCount;
    }

    public long maxSeqNum() {
        return this.minSeqNum + (long)this.elementCount - 1L;
    }

    public String toString() {
        return "pageNum=" + this.pageNum + ", firstUnackedPageNum=" + this.firstUnackedPageNum + ", firstUnackedSeqNum=" + this.firstUnackedSeqNum + ", minSeqNum=" + this.minSeqNum + ", elementCount=" + this.elementCount + ", isFullyAcked=" + (this.isFullyAcked() ? "yes" : "no");
    }

    public boolean equals(Checkpoint other) {
        if (this == other) {
            return true;
        }
        return this.pageNum == other.pageNum && this.firstUnackedPageNum == other.firstUnackedPageNum && this.firstUnackedSeqNum == other.firstUnackedSeqNum && this.minSeqNum == other.minSeqNum && this.elementCount == other.elementCount;
    }
}

