/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.io.rest.internal.resources;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.net.URI;
import java.util.HashMap;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.openhab.core.i18n.LocaleProvider;
import org.openhab.core.i18n.UnitProvider;
import org.openhab.core.io.rest.RESTResource;
import org.openhab.core.io.rest.internal.resources.beans.RootBean;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.jaxrs.runtime.JaxrsServiceRuntime;
import org.osgi.service.jaxrs.runtime.dto.ApplicationDTO;
import org.osgi.service.jaxrs.runtime.dto.ResourceDTO;
import org.osgi.service.jaxrs.runtime.dto.RuntimeDTO;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JSONRequired;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsApplicationSelect;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsName;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Produces(value={"application/json"})
@Path(value="/")
@Tag(name="root")
@Component(configurationPid={"org.openhab.restroot"})
@JaxrsResource
@JaxrsName(value="root")
@JaxrsApplicationSelect(value="(osgi.jaxrs.name=openhab)")
@JSONRequired
@NonNullByDefault
public class RootResource
implements RESTResource {
    public static final String RESOURCE_NAME = "root";
    private final Logger logger = LoggerFactory.getLogger(RootResource.class);
    private final JaxrsServiceRuntime runtime;
    private final LocaleProvider localeProvider;
    private final UnitProvider unitProvider;

    @Activate
    public RootResource(@Reference JaxrsServiceRuntime runtime, @Reference LocaleProvider localeProvider, @Reference UnitProvider unitProvider) {
        this.runtime = runtime;
        this.localeProvider = localeProvider;
        this.unitProvider = unitProvider;
    }

    @GET
    @Path(value="/")
    @Produces(value={"application/json"})
    @Operation(operationId="getRoot", summary="Gets information about the runtime, the API version and links to resources.", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=RootBean.class))})})
    public Response getRoot(@Context UriInfo uriInfo) {
        HashMap<String, String> collectedLinks = new HashMap<String, String>();
        RuntimeDTO runtimeDTO = this.runtime.getRuntimeDTO();
        RootBean bean = new RootBean(this.localeProvider, this.unitProvider);
        ApplicationDTO[] applicationDTOArray = runtimeDTO.applicationDTOs;
        int n = runtimeDTO.applicationDTOs.length;
        int n2 = 0;
        while (n2 < n) {
            ApplicationDTO applicationDTO = applicationDTOArray[n2];
            ResourceDTO[] resourceDTOArray = applicationDTO.resourceDTOs;
            int n3 = applicationDTO.resourceDTOs.length;
            int n4 = 0;
            while (n4 < n3) {
                URI uri;
                ResourceDTO resourceDTO = resourceDTOArray[n4];
                String name2 = resourceDTO.name;
                if (!(name2 == null || name2.isEmpty() || name2.startsWith(".") || RESOURCE_NAME.equals(name2) || collectedLinks.put((uri = uriInfo.getBaseUriBuilder().path("/" + name2).build(new Object[0])).toASCIIString(), name2) == null)) {
                    this.logger.warn("Duplicate entry: {}", (Object)name2);
                }
                ++n4;
            }
            ++n2;
        }
        collectedLinks.forEach((path, name) -> rootBean.links.add(new RootBean.Links((String)name, (String)path)));
        return Response.ok((Object)bean).build();
    }
}

