.\" $XConsortium: piano.man /main/4 1995/07/17 10:48:30 drk $
.\" Motif
.\"
.\" Copyright (c) 1987-2012, The Open Group. All rights reserved.
.\"
.\" These libraries and programs are free software; you can
.\" redistribute them and/or modify them under the terms of the GNU
.\" Lesser General Public License as published by the Free Software
.\" Foundation; either version 2 of the License, or (at your option)
.\" any later version.
.\"
.\" These libraries and programs are distributed in the hope that
.\" they will be useful, but WITHOUT ANY WARRANTY; without even the
.\" implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
.\" PURPOSE. See the GNU Lesser General Public License for more
.\" details.
.\"
.\" You should have received a copy of the GNU Lesser General Public
.\" License along with these librararies and programs; if not, write
.\" to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
.\" Floor, Boston, MA 02110-1301 USA
...\" 
...\" 
...\" HISTORY
.TH piano 1X MOTIF "Demonstration programs"
.SH NAME
\fBpiano\fR\(emMIDI demo
.SH SYNOPSIS
.sS
\fBpiano\fR
.sE
.SH DESCRIPTION
The Piano demo shows how one might write a MIDI (MOTIF INTERFACE to
DUMB INSTRUMENTS) application.  Both a staff, for writing music, and
keyboard are provided.  Piano is a musical demo that allows multiple
voices to be played by connecting to other displays.  It also provides
the capability to save and restore voices.
.PP
When running the program, you can either play the keyboard directly 
by 'tickling the ivories' using Button1, or you can enter notes by
pressing Button 1 on the staff and depositing the active note
specified by the cursor.  To change the active note, select another
note or rest in the pallet at the bottom. The selected note will be
displayed as the new mouse cursor.
.PP
Though the note selection is limited, it is possible to play sharps as
well as naturals.  The interface isn't advanced enough to handle
flats.  Note that E# will play as F and B# will play as C.
.PP
The staff will automatically resize larger as notes are added past the
right side of the staff.  To see these notes, scroll the score window
as needed.
.PP
If you wish to delete a note in the staff, press Button2 over the
note.  The note will disappear and the notes to the right will shift
over.
.PP
Pressing Button3 over the staff will display a popup menu associated
with this staff.  It contains the following items:
.PP
\fBAdd Voice\fR         This function is used to connect
.br
                        another display to a new staff.
.br
                        After selecting this command, you 
.br
                        will be prompted for the display 
.br
                        to connect.  Any music written in
.br
                        the new staff will play to this 
.br
                        display.  Note that pressing the 
.br
                        right mouse button on the new staff 
.br
                        will show the name of the display 
.br
                        in the menu's title.In addition, 
.br
                        this menu's commands will relate 
.br
                        to this staff.
.br
                        The new staff will be added to the
.br
                        bottom of the score and it may be
.br
                        necessary to scroll down to make
.br
                        it visible.
.PP
\fBRemove Voice\fR              Removes a staff and voice from the
.br
                        score.  There is no undo for this
.br
                        command; all music written in this 
.br
                        staff will be deleted.
.PP
\fBClear Voice\fR               Removes all notes in a 
.br
                        staff.  This will not effect the 
.br
                        display connection.
.PP
\fBPlay Voice\fR                Plays the notes in the selected 
.br
                        staff.  If the resource, 
.br
                        \fBuseKeyboard\fR, is set to True, 
.br
                        which is the default, the keyboard 
.br
                        will play along.
.PP
\fBPlay All\fR          Plays all voices in the score 
.br
                        together.
.PP
\fBSave Voice\fR                Saves the selected voice to a file.
.br
                        A File Selection Dialog will be
.br
                        displayed to prompt for the name of
.br
                        the file in which to save the voice.  
.br
                        The display connection information
.br
                        is not saved.
.PP
\fBLoad Voice\fR                Loads a voice from a file. This will
.br
                        append to any existing notes 
.br
                        in the voice.
.PP
Piano also supports the following resources:
.PP
\fBbaseDuration\fR              Sets the duration of a quarter note 
.br
                        (in msec).
.br
                        Default value = 200
.PP
\fBbaseFrequency\fR             Sets the frequency of bottom note 
.br
                        (in Hz).
.br
                        Default value = 246.9413
.PP
\fBuseKeyboard\fR               Specifies if keyboard should play
.br
                        along.
.br
                        Default value = True
.PP
\fBwkeyCount\fR         Is the number of white keys on the 
.br
                        keyboard.
.br
                        Default value = 28
.PP
\fBkeyHeight\fR         Is the initial height in pixels of
.br
                        the white keys.
.br
                        Default value = 160
.PP
\fBkeyWidth\fR          Is the initial width in pixels of 
.br
                        the white keys.
.br
                        Default value = 20
.PP
Two voices are included with the demo, \fBInv8_part1.piano\fR and
\fBInv8_part2.piano\fR.
These are the two voices of Bach's Invention #8.  Try loading these into two
voices connected to different displays and play them together.
.SS Problems
So far, changing the pitches doesn't seem to work on SUN, DEC PMAX3100,
and SGI Personal Iris.  On the RS6000 and HP700 things should work fine.
If XBell() doesn't work correctly on your system change the PlayNote()
function as needed.
.PP
-----
.br
Enjoy,
.br
Andrew deBlois
