/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.test.applet;

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Canvas;
import java.nio.FloatBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLException;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.Sys;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.ARBTransposeMatrix;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GLContext;

public class GearsApplet
extends Applet {
    Canvas display_parent;
    Thread gameThread;
    boolean running;
    private float view_rotx = 20.0f;
    private float view_roty = 30.0f;
    private float view_rotz;
    private int gear1;
    private int gear2;
    private int gear3;
    private float angle;
    boolean keyDown;
    private int prevMouseX;
    private int prevMouseY;
    private boolean mouseButtonDown;

    public void startLWJGL() {
        this.gameThread = new Thread(){

            public void run() {
                GearsApplet.this.running = true;
                try {
                    Display.setParent((Canvas)GearsApplet.this.display_parent);
                    Display.create();
                    GearsApplet.this.initGL();
                }
                catch (LWJGLException e) {
                    e.printStackTrace();
                }
                GearsApplet.this.gameLoop();
            }
        };
        this.gameThread.start();
    }

    private void stopLWJGL() {
        this.running = false;
        try {
            this.gameThread.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void start() {
    }

    public void stop() {
    }

    public void destroy() {
        this.remove(this.display_parent);
        super.destroy();
        System.out.println("Clear up");
    }

    public void init() {
        this.setLayout(new BorderLayout());
        try {
            this.display_parent = new Canvas(){

                public void addNotify() {
                    super.addNotify();
                    GearsApplet.this.startLWJGL();
                }

                public void removeNotify() {
                    GearsApplet.this.stopLWJGL();
                    super.removeNotify();
                }
            };
            this.display_parent.setSize(this.getWidth(), this.getHeight());
            this.add(this.display_parent);
            this.display_parent.setFocusable(true);
            this.display_parent.requestFocus();
            this.display_parent.setIgnoreRepaint(true);
            this.setVisible(true);
        }
        catch (Exception e) {
            System.err.println(e);
            throw new RuntimeException("Unable to create display");
        }
    }

    public void gameLoop() {
        long startTime = System.currentTimeMillis() + 5000L;
        long fps = 0L;
        while (this.running) {
            this.angle += 2.0f;
            this.drawLoop();
            Display.update();
            if (startTime > System.currentTimeMillis()) {
                ++fps;
            } else {
                long timeUsed = 5000L + (startTime - System.currentTimeMillis());
                startTime = System.currentTimeMillis() + 5000L;
                System.out.println(fps + " frames 2 in " + (float)timeUsed / 1000.0f + " seconds = " + (float)fps / ((float)timeUsed / 1000.0f));
                fps = 0L;
            }
            if (Mouse.isButtonDown((int)0)) {
                if (!this.mouseButtonDown) {
                    this.prevMouseX = Mouse.getX();
                    this.prevMouseY = Mouse.getY();
                }
                this.mouseButtonDown = true;
            } else {
                this.mouseButtonDown = false;
            }
            if (this.mouseButtonDown) {
                int x = Mouse.getX();
                int y = Mouse.getY();
                float thetaY = 360.0f * ((float)(x - this.prevMouseX) / (float)this.display_parent.getWidth());
                float thetaX = 360.0f * ((float)(this.prevMouseY - y) / (float)this.display_parent.getHeight());
                this.prevMouseX = x;
                this.prevMouseY = y;
                this.view_rotx += thetaX;
                this.view_roty += thetaY;
            }
            if (!this.keyDown || Keyboard.isKeyDown((int)33)) continue;
            this.keyDown = false;
            try {
                if (Display.isFullscreen()) {
                    Display.setFullscreen((boolean)false);
                    continue;
                }
                Display.setFullscreen((boolean)true);
            }
            catch (LWJGLException e) {
                e.printStackTrace();
            }
        }
        Display.destroy();
    }

    public void drawLoop() {
        GL11.glClear((int)16640);
        GL11.glPushMatrix();
        GL11.glRotatef((float)this.view_rotx, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)this.view_roty, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)this.view_rotz, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)-3.0f, (float)-2.0f, (float)0.0f);
        GL11.glRotatef((float)this.angle, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glCallList((int)this.gear1);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)3.1f, (float)-2.0f, (float)0.0f);
        GL11.glRotatef((float)(-2.0f * this.angle - 9.0f), (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glCallList((int)this.gear2);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)-3.1f, (float)4.2f, (float)0.0f);
        GL11.glRotatef((float)(-2.0f * this.angle - 25.0f), (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glCallList((int)this.gear3);
        GL11.glPopMatrix();
        GL11.glPopMatrix();
    }

    protected void initGL() {
        try {
            FloatBuffer pos = BufferUtils.createFloatBuffer((int)4).put(new float[]{5.0f, 5.0f, 10.0f, 0.0f});
            FloatBuffer red = BufferUtils.createFloatBuffer((int)4).put(new float[]{0.8f, 0.1f, 0.0f, 1.0f});
            FloatBuffer green = BufferUtils.createFloatBuffer((int)4).put(new float[]{0.0f, 0.8f, 0.2f, 1.0f});
            FloatBuffer blue = BufferUtils.createFloatBuffer((int)4).put(new float[]{0.2f, 0.2f, 1.0f, 1.0f});
            pos.flip();
            red.flip();
            green.flip();
            blue.flip();
            GL11.glLight((int)16384, (int)4611, (FloatBuffer)pos);
            GL11.glEnable((int)2884);
            GL11.glEnable((int)2896);
            GL11.glEnable((int)16384);
            GL11.glEnable((int)2929);
            this.gear1 = GL11.glGenLists((int)1);
            GL11.glNewList((int)this.gear1, (int)4864);
            GL11.glMaterial((int)1028, (int)5634, (FloatBuffer)red);
            this.gear(1.0f, 4.0f, 1.0f, 20, 0.7f);
            GL11.glEndList();
            this.gear2 = GL11.glGenLists((int)1);
            GL11.glNewList((int)this.gear2, (int)4864);
            GL11.glMaterial((int)1028, (int)5634, (FloatBuffer)green);
            this.gear(0.5f, 2.0f, 2.0f, 10, 0.7f);
            GL11.glEndList();
            this.gear3 = GL11.glGenLists((int)1);
            GL11.glNewList((int)this.gear3, (int)4864);
            GL11.glMaterial((int)1028, (int)5634, (FloatBuffer)blue);
            this.gear(1.3f, 2.0f, 0.5f, 10, 0.7f);
            GL11.glEndList();
            GL11.glEnable((int)2977);
            GL11.glMatrixMode((int)5889);
            System.err.println("LWJGL: " + Sys.getVersion() + " / " + LWJGLUtil.getPlatformName());
            System.err.println("GL_VENDOR: " + GL11.glGetString((int)7936));
            System.err.println("GL_RENDERER: " + GL11.glGetString((int)7937));
            System.err.println("GL_VERSION: " + GL11.glGetString((int)7938));
            System.err.println();
            System.err.println("glLoadTransposeMatrixfARB() supported: " + GLContext.getCapabilities().GL_ARB_transpose_matrix);
            if (!GLContext.getCapabilities().GL_ARB_transpose_matrix) {
                GL11.glLoadIdentity();
            } else {
                FloatBuffer identityTranspose = BufferUtils.createFloatBuffer((int)16).put(new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f});
                identityTranspose.flip();
                ARBTransposeMatrix.glLoadTransposeMatrixARB((FloatBuffer)identityTranspose);
            }
            float h = (float)this.display_parent.getHeight() / (float)this.display_parent.getWidth();
            GL11.glFrustum((double)-1.0, (double)1.0, (double)(-h), (double)h, (double)5.0, (double)60.0);
            GL11.glMatrixMode((int)5888);
            GL11.glLoadIdentity();
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-40.0f);
        }
        catch (Exception e) {
            System.err.println(e);
            this.running = false;
        }
    }

    private void gear(float inner_radius, float outer_radius, float width, int teeth, float tooth_depth) {
        float angle;
        int i;
        float r0 = inner_radius;
        float r1 = outer_radius - tooth_depth / 2.0f;
        float r2 = outer_radius + tooth_depth / 2.0f;
        float da = (float)Math.PI * 2 / (float)teeth / 4.0f;
        GL11.glShadeModel((int)7424);
        GL11.glNormal3f((float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glBegin((int)8);
        for (i = 0; i <= teeth; ++i) {
            angle = (float)i * 2.0f * (float)Math.PI / (float)teeth;
            GL11.glVertex3f((float)(r0 * (float)Math.cos(angle)), (float)(r0 * (float)Math.sin(angle)), (float)(width * 0.5f));
            GL11.glVertex3f((float)(r1 * (float)Math.cos(angle)), (float)(r1 * (float)Math.sin(angle)), (float)(width * 0.5f));
            if (i >= teeth) continue;
            GL11.glVertex3f((float)(r0 * (float)Math.cos(angle)), (float)(r0 * (float)Math.sin(angle)), (float)(width * 0.5f));
            GL11.glVertex3f((float)(r1 * (float)Math.cos(angle + 3.0f * da)), (float)(r1 * (float)Math.sin(angle + 3.0f * da)), (float)(width * 0.5f));
        }
        GL11.glEnd();
        GL11.glBegin((int)7);
        for (i = 0; i < teeth; ++i) {
            angle = (float)i * 2.0f * (float)Math.PI / (float)teeth;
            GL11.glVertex3f((float)(r1 * (float)Math.cos(angle)), (float)(r1 * (float)Math.sin(angle)), (float)(width * 0.5f));
            GL11.glVertex3f((float)(r2 * (float)Math.cos(angle + da)), (float)(r2 * (float)Math.sin(angle + da)), (float)(width * 0.5f));
            GL11.glVertex3f((float)(r2 * (float)Math.cos(angle + 2.0f * da)), (float)(r2 * (float)Math.sin(angle + 2.0f * da)), (float)(width * 0.5f));
            GL11.glVertex3f((float)(r1 * (float)Math.cos(angle + 3.0f * da)), (float)(r1 * (float)Math.sin(angle + 3.0f * da)), (float)(width * 0.5f));
        }
        GL11.glEnd();
        GL11.glBegin((int)8);
        for (i = 0; i <= teeth; ++i) {
            angle = (float)i * 2.0f * (float)Math.PI / (float)teeth;
            GL11.glVertex3f((float)(r1 * (float)Math.cos(angle)), (float)(r1 * (float)Math.sin(angle)), (float)(-width * 0.5f));
            GL11.glVertex3f((float)(r0 * (float)Math.cos(angle)), (float)(r0 * (float)Math.sin(angle)), (float)(-width * 0.5f));
            GL11.glVertex3f((float)(r1 * (float)Math.cos(angle + 3.0f * da)), (float)(r1 * (float)Math.sin(angle + 3.0f * da)), (float)(-width * 0.5f));
            GL11.glVertex3f((float)(r0 * (float)Math.cos(angle)), (float)(r0 * (float)Math.sin(angle)), (float)(-width * 0.5f));
        }
        GL11.glEnd();
        GL11.glBegin((int)7);
        for (i = 0; i < teeth; ++i) {
            angle = (float)i * 2.0f * (float)Math.PI / (float)teeth;
            GL11.glVertex3f((float)(r1 * (float)Math.cos(angle + 3.0f * da)), (float)(r1 * (float)Math.sin(angle + 3.0f * da)), (float)(-width * 0.5f));
            GL11.glVertex3f((float)(r2 * (float)Math.cos(angle + 2.0f * da)), (float)(r2 * (float)Math.sin(angle + 2.0f * da)), (float)(-width * 0.5f));
            GL11.glVertex3f((float)(r2 * (float)Math.cos(angle + da)), (float)(r2 * (float)Math.sin(angle + da)), (float)(-width * 0.5f));
            GL11.glVertex3f((float)(r1 * (float)Math.cos(angle)), (float)(r1 * (float)Math.sin(angle)), (float)(-width * 0.5f));
        }
        GL11.glEnd();
        GL11.glBegin((int)8);
        for (i = 0; i < teeth; ++i) {
            angle = (float)i * 2.0f * (float)Math.PI / (float)teeth;
            GL11.glVertex3f((float)(r1 * (float)Math.cos(angle)), (float)(r1 * (float)Math.sin(angle)), (float)(width * 0.5f));
            GL11.glVertex3f((float)(r1 * (float)Math.cos(angle)), (float)(r1 * (float)Math.sin(angle)), (float)(-width * 0.5f));
            float u = r2 * (float)Math.cos(angle + da) - r1 * (float)Math.cos(angle);
            float v = r2 * (float)Math.sin(angle + da) - r1 * (float)Math.sin(angle);
            float len = (float)Math.sqrt(u * u + v * v);
            GL11.glNormal3f((float)(v /= len), (float)(-(u /= len)), (float)0.0f);
            GL11.glVertex3f((float)(r2 * (float)Math.cos(angle + da)), (float)(r2 * (float)Math.sin(angle + da)), (float)(width * 0.5f));
            GL11.glVertex3f((float)(r2 * (float)Math.cos(angle + da)), (float)(r2 * (float)Math.sin(angle + da)), (float)(-width * 0.5f));
            GL11.glNormal3f((float)((float)Math.cos(angle)), (float)((float)Math.sin(angle)), (float)0.0f);
            GL11.glVertex3f((float)(r2 * (float)Math.cos(angle + 2.0f * da)), (float)(r2 * (float)Math.sin(angle + 2.0f * da)), (float)(width * 0.5f));
            GL11.glVertex3f((float)(r2 * (float)Math.cos(angle + 2.0f * da)), (float)(r2 * (float)Math.sin(angle + 2.0f * da)), (float)(-width * 0.5f));
            u = r1 * (float)Math.cos(angle + 3.0f * da) - r2 * (float)Math.cos(angle + 2.0f * da);
            v = r1 * (float)Math.sin(angle + 3.0f * da) - r2 * (float)Math.sin(angle + 2.0f * da);
            GL11.glNormal3f((float)v, (float)(-u), (float)0.0f);
            GL11.glVertex3f((float)(r1 * (float)Math.cos(angle + 3.0f * da)), (float)(r1 * (float)Math.sin(angle + 3.0f * da)), (float)(width * 0.5f));
            GL11.glVertex3f((float)(r1 * (float)Math.cos(angle + 3.0f * da)), (float)(r1 * (float)Math.sin(angle + 3.0f * da)), (float)(-width * 0.5f));
            GL11.glNormal3f((float)((float)Math.cos(angle)), (float)((float)Math.sin(angle)), (float)0.0f);
        }
        GL11.glVertex3f((float)(r1 * (float)Math.cos(0.0)), (float)(r1 * (float)Math.sin(0.0)), (float)(width * 0.5f));
        GL11.glVertex3f((float)(r1 * (float)Math.cos(0.0)), (float)(r1 * (float)Math.sin(0.0)), (float)(-width * 0.5f));
        GL11.glEnd();
        GL11.glShadeModel((int)7425);
        GL11.glBegin((int)8);
        for (i = 0; i <= teeth; ++i) {
            angle = (float)i * 2.0f * (float)Math.PI / (float)teeth;
            GL11.glNormal3f((float)(-((float)Math.cos(angle))), (float)(-((float)Math.sin(angle))), (float)0.0f);
            GL11.glVertex3f((float)(r0 * (float)Math.cos(angle)), (float)(r0 * (float)Math.sin(angle)), (float)(-width * 0.5f));
            GL11.glVertex3f((float)(r0 * (float)Math.cos(angle)), (float)(r0 * (float)Math.sin(angle)), (float)(width * 0.5f));
        }
        GL11.glEnd();
    }
}

