/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.guice;

import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.directwebremoting.extend.Configurator;
import org.directwebremoting.guice.DwrGuiceUtil;
import org.directwebremoting.guice.InitParam;
import org.directwebremoting.guice.InternalConfigurator;
import org.directwebremoting.guice.ParamName;
import org.directwebremoting.util.FakeServletConfig;

class InjectedConfig {
    @Inject(optional=true)
    @InitParam(value=ParamName.ALLOW_GET)
    Boolean allowGetButMakeForgeryEasier = null;
    @Inject(optional=true)
    @InitParam(value=ParamName.CROSS_DOMAIN_SESSION_SECURITY)
    Boolean crossDomainSessionSecurity = null;
    @Inject(optional=true)
    @InitParam(value=ParamName.ALLOW_SCRIPT_TAG_REMOTING)
    Boolean allowScriptTagRemoting = null;
    @Inject(optional=true)
    @InitParam(value=ParamName.DEBUG)
    Boolean debug = null;
    @Inject(optional=true)
    @InitParam(value=ParamName.SCRIPT_SESSION_TIMEOUT)
    Long scriptSessionTimeout = null;
    @Inject(optional=true)
    @InitParam(value=ParamName.MAX_CALL_COUNT)
    Integer maxCallCount = null;
    @Inject(optional=true)
    @InitParam(value=ParamName.ACTIVE_REVERSE_AJAX_ENABLED)
    Boolean activeReverseAjaxEnabled = null;
    @Inject(optional=true)
    @InitParam(value=ParamName.MAX_WAIT_AFTER_WRITE)
    Long maxWaitAfterWrite = null;
    @Inject(optional=true)
    @InitParam(value=ParamName.STREAMING_ENABLED)
    Boolean streamingEnabled = null;
    @Inject(optional=true)
    @InitParam(value=ParamName.DISCONNECTED_TIME)
    Long disconnectedTime = null;
    @Inject(optional=true)
    @InitParam(value=ParamName.POLL_AND_COMET_ENABLED)
    Boolean pollAndCometEnabled = null;
    @Inject(optional=true)
    @InitParam(value=ParamName.MAX_WAITING_THREADS)
    Integer maxWaitingThreads = null;
    @Inject(optional=true)
    @InitParam(value=ParamName.MAX_POLL_HITS_PER_SECOND)
    Integer maxPollHitsPerSecond = null;
    @Inject(optional=true)
    @InitParam(value=ParamName.PRE_STREAM_WAIT_TIME)
    Long preStreamWaitTime = null;
    @Inject(optional=true)
    @InitParam(value=ParamName.POST_STREAM_WAIT_TIME)
    Long postStreamWaitTime = null;
    @Inject(optional=true)
    @InitParam(value=ParamName.IGNORE_LAST_MODIFIED)
    Boolean ignoreLastModified = null;
    @Inject(optional=true)
    @InitParam(value=ParamName.WELCOME_FILES)
    String welcomeFiles = null;
    @Inject(optional=true)
    @InitParam(value=ParamName.NORMALIZE_INCLUDES_QUERY_STRING)
    Boolean normalizeIncludesQueryString = null;
    @Inject(optional=true)
    @InitParam(value=ParamName.OVERRIDE_PATH)
    String overridePath = null;
    @Inject(optional=true)
    Configurator configurator = null;
    private final FakeServletConfig config;

    InjectedConfig(FakeServletConfig config) {
        this.config = config;
    }

    void setParameter(ParamName paramName, Object value) {
        if (value != null) {
            this.config.setInitParameter(paramName.getName(), value.toString());
        }
    }

    void setClassesInitParameter() {
        HashSet classes = new HashSet();
        Injector injector = DwrGuiceUtil.getInjector();
        for (Key key : injector.getBindings().keySet()) {
            InitParam initParam;
            ParamName paramName;
            Class atype = key.getAnnotationType();
            if (atype == null || !InitParam.class.isAssignableFrom(atype) || (paramName = (initParam = (InitParam)InitParam.class.cast(key.getAnnotation())).value()) != ParamName.CLASSES) continue;
            List classList = (List)injector.getInstance(key);
            classes.addAll(classList);
        }
        this.config.setInitParameter(ParamName.CLASSES.getName(), InjectedConfig.classesToString(classes));
    }

    void setParameters() {
        this.setParameter(ParamName.ALLOW_GET, this.allowGetButMakeForgeryEasier);
        this.setParameter(ParamName.CROSS_DOMAIN_SESSION_SECURITY, this.crossDomainSessionSecurity);
        this.setParameter(ParamName.ALLOW_SCRIPT_TAG_REMOTING, this.allowScriptTagRemoting);
        this.setParameter(ParamName.DEBUG, this.debug);
        this.setParameter(ParamName.SCRIPT_SESSION_TIMEOUT, this.scriptSessionTimeout);
        this.setParameter(ParamName.MAX_CALL_COUNT, this.maxCallCount);
        this.setParameter(ParamName.ACTIVE_REVERSE_AJAX_ENABLED, this.activeReverseAjaxEnabled);
        this.setParameter(ParamName.MAX_WAIT_AFTER_WRITE, this.maxWaitAfterWrite);
        this.setParameter(ParamName.STREAMING_ENABLED, this.streamingEnabled);
        this.setParameter(ParamName.DISCONNECTED_TIME, this.disconnectedTime);
        this.setParameter(ParamName.POLL_AND_COMET_ENABLED, this.pollAndCometEnabled);
        this.setParameter(ParamName.MAX_WAITING_THREADS, this.maxWaitingThreads);
        this.setParameter(ParamName.MAX_POLL_HITS_PER_SECOND, this.maxPollHitsPerSecond);
        this.setParameter(ParamName.PRE_STREAM_WAIT_TIME, this.preStreamWaitTime);
        this.setParameter(ParamName.POST_STREAM_WAIT_TIME, this.postStreamWaitTime);
        this.setParameter(ParamName.IGNORE_LAST_MODIFIED, this.ignoreLastModified);
        this.setParameter(ParamName.WELCOME_FILES, this.welcomeFiles);
        this.setParameter(ParamName.NORMALIZE_INCLUDES_QUERY_STRING, this.normalizeIncludesQueryString);
        this.setParameter(ParamName.OVERRIDE_PATH, this.overridePath);
        if (this.configurator != null) {
            this.config.setInitParameter("customConfigurator", InternalConfigurator.class.getName());
        }
        this.setClassesInitParameter();
    }

    private static String classesToString(Collection<Class<?>> classes) {
        StringBuilder buf = new StringBuilder();
        int count = 0;
        for (Class<?> cls : classes) {
            if (count++ > 0) {
                buf.append(", ");
            }
            buf.append(cls.getName());
        }
        return buf.toString();
    }
}

