/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.library.unit;

import java.math.BigInteger;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import javax.measure.quantity.Area;
import javax.measure.quantity.Length;
import javax.measure.quantity.Mass;
import javax.measure.quantity.Pressure;
import javax.measure.quantity.Speed;
import javax.measure.quantity.Temperature;
import javax.measure.quantity.Volume;
import javax.measure.spi.SystemOfUnits;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.openhab.core.library.dimension.Density;
import org.openhab.core.library.dimension.VolumetricFlowRate;
import org.openhab.core.library.unit.CustomUnits;
import tech.units.indriya.format.SimpleUnitFormat;
import tech.units.indriya.function.AddConverter;
import tech.units.indriya.function.MultiplyConverter;
import tech.units.indriya.unit.ProductUnit;
import tech.units.indriya.unit.TransformedUnit;
import tech.units.indriya.unit.Units;

@NonNullByDefault
public final class ImperialUnits
extends CustomUnits {
    public static final String MEASUREMENT_SYSTEM_NAME = "US";
    private static final ImperialUnits INSTANCE = new ImperialUnits();
    public static final Unit<Mass> POUND = ImperialUnits.addUnit(new TransformedUnit("lb", Units.GRAM, (UnitConverter)MultiplyConverter.ofRational((BigInteger)BigInteger.valueOf(45359237L), (BigInteger)BigInteger.valueOf(100000L))));
    public static final Unit<Mass> GRAIN = ImperialUnits.addUnit(new TransformedUnit("gr", Units.GRAM, (UnitConverter)MultiplyConverter.of((double)0.06479891)));
    public static final Unit<Pressure> INCH_OF_MERCURY = ImperialUnits.addUnit(new TransformedUnit("inHg", Units.PASCAL, (UnitConverter)MultiplyConverter.ofRational((BigInteger)BigInteger.valueOf(3386388L), (BigInteger)BigInteger.valueOf(1000L))));
    public static final Unit<Pressure> POUND_FORCE_SQUARE_INCH = ImperialUnits.addUnit(new TransformedUnit("psi", Units.PASCAL, (UnitConverter)MultiplyConverter.ofRational((BigInteger)BigInteger.valueOf(6894757L), (BigInteger)BigInteger.valueOf(1000L))));
    public static final Unit<Temperature> FAHRENHEIT = ImperialUnits.addUnit(new TransformedUnit("\u00b0F", Units.KELVIN, MultiplyConverter.ofRational((BigInteger)BigInteger.valueOf(5L), (BigInteger)BigInteger.valueOf(9L)).concatenate((UnitConverter)new AddConverter((Number)459.67))));
    public static final Unit<Speed> MILES_PER_HOUR = ImperialUnits.addUnit(new TransformedUnit("mph", Units.KILOMETRE_PER_HOUR, (UnitConverter)MultiplyConverter.ofRational((BigInteger)BigInteger.valueOf(1609344L), (BigInteger)BigInteger.valueOf(1000000L))));
    public static final Unit<Length> INCH = ImperialUnits.addUnit(new TransformedUnit("in", Units.METRE, (UnitConverter)MultiplyConverter.ofRational((BigInteger)BigInteger.valueOf(254L), (BigInteger)BigInteger.valueOf(10000L))));
    public static final Unit<Length> FOOT = ImperialUnits.addUnit(new TransformedUnit("ft", INCH, (UnitConverter)MultiplyConverter.of((double)12.0)));
    public static final Unit<Length> YARD = ImperialUnits.addUnit(new TransformedUnit("yd", FOOT, (UnitConverter)MultiplyConverter.of((double)3.0)));
    public static final Unit<Length> CHAIN = ImperialUnits.addUnit(new TransformedUnit("ch", YARD, (UnitConverter)MultiplyConverter.of((double)22.0)));
    public static final Unit<Length> FURLONG = ImperialUnits.addUnit(new TransformedUnit("fur", CHAIN, (UnitConverter)MultiplyConverter.of((double)10.0)));
    public static final Unit<Length> MILE = ImperialUnits.addUnit(new TransformedUnit("mi", FURLONG, (UnitConverter)MultiplyConverter.of((double)8.0)));
    public static final Unit<Length> LEAGUE = ImperialUnits.addUnit(new TransformedUnit("lea", MILE, (UnitConverter)MultiplyConverter.of((double)3.0)));
    public static final Unit<Area> SQUARE_INCH = ImperialUnits.addUnit(new ProductUnit(INCH.multiply(INCH)));
    public static final Unit<Area> SQUARE_FOOT = ImperialUnits.addUnit(new ProductUnit(FOOT.multiply(FOOT)));
    public static final Unit<Volume> CUBIC_INCH = ImperialUnits.addUnit(new ProductUnit(SQUARE_INCH.multiply(INCH)));
    public static final Unit<Volume> CUBIC_FOOT = ImperialUnits.addUnit(new ProductUnit(SQUARE_FOOT.multiply(FOOT)));
    public static final Unit<Volume> GALLON_LIQUID_US = ImperialUnits.addUnit(new TransformedUnit("gal", CUBIC_INCH, (UnitConverter)MultiplyConverter.of((double)231.0)));
    public static final Unit<VolumetricFlowRate> GALLON_PER_MINUTE = ImperialUnits.addUnit(new ProductUnit(GALLON_LIQUID_US.divide(Units.MINUTE)));
    public static final Unit<Density> GRAIN_PER_CUBICFOOT = ImperialUnits.addUnit(new ProductUnit(GRAIN.divide(CUBIC_FOOT)));

    static {
        SimpleUnitFormat.getInstance().label(INCH_OF_MERCURY, INCH_OF_MERCURY.getSymbol());
        SimpleUnitFormat.getInstance().label(FAHRENHEIT, FAHRENHEIT.getSymbol());
        SimpleUnitFormat.getInstance().label(MILES_PER_HOUR, MILES_PER_HOUR.getSymbol());
        SimpleUnitFormat.getInstance().label(INCH, INCH.getSymbol());
        SimpleUnitFormat.getInstance().label(FOOT, FOOT.getSymbol());
        SimpleUnitFormat.getInstance().label(YARD, YARD.getSymbol());
        SimpleUnitFormat.getInstance().label(CHAIN, CHAIN.getSymbol());
        SimpleUnitFormat.getInstance().label(FURLONG, FURLONG.getSymbol());
        SimpleUnitFormat.getInstance().label(MILE, MILE.getSymbol());
        SimpleUnitFormat.getInstance().label(LEAGUE, LEAGUE.getSymbol());
        SimpleUnitFormat.getInstance().label(GALLON_LIQUID_US, GALLON_LIQUID_US.getSymbol());
        SimpleUnitFormat.getInstance().label(GALLON_PER_MINUTE, "gal/min");
        SimpleUnitFormat.getInstance().label(POUND_FORCE_SQUARE_INCH, POUND_FORCE_SQUARE_INCH.getSymbol());
        SimpleUnitFormat.getInstance().label(GRAIN, GRAIN.getSymbol());
    }

    private ImperialUnits() {
    }

    public static SystemOfUnits getInstance() {
        return INSTANCE;
    }

    private static <U extends Unit<?>> U addUnit(U unit) {
        ImperialUnits.INSTANCE.units.add(unit);
        return unit;
    }

    @Override
    public String getName() {
        return MEASUREMENT_SYSTEM_NAME;
    }
}

