/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.charts.fill;

import net.sf.jasperreports.charts.JRXyzDataset;
import net.sf.jasperreports.charts.JRXyzSeries;
import net.sf.jasperreports.charts.fill.JRFillXyzSeries;
import net.sf.jasperreports.charts.util.DefaultXYZDataset;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.fill.JRCalculator;
import net.sf.jasperreports.engine.fill.JRExpressionEvalException;
import net.sf.jasperreports.engine.fill.JRFillChartDataset;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import org.jfree.data.general.Dataset;

public class JRFillXyzDataset
extends JRFillChartDataset
implements JRXyzDataset {
    protected JRFillXyzSeries[] xyzSeries = null;
    private DefaultXYZDataset dataset = null;

    public JRFillXyzDataset(JRXyzDataset xyzDataset, JRFillObjectFactory factory) {
        super(xyzDataset, factory);
        JRXyzSeries[] srcXyzSeries = xyzDataset.getSeries();
        if (srcXyzSeries != null && srcXyzSeries.length > 0) {
            this.xyzSeries = new JRFillXyzSeries[srcXyzSeries.length];
            for (int i = 0; i < this.xyzSeries.length; ++i) {
                this.xyzSeries[i] = (JRFillXyzSeries)factory.getXyzSeries(srcXyzSeries[i]);
            }
        }
    }

    public JRXyzSeries[] getSeries() {
        return this.xyzSeries;
    }

    protected void customInitialize() {
        this.dataset = new DefaultXYZDataset();
    }

    protected void customEvaluate(JRCalculator calculator) throws JRExpressionEvalException {
        if (this.xyzSeries != null && this.xyzSeries.length > 0) {
            for (int i = 0; i < this.xyzSeries.length; ++i) {
                this.xyzSeries[i].evaluate(calculator);
            }
        }
    }

    protected void customIncrement() {
        if (this.xyzSeries != null && this.xyzSeries.length > 0) {
            for (int i = 0; i < this.xyzSeries.length; ++i) {
                JRFillXyzSeries crtXyzSeries = this.xyzSeries[i];
                this.dataset.addValue(crtXyzSeries.getSeries(), crtXyzSeries.getXValue(), crtXyzSeries.getYValue(), crtXyzSeries.getZValue());
            }
        }
    }

    public Dataset getCustomDataset() {
        return this.dataset;
    }

    public byte getDatasetType() {
        return 4;
    }

    public void collectExpressions(JRExpressionCollector collector) {
        collector.collect(this);
    }
}

