/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpd;

import java.io.File;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import net.sf.mpxj.MPXJException;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.listener.ProjectListener;
import net.sf.mpxj.mpd.MPD9DatabaseReader;
import net.sf.mpxj.reader.ProjectReader;

public final class MPDDatabaseReader
implements ProjectReader {
    private Integer m_projectID;
    private DataSource m_dataSource;
    private Connection m_connection;
    private boolean m_preserveNoteFormatting;
    private List<ProjectListener> m_projectListeners;

    @Override
    public void addProjectListener(ProjectListener projectListener) {
        if (this.m_projectListeners == null) {
            this.m_projectListeners = new LinkedList<ProjectListener>();
        }
        this.m_projectListeners.add(projectListener);
    }

    public Map<Integer, String> listProjects() throws MPXJException {
        MPD9DatabaseReader mPD9DatabaseReader = new MPD9DatabaseReader();
        return mPD9DatabaseReader.listProjects();
    }

    public ProjectFile read() throws MPXJException {
        MPD9DatabaseReader mPD9DatabaseReader = new MPD9DatabaseReader();
        mPD9DatabaseReader.setProjectID(this.m_projectID);
        mPD9DatabaseReader.setPreserveNoteFormatting(this.m_preserveNoteFormatting);
        mPD9DatabaseReader.setDataSource(this.m_dataSource);
        mPD9DatabaseReader.setConnection(this.m_connection);
        ProjectFile projectFile = mPD9DatabaseReader.read();
        return projectFile;
    }

    public void setProjectID(int n) {
        this.m_projectID = n;
    }

    public void setPreserveNoteFormatting(boolean bl) {
        this.m_preserveNoteFormatting = bl;
    }

    public void setDataSource(DataSource dataSource) {
        this.m_dataSource = dataSource;
    }

    public void setConnection(Connection connection) {
        this.m_connection = connection;
    }

    @Override
    public ProjectFile read(String string) throws MPXJException {
        try {
            Class.forName("sun.jdbc.odbc.JdbcOdbcDriver");
            String string2 = "jdbc:odbc:DRIVER=Microsoft Access Driver (*.mdb);DBQ=" + string;
            this.m_connection = DriverManager.getConnection(string2);
            this.m_projectID = 1;
            ProjectFile projectFile = this.read();
            return projectFile;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new MPXJException("Failed to load JDBC driver", classNotFoundException);
        }
        catch (SQLException sQLException) {
            throw new MPXJException("Failed to create connection", sQLException);
        }
        finally {
            if (this.m_connection != null) {
                try {
                    this.m_connection.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    @Override
    public ProjectFile read(File file) throws MPXJException {
        return this.read(file.getAbsolutePath());
    }

    @Override
    public ProjectFile read(InputStream inputStream) {
        throw new UnsupportedOperationException();
    }
}

