/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageChecker.toolwindow.tree.nodes;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.project.Project;
import com.intellij.packageChecker.DependencySourceService;
import com.intellij.packageChecker.PackageUtilKt;
import com.intellij.packageChecker.model.Dependency;
import com.intellij.packageChecker.service.Checked;
import com.intellij.packageChecker.service.Malicious;
import com.intellij.packageChecker.service.PackageChecker;
import com.intellij.packageChecker.service.PackageStatus;
import com.intellij.packageChecker.service.Safe;
import com.intellij.packageChecker.service.Unchecked;
import com.intellij.packageChecker.service.Vulnerable;
import com.intellij.packageChecker.toolwindow.tree.nodes.DependencyNodeKt;
import com.intellij.packageChecker.toolwindow.tree.nodes.State;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.treeStructure.SimpleNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineName;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.security.package.Package;
import org.jetbrains.security.problems.vulnerabilities.Severity;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B'\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0001\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0004\u001a\u00020\u0005J\u0006\u0010\u0018\u001a\u00020\u0019J\u0010\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001cH\u0014J\u0013\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00010\u001eH\u0016\u00a2\u0006\u0002\u0010\u001fJ\u0012\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020\u0017H\u0002J\u0006\u0010%\u001a\u00020\u0019J\u001a\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020(0*R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/intellij/packageChecker/toolwindow/tree/nodes/DependencyNode;", "Lcom/intellij/ui/treeStructure/SimpleNode;", "Lkotlinx/coroutines/CoroutineScope;", "Lcom/intellij/openapi/actionSystem/DataProvider;", "project", "Lcom/intellij/openapi/project/Project;", "parentNode", "dependency", "Lcom/intellij/packageChecker/model/Dependency;", "parentCoroutineContext", "Lkotlin/coroutines/CoroutineContext;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/ui/treeStructure/SimpleNode;Lcom/intellij/packageChecker/model/Dependency;Lkotlin/coroutines/CoroutineContext;)V", "getDependency", "()Lcom/intellij/packageChecker/model/Dependency;", "timeThresholdForStateUpdate", "Ljava/util/concurrent/atomic/AtomicLong;", "coroutineContext", "getCoroutineContext", "()Lkotlin/coroutines/CoroutineContext;", "state", "Lcom/intellij/packageChecker/toolwindow/tree/nodes/State;", "updateState", "", "isUpdating", "", "update", "presentation", "Lcom/intellij/ide/projectView/PresentationData;", "getChildren", "", "()[Lcom/intellij/ui/treeStructure/SimpleNode;", "getData", "", "dataId", "", "vulnerableChild", "hasVulnerability", "distinctVulnerablePackages", "", "Lorg/jetbrains/security/package/Package;", "vulnerablePackages", "", "intellij.packageChecker"})
@SourceDebugExtension(value={"SMAP\nDependencyNode.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DependencyNode.kt\ncom/intellij/packageChecker/toolwindow/tree/nodes/DependencyNode\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,166:1\n11483#2,9:167\n13409#2:176\n13410#2:178\n11492#2:179\n13409#2,2:200\n1#3:177\n1971#4,14:180\n1557#4:194\n1628#4,3:195\n37#5,2:198\n*S KotlinDebug\n*F\n+ 1 DependencyNode.kt\ncom/intellij/packageChecker/toolwindow/tree/nodes/DependencyNode\n*L\n77#1:167,9\n77#1:176\n77#1:178\n77#1:179\n149#1:200,2\n77#1:177\n79#1:180,14\n109#1:194\n109#1:195,3\n112#1:198,2\n*E\n"})
public final class DependencyNode
extends SimpleNode
implements CoroutineScope,
DataProvider {
    @NotNull
    private final Dependency dependency;
    @NotNull
    private final AtomicLong timeThresholdForStateUpdate;
    @NotNull
    private final CoroutineContext coroutineContext;
    @NotNull
    private State state;

    public DependencyNode(@NotNull Project project, @NotNull SimpleNode parentNode, @NotNull Dependency dependency, @NotNull CoroutineContext parentCoroutineContext) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)parentNode, (String)"parentNode");
        Intrinsics.checkNotNullParameter((Object)dependency, (String)"dependency");
        Intrinsics.checkNotNullParameter((Object)parentCoroutineContext, (String)"parentCoroutineContext");
        super(project, (NodeDescriptor)parentNode);
        this.dependency = dependency;
        this.timeThresholdForStateUpdate = new AtomicLong(0L);
        this.coroutineContext = parentCoroutineContext.plus((CoroutineContext)new CoroutineName("PackageChecker.Toolwindow.DependencyNode"));
        this.state = new State(false, false, new Unchecked(this.dependency.getPkg()), null);
        this.updateState(project);
    }

    @NotNull
    public final Dependency getDependency() {
        return this.dependency;
    }

    @NotNull
    public CoroutineContext getCoroutineContext() {
        return this.coroutineContext;
    }

    /*
     * WARNING - void declaration
     */
    public final void updateState(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.timeThresholdForStateUpdate.compareAndSet(0L, new Date().getTime() + DependencyNodeKt.access$getRefreshTimeInMs$p());
        PackageStatus packageStatus = PackageChecker.Companion.getInstance(project).packageStatus(this.dependency.getPkg());
        State state = this.state;
        boolean hasVulnerability = state.component1();
        boolean hasTransitive = state.component2();
        Severity severity = state.component4();
        if (packageStatus instanceof Checked) {
            Checked checked = (Checked)packageStatus;
            if (checked instanceof Vulnerable) {
                severity = (Severity)ComparisonsKt.maxOf((Object)severity, (Object)((Vulnerable)packageStatus).getMaxSeverity(), (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        Severity it = (Severity)a;
                        boolean bl = false;
                        Severity severity = it;
                        it = (Severity)b;
                        Comparable comparable = severity != null ? Float.valueOf(severity.getScore()) : null;
                        bl = false;
                        Severity severity2 = it;
                        return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)(severity2 != null ? Float.valueOf(severity2.getScore()) : null));
                    }
                });
                hasVulnerability = true;
                SimpleNode simpleNode = this.getParent();
                DependencyNode dependencyNode = simpleNode instanceof DependencyNode ? (DependencyNode)simpleNode : null;
                if (dependencyNode != null) {
                    dependencyNode.vulnerableChild();
                }
            } else if (checked instanceof Malicious) {
                severity = ((Malicious)packageStatus).getMaxSeverity();
                hasVulnerability = true;
            } else if (checked instanceof Safe) {
                Severity severity2;
                Object v2;
                void $this$maxByOrNull$iv;
                void $this$mapNotNullTo$iv$iv;
                hasVulnerability = false;
                Object $this$mapNotNull$iv = this.getChildren();
                boolean $i$f$mapNotNull = false;
                SimpleNode[] simpleNodeArray = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                int n = ((void)$this$forEach$iv$iv$iv).length;
                for (int i = 0; i < n; ++i) {
                    Severity it$iv$iv;
                    void element$iv$iv$iv;
                    void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
                    boolean bl = false;
                    void it = element$iv$iv;
                    boolean bl2 = false;
                    Object object = it instanceof DependencyNode ? (DependencyNode)it : null;
                    if ((object != null && (object = object.state) != null ? ((State)object).getMaxSeverity() : null) == null) continue;
                    it$iv$iv = it$iv$iv;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                $this$mapNotNull$iv = (List)destination$iv$iv;
                boolean $i$f$maxByOrNull = false;
                Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
                if (!iterator$iv.hasNext()) {
                    v2 = null;
                } else {
                    Object maxElem$iv = iterator$iv.next();
                    if (!iterator$iv.hasNext()) {
                        v2 = maxElem$iv;
                    } else {
                        Severity it = (Severity)maxElem$iv;
                        boolean bl = false;
                        float maxValue$iv = it.getScore();
                        do {
                            Object e$iv = iterator$iv.next();
                            Severity it2 = (Severity)e$iv;
                            $i$a$-maxByOrNull-DependencyNode$updateState$3 = false;
                            float v$iv = it2.getScore();
                            if (Float.compare(maxValue$iv, v$iv) >= 0) continue;
                            maxElem$iv = e$iv;
                            maxValue$iv = v$iv;
                        } while (iterator$iv.hasNext());
                        v2 = maxElem$iv;
                    }
                }
                if ((severity2 = (Severity)v2) == null) {
                    severity2 = DependencyNodeKt.access$getDefaultSeverity$p();
                }
                severity = severity2;
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        this.state = new State(hasVulnerability, hasTransitive, packageStatus, severity);
        if (!this.state.isNotSet() || new Date().getTime() > this.timeThresholdForStateUpdate.get()) {
            this.timeThresholdForStateUpdate.set(0L);
        } else {
            BuildersKt.launch$default((CoroutineScope)this, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, project, null){
                int label;
                final /* synthetic */ DependencyNode this$0;
                final /* synthetic */ Project $project;
                {
                    this.this$0 = $receiver;
                    this.$project = $project;
                    super(2, $completion);
                }

                public final Object invokeSuspend(Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            this.this$0.updateState(this.$project);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }
    }

    public final boolean isUpdating() {
        return this.timeThresholdForStateUpdate.get() > 0L;
    }

    protected void update(@NotNull PresentationData presentation) {
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        String humanReadableCoordinates = this.dependency.getPkg().getHumanReadableCoordinates();
        presentation.addText(humanReadableCoordinates, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        Icon icon = PackageUtilKt.dependencyNodeIcon(this.state);
        presentation.setIcon(icon);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public SimpleNode[] getChildren() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.dependency.getChildren();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Dependency dependency = (Dependency)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Project project = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            DependencyNode dependencyNode = new DependencyNode(project, this, (Dependency)it, this.getCoroutineContext());
            collection.add(dependencyNode);
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new SimpleNode[0]);
    }

    @Nullable
    public Object getData(@NotNull String dataId) {
        Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
        if (CommonDataKeys.NAVIGATABLE.is(dataId)) {
            Project project = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            return DependencySourceService.Companion.getInstance(project).getOrCreateDependencySource(dataId, this.dependency);
        }
        return null;
    }

    private final void vulnerableChild() {
        State state = this.state;
        boolean hasVulnerability = state.component1();
        boolean hasTransitiveVulnerability = state.component2();
        PackageStatus packageStatus = state.component3();
        Severity maxSeverity = state.component4();
        if (hasVulnerability || hasTransitiveVulnerability) {
            return;
        }
        SimpleNode simpleNode = this.getParent();
        DependencyNode dependencyNode = simpleNode instanceof DependencyNode ? (DependencyNode)simpleNode : null;
        if (dependencyNode != null) {
            dependencyNode.vulnerableChild();
        }
        this.state = new State(false, true, packageStatus, maxSeverity);
    }

    public final boolean hasVulnerability() {
        return this.state.getHasVulnerability() || this.state.getHasTransitiveVulnerability();
    }

    @NotNull
    public final Set<Package> distinctVulnerablePackages(@NotNull Set<Package> vulnerablePackages) {
        Intrinsics.checkNotNullParameter(vulnerablePackages, (String)"vulnerablePackages");
        if (this.state.getHasVulnerability()) {
            vulnerablePackages.add(this.dependency.getPkg());
        }
        SimpleNode[] $this$forEach$iv = this.getChildren();
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            DependencyNode it;
            SimpleNode element$iv;
            SimpleNode it2 = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            if ((it2 instanceof DependencyNode ? (DependencyNode)it2 : null) == null) continue;
            it = it;
            boolean bl2 = false;
            vulnerablePackages.addAll((Collection<Package>)it.distinctVulnerablePackages(vulnerablePackages));
        }
        return vulnerablePackages;
    }
}

