/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.startup.importSettings.transfer.backend.providers.vscode.parsers;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.intellij.ide.RecentProjectMetaInfo;
import com.intellij.ide.startup.importSettings.db.KnownLafs;
import com.intellij.ide.startup.importSettings.models.BundledLookAndFeel;
import com.intellij.ide.startup.importSettings.models.RecentPathInfo;
import com.intellij.ide.startup.importSettings.models.Settings;
import com.intellij.ide.startup.importSettings.providers.vscode.mappings.ThemesMappings;
import com.intellij.ide.startup.importSettings.transfer.ExternalProjectImportChecker;
import com.intellij.ide.startup.importSettings.transfer.backend.db.KnownColorSchemes;
import com.intellij.ide.startup.importSettings.transfer.backend.providers.vscode.parsers.JsonKt;
import com.intellij.ide.startup.importSettings.transfer.backend.providers.vscode.parsers.StorageParserKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.LoggerKt;
import com.intellij.openapi.util.SystemInfo;
import java.io.File;
import java.net.URI;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/ide/startup/importSettings/transfer/backend/providers/vscode/parsers/StorageParser;", "", "settings", "Lcom/intellij/ide/startup/importSettings/models/Settings;", "<init>", "(Lcom/intellij/ide/startup/importSettings/models/Settings;)V", "process", "", "file", "Ljava/io/File;", "processRecentProjects", "root", "Lcom/fasterxml/jackson/databind/node/ObjectNode;", "processThemeAndScheme", "Companion", "intellij.ide.startup.importSettings"})
@SourceDebugExtension(value={"SMAP\nStorageParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StorageParser.kt\ncom/intellij/ide/startup/importSettings/transfer/backend/providers/vscode/parsers/StorageParser\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,140:1\n1368#2:141\n1454#2,5:142\n1611#2,9:147\n1863#2:156\n1864#2:158\n1620#2:159\n1611#2,9:160\n1863#2,2:169\n1620#2:171\n1611#2,9:172\n1863#2:181\n1864#2:183\n1620#2:184\n1#3:157\n1#3:182\n83#4,3:185\n*S KotlinDebug\n*F\n+ 1 StorageParser.kt\ncom/intellij/ide/startup/importSettings/transfer/backend/providers/vscode/parsers/StorageParser\n*L\n94#1:141\n94#1:142,5\n96#1:147,9\n96#1:156\n96#1:158\n96#1:159\n96#1:160,9\n96#1:169,2\n96#1:171\n102#1:172,9\n102#1:181\n102#1:183\n102#1:184\n96#1:157\n102#1:182\n110#1:185,3\n*E\n"})
public final class StorageParser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Settings settings;
    @NotNull
    private static final String OPENED_PATHS = "openedPathsList";
    @NotNull
    private static final String THEME = "theme";

    public StorageParser(@NotNull Settings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        this.settings = settings;
    }

    public final void process(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        try {
            StorageParserKt.access$getLogger$p().info("Processing a storage file: " + file);
            JsonNode jsonNode = JsonKt.getVsCodeJsonMapper().readTree(file);
            ObjectNode objectNode = jsonNode instanceof ObjectNode ? (ObjectNode)jsonNode : null;
            if (objectNode == null) {
                throw new IllegalStateException(("Unexpected JSON data; expected: " + JsonNodeType.OBJECT).toString());
            }
            ObjectNode root = objectNode;
            this.processRecentProjects(root);
            this.processThemeAndScheme(root);
        }
        catch (Throwable t) {
            StorageParserKt.access$getLogger$p().warn(t);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void processRecentProjects(ObjectNode root) {
        try {
            Iterable iterable;
            Logger logger;
            Iterable $this$mapNotNull$iv;
            Iterable $this$mapNotNull$iv2;
            void $this$flatMapTo$iv$iv;
            JsonNode jsonNode = root.get(OPENED_PATHS);
            ObjectNode objectNode = jsonNode instanceof ObjectNode ? (ObjectNode)jsonNode : null;
            if (objectNode == null) {
                return;
            }
            ObjectNode openedPaths = objectNode;
            Iterable $this$flatMap$iv = CollectionsKt.toList((Iterable)((Iterable)openedPaths));
            boolean $i$f$flatMap = false;
            Iterable iterable2 = $this$flatMap$iv;
            Iterable destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                JsonNode it = (JsonNode)element$iv$iv;
                boolean bl3 = false;
                Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type com.fasterxml.jackson.databind.node.ArrayNode");
                Iterable list$iv$iv = CollectionsKt.toList((Iterable)((Iterable)((ArrayNode)it)));
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            List flatList = (List)destination$iv$iv;
            try {
                Object it$iv$iv;
                boolean bl;
                JsonNode it;
                boolean bl2;
                Object element$iv$iv;
                Object element$iv$iv$iv;
                Iterable $this$mapNotNullTo$iv$iv;
                $this$mapNotNull$iv2 = flatList;
                boolean $i$f$mapNotNull = false;
                destination$iv$iv = $this$mapNotNull$iv2;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                Iterable $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator bl3 = $this$forEach$iv$iv$iv.iterator();
                while (bl3.hasNext()) {
                    element$iv$iv = element$iv$iv$iv = bl3.next();
                    bl2 = false;
                    it = (JsonNode)element$iv$iv;
                    boolean bl4 = false;
                    if (it.get("folderUri") == null) continue;
                    bl = false;
                    destination$iv$iv2.add(it$iv$iv);
                }
                $this$mapNotNull$iv2 = (List)destination$iv$iv2;
                $i$f$mapNotNull = false;
                $this$mapNotNullTo$iv$iv = $this$mapNotNull$iv2;
                destination$iv$iv2 = new ArrayList();
                $i$f$mapNotNullTo = false;
                $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                $i$f$forEach = false;
                bl3 = $this$forEach$iv$iv$iv.iterator();
                while (bl3.hasNext()) {
                    element$iv$iv = element$iv$iv$iv = bl3.next();
                    bl2 = false;
                    it = (JsonNode)element$iv$iv;
                    boolean bl5 = false;
                    if (it.textValue() == null) continue;
                    bl = false;
                    destination$iv$iv2.add(it$iv$iv);
                }
                $this$mapNotNull$iv2 = (List)destination$iv$iv2;
            }
            catch (Throwable t) {
                $this$mapNotNull$iv2 = null;
            }
            Iterable workspacesNew = $this$mapNotNull$iv2;
            try {
                void $this$mapNotNullTo$iv$iv;
                $this$mapNotNull$iv = flatList;
                boolean $i$f$mapNotNull = false;
                Iterable destination$iv$iv3 = $this$mapNotNull$iv;
                Collection destination$iv$iv4 = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                logger = $this$forEach$iv$iv$iv.iterator();
                while (logger.hasNext()) {
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = logger.next();
                    boolean bl = false;
                    JsonNode it = (JsonNode)element$iv$iv;
                    boolean bl6 = false;
                    String string = it.textValue();
                    if (string == null) {
                        string = null;
                    }
                    if (string == null) continue;
                    String it$iv$iv = string;
                    boolean bl7 = false;
                    destination$iv$iv4.add(it$iv$iv);
                }
                $this$mapNotNull$iv = (List)destination$iv$iv4;
            }
            catch (Throwable t) {
                $this$mapNotNull$iv = null;
            }
            Iterable workspacesOld = $this$mapNotNull$iv;
            Collection collection = (Collection)workspacesNew;
            if (!(collection == null || collection.isEmpty())) {
                iterable = workspacesNew;
            } else {
                iterable = workspacesOld;
                if (iterable == null) {
                    return;
                }
            }
            Iterable workspaces = iterable;
            for (String uri : workspaces) {
                Object object;
                Logger $this$runAndLogException$iv = StorageParserKt.access$getLogger$p();
                boolean $i$f$runAndLogException = false;
                logger = $this$runAndLogException$iv;
                try {
                    Logger $this$runAndLogException_u24lambda_u240$iv = logger;
                    boolean bl = false;
                    boolean bl8 = false;
                    object = Result.constructor-impl((Object)(!this.settings.addRecentProjectIfNeeded((Function0<RecentPathInfo>)((Function0)() -> StorageParser.processRecentProjects$lambda$5$lambda$4(uri))) ? 1 : 0));
                }
                catch (Throwable throwable) {
                    object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                }
                Boolean bl = (Boolean)LoggerKt.getOrLogException((Object)object, (Logger)$this$runAndLogException$iv);
                boolean shouldBreak = bl != null ? bl : false;
                if (!shouldBreak) continue;
                break;
            }
        }
        catch (Throwable t) {
            StorageParserKt.access$getLogger$p().warn(t);
        }
    }

    private final void processThemeAndScheme(ObjectNode root) {
        try {
            Object object = root.get(THEME);
            if (object == null || (object = object.textValue()) == null) {
                return;
            }
            Object theme = object;
            BundledLookAndFeel laf = ThemesMappings.INSTANCE.themeMap((String)theme);
            this.settings.setLaf(laf);
            this.settings.setSyntaxScheme(Intrinsics.areEqual((Object)laf, (Object)KnownLafs.INSTANCE.getLight()) ? KnownColorSchemes.INSTANCE.getLight() : KnownColorSchemes.INSTANCE.getDarcula());
        }
        catch (Throwable t) {
            StorageParserKt.access$getLogger$p().warn(t);
        }
    }

    private static final RecentPathInfo processRecentProjects$lambda$5$lambda$4(String $uri) {
        return Companion.parsePath$intellij_ide_startup_importSettings(new URI($uri));
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b\u000bJ\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/ide/startup/importSettings/transfer/backend/providers/vscode/parsers/StorageParser$Companion;", "", "<init>", "()V", "OPENED_PATHS", "", "THEME", "parsePath", "Lcom/intellij/ide/startup/importSettings/models/RecentPathInfo;", "uri", "Ljava/net/URI;", "parsePath$intellij_ide_startup_importSettings", "workaroundWindowsIssue", "input", "intellij.ide.startup.importSettings"})
    @SourceDebugExtension(value={"SMAP\nStorageParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StorageParser.kt\ncom/intellij/ide/startup/importSettings/transfer/backend/providers/vscode/parsers/StorageParser$Companion\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,140:1\n13996#2,14:141\n83#3,3:155\n*S KotlinDebug\n*F\n+ 1 StorageParser.kt\ncom/intellij/ide/startup/importSettings/transfer/backend/providers/vscode/parsers/StorageParser$Companion\n*L\n44#1:141,14\n53#1:155,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * Unable to fully structure code
         */
        @Nullable
        public final RecentPathInfo parsePath$intellij_ide_startup_importSettings(@NotNull URI uri) {
            Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
            var4_2 = uri.getScheme();
            if (Intrinsics.areEqual((Object)var4_2, (Object)"file")) {
                v0 = Path.of(uri);
            } else if (Intrinsics.areEqual((Object)var4_2, (Object)"vscode-remote")) {
                v1 = uri.getSchemeSpecificPart();
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getSchemeSpecificPart(...)");
                v0 = com.intellij.ide.startup.importSettings.transfer.backend.providers.vscode.parsers.StorageParser$Companion.parsePath$fromWslPath(v1);
            } else {
                StorageParserKt.access$getLogger$p().warn("Unknown scheme: " + uri.getScheme());
                v0 = null;
            }
            if (v0 == null) {
                return null;
            }
            path = v0;
            v2 = path.toFile().listFiles();
            if (v2 == null) ** GOTO lbl-1000
            $this$maxByOrNull$iv = v2;
            $i$f$maxByOrNull = false;
            if ($this$maxByOrNull$iv.length == 0) {
                v3 = null;
            } else {
                maxElem$iv = $this$maxByOrNull$iv[0];
                lastIndex$iv = ArraysKt.getLastIndex((Object[])$this$maxByOrNull$iv);
                if (lastIndex$iv == 0) {
                    v3 = maxElem$iv;
                } else {
                    it = maxElem$iv;
                    $i$a$-maxByOrNull-StorageParser$Companion$parsePath$modifiedTime$1 = false;
                    maxValue$iv = it.lastModified();
                    i$iv = 1;
                    if (i$iv <= lastIndex$iv) {
                        while (true) {
                            it = e$iv = $this$maxByOrNull$iv[i$iv];
                            $i$a$-maxByOrNull-StorageParser$Companion$parsePath$modifiedTime$1 = false;
                            v$iv = it.lastModified();
                            if (maxValue$iv < v$iv) {
                                maxElem$iv = e$iv;
                                maxValue$iv = v$iv;
                            }
                            if (i$iv == lastIndex$iv) break;
                            ++i$iv;
                        }
                    }
                    v3 = v2 = maxElem$iv;
                }
            }
            if (v3 != null) {
                v4 = v2.lastModified();
            } else lbl-1000:
            // 2 sources

            {
                v4 = null;
            }
            modifiedTime = v4;
            var5_22 = new RecentProjectMetaInfo();
            $this$parsePath_u24lambda_u241 = var5_22;
            $i$a$-apply-StorageParser$Companion$parsePath$info$1 = false;
            v5 = modifiedTime;
            $this$parsePath_u24lambda_u241.setProjectOpenTimestamp(v5 != null ? v5 : 0L);
            $this$parsePath_u24lambda_u241.setBuildTimestamp($this$parsePath_u24lambda_u241.getProjectOpenTimestamp());
            v6 = path.getFileName();
            if (v6 == null || (v6 = v6.toString()) == null) {
                v6 = path.toString();
            }
            $this$parsePath_u24lambda_u241.setDisplayName((String)v6);
            info = var5_22;
            for (ExternalProjectImportChecker checker : ExternalProjectImportChecker.Companion.getEP_NAME().getExtensionList()) {
                $this$runAndLogException$iv = StorageParserKt.access$getLogger$p();
                $i$f$runAndLogException = false;
                var10_11 = $this$runAndLogException$iv;
                try {
                    $this$runAndLogException_u24lambda_u240$iv = var10_11;
                    $i$a$-runCatching-LoggerKt$runAndLogException$1$iv = false;
                    $i$a$-runAndLogException-StorageParser$Companion$parsePath$shouldImport$1 = false;
                    var12_13 = Result.constructor-impl((Object)checker.shouldImportProject(path));
                }
                catch (Throwable var13_16) {
                    var12_13 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)var13_16));
                }
                var8_7 = shouldImport = (Boolean)LoggerKt.getOrLogException((Object)var12_13, (Logger)$this$runAndLogException$iv);
                if (Intrinsics.areEqual((Object)var8_7, (Object)true)) break;
                if (Intrinsics.areEqual((Object)var8_7, (Object)false)) {
                    return null;
                }
                if (var8_7 == null) continue;
                throw new NoWhenBranchMatchedException();
            }
            return new RecentPathInfo(this.workaroundWindowsIssue(path.toAbsolutePath().toString()), info);
        }

        private final String workaroundWindowsIssue(String input) {
            if (!SystemInfo.isWindows) {
                return input;
            }
            if (input.length() < 3) {
                return input;
            }
            if (input.charAt(1) != ':') {
                return input;
            }
            String string = String.valueOf(input.charAt(0));
            Intrinsics.checkNotNull((Object)string, (String)"null cannot be cast to non-null type java.lang.String");
            String string2 = string.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
            return string2 + input.subSequence(1, input.length());
        }

        private static final Path parsePath$fromWslPath(String uriInternal) {
            if (!SystemInfo.isWindows) {
                return null;
            }
            String wslRelativePath = StringsKt.removePrefix((String)uriInternal, (CharSequence)"//wsl+");
            return Path.of("\\\\wsl.localhost\\" + StringsKt.replace$default((String)wslRelativePath, (char)'/', (char)'\\', (boolean)false, (int)4, null), new String[0]);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

