/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.html.webSymbols.attributes;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResult;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.XmlAttributeInsertHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.html.webSymbols.HtmlDescriptorUtils;
import com.intellij.html.webSymbols.WebSymbolsFrameworkHtmlSupport;
import com.intellij.html.webSymbols.WebSymbolsHtmlQueryConfigurator;
import com.intellij.html.webSymbols.attributes.WebSymbolHtmlAttributeInfo;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.webSymbols.WebSymbol;
import com.intellij.webSymbols.completion.AsteriskAwarePrefixMatcher;
import com.intellij.webSymbols.completion.WebSymbolCodeCompletionItem;
import com.intellij.webSymbols.completion.WebSymbolsCompletionProviderBase;
import com.intellij.webSymbols.query.WebSymbolsQueryExecutor;
import com.intellij.webSymbols.query.WebSymbolsQueryExecutorFactory;
import com.intellij.webSymbols.utils.WebSymbolUtils;
import com.intellij.xml.XmlAttributeDescriptor;
import java.util.Set;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J8\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0002H\u0014\u00a8\u0006\u0014"}, d2={"Lcom/intellij/html/webSymbols/attributes/WebSymbolAttributeNameCompletionProvider;", "Lcom/intellij/webSymbols/completion/WebSymbolsCompletionProviderBase;", "Lcom/intellij/psi/xml/XmlAttribute;", "<init>", "()V", "getContext", "position", "Lcom/intellij/psi/PsiElement;", "addCompletions", "", "parameters", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "result", "Lcom/intellij/codeInsight/completion/CompletionResultSet;", "", "name", "", "queryExecutor", "Lcom/intellij/webSymbols/query/WebSymbolsQueryExecutor;", "context", "intellij.xml.impl"})
public final class WebSymbolAttributeNameCompletionProvider
extends WebSymbolsCompletionProviderBase<XmlAttribute> {
    @Override
    @Nullable
    protected XmlAttribute getContext(@NotNull PsiElement position) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        return (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)position, XmlAttribute.class);
    }

    @Override
    protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result2, int position, @NotNull String name, @NotNull WebSymbolsQueryExecutor queryExecutor, @NotNull XmlAttribute context) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)queryExecutor, (String)"queryExecutor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        XmlTag xmlTag = context.getParent();
        if (xmlTag == null) {
            return;
        }
        XmlTag tag = xmlTag;
        PrefixMatcher prefixMatcher = result2.getPrefixMatcher().cloneWithPrefix(name);
        Intrinsics.checkNotNullExpressionValue((Object)prefixMatcher, (String)"cloneWithPrefix(...)");
        CompletionResultSet completionResultSet = result2.withPrefixMatcher((PrefixMatcher)new AsteriskAwarePrefixMatcher(prefixMatcher));
        Intrinsics.checkNotNullExpressionValue((Object)completionResultSet, (String)"withPrefixMatcher(...)");
        CompletionResultSet patchedResultSet = completionResultSet;
        XmlAttribute[] xmlAttributeArray = tag.getAttributes();
        Intrinsics.checkNotNullExpressionValue((Object)xmlAttributeArray, (String)"getAttributes(...)");
        Set providedAttributes = SequencesKt.toMutableSet((Sequence)SequencesKt.mapNotNull((Sequence)ArraysKt.asSequence((Object[])xmlAttributeArray), WebSymbolAttributeNameCompletionProvider::addCompletions$lambda$0));
        Predicate<String> attributesFilter = WebSymbolsFrameworkHtmlSupport.Companion.get(queryExecutor.getFramework()).getAttributeNameCodeCompletionFilter(tag);
        Set filteredOutStandardSymbols = SequencesKt.toMutableSet((Sequence)SequencesKt.map(HtmlDescriptorUtils.getStandardHtmlAttributeDescriptors(tag), WebSymbolAttributeNameCompletionProvider::addCompletions$lambda$1));
        WebSymbolsCompletionProviderBase.Companion.processCompletionQueryResults$default(WebSymbolsCompletionProviderBase.Companion, queryExecutor, patchedResultSet, WebSymbol.Companion.getHTML_ATTRIBUTES(), name, position, (PsiElement)context, null, providedAttributes, arg_0 -> WebSymbolAttributeNameCompletionProvider.addCompletions$lambda$2(filteredOutStandardSymbols, name, attributesFilter, arg_0), arg_0 -> WebSymbolAttributeNameCompletionProvider.addCompletions$lambda$4(parameters, patchedResultSet, context, queryExecutor, name, arg_0), 64, null);
        providedAttributes.addAll(filteredOutStandardSymbols);
        result2.runRemainingContributors(parameters, arg_0 -> WebSymbolAttributeNameCompletionProvider.addCompletions$lambda$6(arg_0 -> WebSymbolAttributeNameCompletionProvider.addCompletions$lambda$5(name, providedAttributes, attributesFilter, result2, arg_0), arg_0));
    }

    private static final String addCompletions$lambda$0(XmlAttribute it) {
        return it.getName();
    }

    private static final String addCompletions$lambda$1(XmlAttributeDescriptor it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getName();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean addCompletions$lambda$2(Set $filteredOutStandardSymbols, String $name, Predicate $attributesFilter, WebSymbolCodeCompletionItem item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        if (item.getSymbol() instanceof WebSymbolsHtmlQueryConfigurator.StandardHtmlSymbol && item.getOffset() == 0) {
            WebSymbol webSymbol = item.getSymbol();
            if (Intrinsics.areEqual((Object)(webSymbol != null ? webSymbol.getName() : null), (Object)item.getName())) {
                $filteredOutStandardSymbols.remove(item.getName());
                return false;
            }
        }
        if (item.getOffset() > $name.length()) return false;
        String string = $name.substring(0, item.getOffset());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        if (!$attributesFilter.test(string + item.getName())) return false;
        return true;
    }

    private static final void addCompletions$lambda$4$lambda$3(XmlAttribute $context, WebSymbolsQueryExecutor $queryExecutor, String $name, WebSymbolCodeCompletionItem $item, InsertionContext insertionContext, LookupElement lookupItem) {
        Intrinsics.checkNotNullParameter((Object)insertionContext, (String)"insertionContext");
        Intrinsics.checkNotNullParameter((Object)lookupItem, (String)"lookupItem");
        WebSymbolsQueryExecutor freshRegistry = WebSymbolsQueryExecutorFactory.Companion.create((PsiElement)$context, $queryExecutor.allowResolve());
        String string = $name.substring(0, $item.getOffset());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String fullName = string + $item.getName();
        WebSymbol webSymbol = WebSymbolUtils.asSingleSymbol$default(WebSymbolsQueryExecutor.runNameMatchQuery$default(freshRegistry, "html", "attributes", fullName, false, false, false, null, 120, null), false, 1, null);
        if (webSymbol == null) {
            return;
        }
        WebSymbol match2 = webSymbol;
        PsiFile psiFile = insertionContext.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getFile(...)");
        WebSymbolHtmlAttributeInfo info = WebSymbolHtmlAttributeInfo.Companion.create(fullName, freshRegistry, match2, (PsiElement)psiFile);
        if (info.acceptsValue() && !info.acceptsNoValue()) {
            XmlAttributeInsertHandler.INSTANCE.handleInsert(insertionContext, lookupItem);
        }
    }

    private static final Unit addCompletions$lambda$4(CompletionParameters $parameters, CompletionResultSet $patchedResultSet, XmlAttribute $context, WebSymbolsQueryExecutor $queryExecutor, String $name, WebSymbolCodeCompletionItem item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        WebSymbolCodeCompletionItem.addToResult$default(WebSymbolCodeCompletionItem.withInsertHandlerAdded$default(item, (arg_0, arg_1) -> WebSymbolAttributeNameCompletionProvider.addCompletions$lambda$4$lambda$3($context, $queryExecutor, $name, item, arg_0, arg_1), null, 2, null), $parameters, $patchedResultSet, 0.0, 4, null);
        return Unit.INSTANCE;
    }

    private static final Unit addCompletions$lambda$5(String $name, Set $providedAttributes, Predicate $attributesFilter, CompletionResultSet $result, CompletionResult toPass) {
        String string = toPass.getPrefixMatcher().getPrefix();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPrefix(...)");
        String attrName = StringsKt.removeSuffix((String)$name, (CharSequence)string) + toPass.getLookupElement().getLookupString();
        if (!$providedAttributes.contains(attrName) && $attributesFilter.test(attrName)) {
            LookupElement element = toPass.getLookupElement();
            PrefixMatcher prefixMatcher = toPass.getPrefixMatcher();
            Intrinsics.checkNotNullExpressionValue((Object)prefixMatcher, (String)"getPrefixMatcher(...)");
            $result.withPrefixMatcher((PrefixMatcher)new AsteriskAwarePrefixMatcher(prefixMatcher)).withRelevanceSorter(toPass.getSorter()).addElement(element);
        }
        return Unit.INSTANCE;
    }

    private static final void addCompletions$lambda$6(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }
}

