/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.intentions;

import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.Presentation;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.jetbrains.python.PyNames;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyDictLiteralExpression;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyExpressionStatement;
import com.jetbrains.python.psi.PyKeyValueExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PyDictLiteralFormToConstructorIntention
extends PsiUpdateModCommandAction<PyDictLiteralExpression> {
    PyDictLiteralFormToConstructorIntention() {
        super(PyDictLiteralExpression.class);
    }

    @Nullable
    protected Presentation getPresentation(@NotNull ActionContext context, @NotNull PyDictLiteralExpression element) {
        PyKeyValueExpression[] elements;
        if (context == null) {
            PyDictLiteralFormToConstructorIntention.$$$reportNull$$$0(0);
        }
        if (element == null) {
            PyDictLiteralFormToConstructorIntention.$$$reportNull$$$0(1);
        }
        for (PyKeyValueExpression expression : elements = element.getElements()) {
            PyExpression key = expression.getKey();
            if (!(key instanceof PyStringLiteralExpression)) {
                return null;
            }
            String str = ((PyStringLiteralExpression)key).getStringValue();
            if (PyNames.isReserved((String)str)) {
                return null;
            }
            if (str.isEmpty() || Character.isDigit(str.charAt(0))) {
                return null;
            }
            if (StringUtil.isJavaIdentifier((String)str)) continue;
            return null;
        }
        return super.getPresentation(context, (PsiElement)element);
    }

    protected void invoke(@NotNull ActionContext context, @NotNull PyDictLiteralExpression element, @NotNull ModPsiUpdater updater) {
        if (context == null) {
            PyDictLiteralFormToConstructorIntention.$$$reportNull$$$0(2);
        }
        if (element == null) {
            PyDictLiteralFormToConstructorIntention.$$$reportNull$$$0(3);
        }
        if (updater == null) {
            PyDictLiteralFormToConstructorIntention.$$$reportNull$$$0(4);
        }
        PyElementGenerator elementGenerator = PyElementGenerator.getInstance(context.project());
        PyDictLiteralFormToConstructorIntention.replaceDictLiteral(element, elementGenerator);
    }

    @NotNull
    public String getFamilyName() {
        String string = PyPsiBundle.message("INTN.convert.dict.literal.to.dict.constructor", new Object[0]);
        if (string == null) {
            PyDictLiteralFormToConstructorIntention.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static void replaceDictLiteral(PyDictLiteralExpression dictExpression, PyElementGenerator elementGenerator) {
        PyKeyValueExpression[] argumentList = dictExpression.getElements();
        StringBuilder stringBuilder = new StringBuilder("dict(");
        int size = argumentList.length;
        for (int i = 0; i != size; ++i) {
            PyKeyValueExpression argument = argumentList[i];
            if (!(argument instanceof PyKeyValueExpression)) continue;
            PyExpression key = argument.getKey();
            PyExpression value = argument.getValue();
            if (!(key instanceof PyStringLiteralExpression) || value == null) continue;
            stringBuilder.append(((PyStringLiteralExpression)key).getStringValue());
            stringBuilder.append("=");
            stringBuilder.append(value.getText());
            if (i == size - 1) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append(")");
        PyCallExpression callExpression = (PyCallExpression)((PyExpressionStatement)elementGenerator.createFromText(LanguageLevel.forElement((PsiElement)dictExpression), PyExpressionStatement.class, stringBuilder.toString())).getExpression();
        dictExpression.replace((PsiElement)callExpression);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/codeInsight/intentions/PyDictLiteralFormToConstructorIntention";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/codeInsight/intentions/PyDictLiteralFormToConstructorIntention";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPresentation";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }
}

