/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger.variablesview.usertyperenderers.codeinsight;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.PlainPrefixMatcher;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.lookup.CharFilter;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.UtilKt;
import com.intellij.util.textCompletion.TextCompletionProvider;
import com.jetbrains.python.debugger.variablesview.usertyperenderers.codeinsight.PyTypeNameResolverKt;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.resolve.QualifiedNameFinder;
import com.jetbrains.python.psi.search.PySearchUtilBase;
import com.jetbrains.python.psi.stubs.PyClassNameIndex;
import com.jetbrains.python.psi.types.PyModuleType;
import com.jetbrains.python.psi.types.PyType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\n\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J\u0018\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\tH\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J \u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016J8\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u001c2\u0016\u0010\u001d\u001a\u0012\u0012\u0004\u0012\u00020\t0\u001ej\b\u0012\u0004\u0012\u00020\t`\u001fH\u0002J&\u0010 \u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0010\u001a\u00020\u000f2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\t0\"H\u0002J\u0018\u0010#\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0010\u001a\u00020\u000fH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006$"}, d2={"Lcom/jetbrains/python/debugger/variablesview/usertyperenderers/codeinsight/TypeNameCompletionProvider;", "Lcom/intellij/util/textCompletion/TextCompletionProvider;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getAdvertisement", "", "getPrefix", "text", "offset", "", "applyPrefixMatcher", "Lcom/intellij/codeInsight/completion/CompletionResultSet;", "result", "prefix", "acceptChar", "Lcom/intellij/codeInsight/lookup/CharFilter$Result;", "c", "", "fillCompletionVariants", "", "parameters", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "addClassesFromPyFile", "file", "Lcom/jetbrains/python/psi/PyFile;", "added", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "addVariantsFromModuleComponents", "moduleComponents", "", "addClassesVariants", "intellij.python.community.impl"})
@SourceDebugExtension(value={"SMAP\nTypeNameCompletionProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TypeNameCompletionProvider.kt\ncom/jetbrains/python/debugger/variablesview/usertyperenderers/codeinsight/TypeNameCompletionProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,102:1\n808#2,11:103\n774#2:114\n865#2,2:115\n774#2:117\n865#2,2:118\n*S KotlinDebug\n*F\n+ 1 TypeNameCompletionProvider.kt\ncom/jetbrains/python/debugger/variablesview/usertyperenderers/codeinsight/TypeNameCompletionProvider\n*L\n54#1:103,11\n55#1:114\n55#1:115,2\n56#1:117\n56#1:118,2\n*E\n"})
public final class TypeNameCompletionProvider
implements TextCompletionProvider {
    @NotNull
    private final Project project;

    public TypeNameCompletionProvider(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Nullable
    public String getAdvertisement() {
        return null;
    }

    @NotNull
    public String getPrefix(@NotNull String text, int offset) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return StringsKt.substringAfterLast$default((String)text, (char)'.', null, (int)2, null);
    }

    @NotNull
    public CompletionResultSet applyPrefixMatcher(@NotNull CompletionResultSet result2, @NotNull String prefix) {
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        CompletionResultSet completionResultSet = result2.withPrefixMatcher((PrefixMatcher)new PlainPrefixMatcher(prefix));
        Intrinsics.checkNotNullExpressionValue((Object)completionResultSet, (String)"withPrefixMatcher(...)");
        return completionResultSet;
    }

    @NotNull
    public CharFilter.Result acceptChar(char c) {
        return CharFilter.Result.ADD_TO_PREFIX;
    }

    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull String prefix, @NotNull CompletionResultSet result2) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        result2.restartCompletionOnAnyPrefixChange();
        String text = parameters.getOriginalFile().getText();
        Intrinsics.checkNotNull((Object)text);
        if (!StringsKt.contains$default((CharSequence)text, (char)'.', (boolean)false, (int)2, null)) {
            this.addClassesVariants(parameters, result2);
        }
        char[] cArray = new char[]{'.'};
        List components = UtilKt.init((List)StringsKt.split$default((CharSequence)text, (char[])cArray, (boolean)false, (int)0, (int)6, null));
        this.addVariantsFromModuleComponents(parameters, result2, components);
    }

    /*
     * WARNING - void declaration
     */
    private final void addClassesFromPyFile(CompletionParameters parameters, CompletionResultSet result2, PyFile file, HashSet<String> added) {
        LookupElementBuilder it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv;
        PyModuleType moduleType = new PyModuleType(file);
        ProcessingContext ctx = new ProcessingContext();
        ctx.put(PyType.CTX_NAMES, added);
        Object[] completionVariants = moduleType.getCompletionVariants("", parameters.getPosition().getParent(), ctx);
        Iterable iterable = CollectionsKt.listOf((Object[])Arrays.copyOf(completionVariants, completionVariants.length));
        boolean $i$f$filterIsInstance = false;
        void var11_10 = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof LookupElementBuilder)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (LookupElementBuilder)element$iv$iv;
            boolean bl = false;
            if (!(it.getPsiElement() instanceof PyClass)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (LookupElementBuilder)element$iv$iv;
            boolean bl = false;
            if (!result2.getPrefixMatcher().isStartMatch((LookupElement)it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List variantsList = (List)destination$iv$iv;
        result2.addAllElements((Iterable)variantsList);
    }

    private final void addVariantsFromModuleComponents(CompletionParameters parameters, CompletionResultSet result2, List<String> moduleComponents) {
        HashSet alreadyAddedModulesNames = new HashSet();
        HashSet<String> alreadyAddedClsNames = new HashSet<String>();
        for (PsiElement element : PyTypeNameResolverKt.getElementsFromModule(moduleComponents, this.project)) {
            PsiElement psiElement = element;
            if (psiElement instanceof PsiDirectory) {
                List<LookupElement> modules;
                Intrinsics.checkNotNullExpressionValue(PyModuleType.getSubModuleVariants((PsiDirectory)element, parameters.getPosition().getParent(), alreadyAddedModulesNames), (String)"getSubModuleVariants(...)");
                result2.addAllElements((Iterable)modules);
                continue;
            }
            if (!(psiElement instanceof PyFile)) continue;
            this.addClassesFromPyFile(parameters, result2, (PyFile)element, alreadyAddedClsNames);
        }
    }

    private final void addClassesVariants(CompletionParameters parameters, CompletionResultSet result2) {
        StubIndex stubIndex = StubIndex.getInstance();
        Collection<String> clsKeys = PyClassNameIndex.allKeys(this.project);
        GlobalSearchScope globalSearchScope = PySearchUtilBase.defaultSuggestionScope((PsiElement)parameters.getOriginalFile());
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"defaultSuggestionScope(...)");
        GlobalSearchScope scope = globalSearchScope;
        Set alreadySuggested = new LinkedHashSet();
        Iterator iterator = result2.getPrefixMatcher().sortMatching(clsKeys).iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            String elementName = (String)iterator2.next();
            stubIndex.processElements(PyClassNameIndex.KEY, (Object)elementName, this.project, scope, PyClass.class, arg_0 -> TypeNameCompletionProvider.addClassesVariants$lambda$3(arg_0 -> TypeNameCompletionProvider.addClassesVariants$lambda$2(alreadySuggested, result2, arg_0), arg_0));
        }
    }

    private static final boolean addClassesVariants$lambda$2(Set $alreadySuggested, CompletionResultSet $result, PyClass element) {
        ProgressManager.checkCanceled();
        String string = element.getName();
        if (string == null) {
            return true;
        }
        String name2 = string;
        if (element.getQualifiedName() == null) {
            return true;
        }
        QualifiedName qualifiedName = QualifiedNameFinder.findCanonicalImportPath(element, null);
        if (qualifiedName == null) {
            return true;
        }
        QualifiedName importPath = qualifiedName;
        String pathName = importPath + "." + name2;
        if ($alreadySuggested.add(pathName)) {
            LookupElementBuilder lookupElementBuilder = LookupElementBuilder.create((String)pathName).withIcon(AllIcons.Nodes.Class).withTypeText(importPath.toString()).withPresentableText(name2);
            Intrinsics.checkNotNullExpressionValue((Object)lookupElementBuilder, (String)"withPresentableText(...)");
            LookupElementBuilder builder = lookupElementBuilder;
            $result.addElement((LookupElement)builder);
        }
        return true;
    }

    private static final boolean addClassesVariants$lambda$3(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }
}

