/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.search;

import com.intellij.psi.PsiElement;
import com.intellij.psi.search.searches.ExtensibleQueryFactory;
import com.intellij.util.Query;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public final class PySuperMethodsSearch
extends ExtensibleQueryFactory<PsiElement, SearchParameters> {
    public static final PySuperMethodsSearch INSTANCE = new PySuperMethodsSearch();

    private static PyFunction getBaseMethod(List<PsiElement> superMethods, PyClass containingClass) {
        for (PyClass ancestor : containingClass.getAncestorClasses(null)) {
            for (PsiElement method : superMethods) {
                if (!ancestor.equals(((PyFunction)method).getContainingClass())) continue;
                return (PyFunction)method;
            }
        }
        return (PyFunction)superMethods.get(superMethods.size() - 1);
    }

    public static PyFunction findDeepestSuperMethod(PyFunction function) {
        TypeEvalContext context = TypeEvalContext.userInitiated(function.getProject(), null);
        ArrayList<Object> superMethods = new ArrayList<PsiElement>(PySuperMethodsSearch.search(function, true, context).findAll());
        while (superMethods.size() > 0) {
            function = PySuperMethodsSearch.getBaseMethod(superMethods, function.getContainingClass());
            superMethods = new ArrayList(PySuperMethodsSearch.search(function, true, context).findAll());
        }
        return function;
    }

    private PySuperMethodsSearch() {
        super("Pythonid");
    }

    public static Query<PsiElement> search(PyFunction derivedMethod, @Nullable TypeEvalContext context) {
        SearchParameters parameters = new SearchParameters(derivedMethod, false, context);
        return INSTANCE.createUniqueResultsQuery(parameters);
    }

    public static Query<PsiElement> search(PyFunction derivedMethod, boolean deepSearch, @Nullable TypeEvalContext context) {
        SearchParameters parameters = new SearchParameters(derivedMethod, deepSearch, context);
        return INSTANCE.createUniqueResultsQuery(parameters);
    }

    public static class SearchParameters {
        private final PyFunction myDerivedMethod;
        private final boolean myDeepSearch;
        private final TypeEvalContext myContext;

        public SearchParameters(PyFunction derivedMethod, boolean deepSearch, @Nullable TypeEvalContext context) {
            this.myDerivedMethod = derivedMethod;
            this.myDeepSearch = deepSearch;
            this.myContext = context;
        }

        @Nullable
        public TypeEvalContext getContext() {
            return this.myContext;
        }

        public PyFunction getDerivedMethod() {
            return this.myDerivedMethod;
        }

        public boolean isDeepSearch() {
            return this.myDeepSearch;
        }
    }
}

