/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.types;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Ref;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PySingleStarParameter;
import com.jetbrains.python.psi.PySlashParameter;
import com.jetbrains.python.psi.types.PyCallableParameter;
import com.jetbrains.python.psi.types.PyTupleType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeParameterType;
import com.jetbrains.python.psi.types.PyTypeVarTupleType;
import com.jetbrains.python.psi.types.PyUnpackedTupleType;
import com.jetbrains.python.psi.types.PyUnpackedTupleTypeImpl;
import com.jetbrains.python.psi.types.PyVariadicType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.EnumSet;
import java.util.List;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PyTypeParameterMapping {
    private final List<Couple<PyType>> myMappedTypes;

    private PyTypeParameterMapping(@NotNull List<Couple<PyType>> mapping) {
        if (mapping == null) {
            PyTypeParameterMapping.$$$reportNull$$$0(0);
        }
        for (Couple<PyType> couple : mapping) {
            PyType expectedType = (PyType)couple.getFirst();
            PyType actualType = (PyType)couple.getSecond();
            if (expectedType instanceof PyVariadicType && !(actualType instanceof PyVariadicType) && actualType != null) {
                throw new IllegalArgumentException("Variadic type " + expectedType + " cannot be mapped to a non-variadic type " + actualType);
            }
            if (expectedType instanceof PyVariadicType || !(actualType instanceof PyVariadicType)) continue;
            throw new IllegalArgumentException("Non-variadic type " + expectedType + " cannot be mapped to a variadic type " + actualType);
        }
        this.myMappedTypes = mapping;
    }

    @Nullable
    public static PyTypeParameterMapping mapWithParameterList(@NotNull List<? extends PyType> expectedParameterTypes, @NotNull List<PyCallableParameter> actualParameters, @NotNull TypeEvalContext context) {
        int actualArity;
        List<PyType> flattenedExpectedParameterTypes;
        if (expectedParameterTypes == null) {
            PyTypeParameterMapping.$$$reportNull$$$0(1);
        }
        if (actualParameters == null) {
            PyTypeParameterMapping.$$$reportNull$$$0(2);
        }
        if (context == null) {
            PyTypeParameterMapping.$$$reportNull$$$0(3);
        }
        int expectedArity = ContainerUtil.exists(flattenedExpectedParameterTypes = PyTypeParameterMapping.flattenUnpackedTupleTypes(expectedParameterTypes), (Condition)Conditions.instanceOf(PyVariadicType.class)) ? -1 : flattenedExpectedParameterTypes.size();
        ArrayList<PyType> requiredPositionalArgumentTypes = new ArrayList<PyType>();
        ArrayList<PyType> optionalPositionalArgumentTypes = new ArrayList<PyType>();
        SmartList positionalVarargArgumentTypes = new SmartList();
        for (PyCallableParameter parameter : actualParameters) {
            PyNamedParameter namedParameter;
            if (parameter.isSelf() || parameter.getParameter() instanceof PySlashParameter || parameter.getParameter() instanceof PySingleStarParameter || parameter.isKeywordContainer()) continue;
            PyParameter pyParameter = parameter.getParameter();
            if (pyParameter instanceof PyNamedParameter && (namedParameter = (PyNamedParameter)pyParameter).isKeywordOnly()) {
                if (namedParameter.hasDefaultValue()) continue;
                return null;
            }
            PyType actualParameterType = parameter.getType(context);
            if (parameter.isPositionalContainer()) {
                if (actualParameterType instanceof PyTupleType) {
                    PyTupleType argsTupleType = (PyTupleType)actualParameterType;
                    positionalVarargArgumentTypes.addAll(PyTypeParameterMapping.flattenUnpackedTupleTypes(Collections.singletonList(argsTupleType.asUnpackedTupleType())));
                    continue;
                }
                positionalVarargArgumentTypes.addAll(PyTypeParameterMapping.flattenUnpackedTupleTypes(Collections.singletonList(actualParameterType)));
                continue;
            }
            if (parameter.hasDefaultValue()) {
                optionalPositionalArgumentTypes.add(actualParameterType);
                continue;
            }
            requiredPositionalArgumentTypes.addAll(PyTypeParameterMapping.flattenUnpackedTupleTypes(Collections.singletonList(actualParameterType)));
        }
        if (positionalVarargArgumentTypes.size() > 1 || positionalVarargArgumentTypes.size() == 1 && !(positionalVarargArgumentTypes.get(0) instanceof PyVariadicType)) {
            requiredPositionalArgumentTypes.addAll(optionalPositionalArgumentTypes);
            optionalPositionalArgumentTypes.clear();
            requiredPositionalArgumentTypes.addAll((Collection<PyType>)positionalVarargArgumentTypes);
            positionalVarargArgumentTypes.clear();
        }
        int n = actualArity = ContainerUtil.exists(requiredPositionalArgumentTypes, (Condition)Conditions.instanceOf(PyVariadicType.class)) ? -1 : requiredPositionalArgumentTypes.size();
        if (expectedArity != -1 && actualArity != -1) {
            if (actualArity > expectedArity) {
                return null;
            }
            ArrayList arityAdjustedActualParameterTypes = new ArrayList(requiredPositionalArgumentTypes);
            arityAdjustedActualParameterTypes.addAll(optionalPositionalArgumentTypes.subList(0, Math.min(optionalPositionalArgumentTypes.size(), expectedArity - arityAdjustedActualParameterTypes.size())));
            if (!positionalVarargArgumentTypes.isEmpty() && expectedArity - arityAdjustedActualParameterTypes.size() > 0) {
                assert (positionalVarargArgumentTypes.size() == 1 && positionalVarargArgumentTypes.get(0) instanceof PyVariadicType);
                arityAdjustedActualParameterTypes.add((PyType)positionalVarargArgumentTypes.get(0));
            }
            return PyTypeParameterMapping.mapByShape(flattenedExpectedParameterTypes, arityAdjustedActualParameterTypes, new Option[0]);
        }
        return PyTypeParameterMapping.mapByShape(flattenedExpectedParameterTypes, ContainerUtil.concat((List[])new List[]{requiredPositionalArgumentTypes, optionalPositionalArgumentTypes, positionalVarargArgumentTypes}), new Option[0]);
    }

    @Nullable
    public static PyTypeParameterMapping mapByShape(@NotNull List<? extends PyType> expectedTypes, @NotNull List<? extends PyType> actualTypes, Option ... options) {
        boolean sizeMismatch;
        PyType unpackedTupleType;
        PyType rightmostActual;
        PyType rightmostExpected;
        PyType leftmostActual;
        PyType leftmostExpected;
        if (expectedTypes == null) {
            PyTypeParameterMapping.$$$reportNull$$$0(4);
        }
        if (actualTypes == null) {
            PyTypeParameterMapping.$$$reportNull$$$0(5);
        }
        if (options == null) {
            PyTypeParameterMapping.$$$reportNull$$$0(6);
        }
        EnumSet<Option> optionSet = EnumSet.noneOf(Option.class);
        optionSet.addAll(Arrays.asList(options));
        NullTolerantDeque<PyType> expectedTypesDeque = new NullTolerantDeque<PyType>(PyTypeParameterMapping.flattenUnpackedTupleTypes(expectedTypes));
        NullTolerantDeque<PyType> actualTypesDeque = new NullTolerantDeque<PyType>(PyTypeParameterMapping.flattenUnpackedTupleTypes(actualTypes));
        ArrayList<Couple> leftMappedTypes = new ArrayList<Couple>();
        ArrayList<Couple<PyType>> centerMappedTypes = new ArrayList<Couple<PyType>>();
        ArrayList<Couple> rightMappedTypes = new ArrayList<Couple>();
        boolean splittingTypeVarTuple = false;
        while (expectedTypesDeque.size() != 0 && actualTypesDeque.size() != 0 && !((leftmostExpected = expectedTypesDeque.peekFirst()) instanceof PyVariadicType) && !((leftmostActual = actualTypesDeque.peekFirst()) instanceof PyVariadicType)) {
            expectedTypesDeque.removeFirst();
            actualTypesDeque.removeFirst();
            leftMappedTypes.add(Couple.of((Object)leftmostExpected, (Object)leftmostActual));
        }
        while (expectedTypesDeque.size() != 0 && actualTypesDeque.size() != 0 && !((rightmostExpected = expectedTypesDeque.peekLast()) instanceof PyVariadicType)) {
            expectedTypesDeque.removeLast();
            rightmostActual = actualTypesDeque.peekLast();
            if (rightmostActual instanceof PyVariadicType) {
                PyVariadicType rightmostActualVariadic = (PyVariadicType)rightmostActual;
                if (rightmostActualVariadic instanceof PyUnpackedTupleType && (unpackedTupleType = (PyUnpackedTupleType)rightmostActualVariadic).isUnbound()) {
                    PyType repeatedActualType = unpackedTupleType.getElementTypes().get(0);
                    rightMappedTypes.add(Couple.of((Object)rightmostExpected, (Object)repeatedActualType));
                    continue;
                }
                splittingTypeVarTuple = true;
                break;
            }
            actualTypesDeque.removeLast();
            rightMappedTypes.add(Couple.of((Object)rightmostExpected, (Object)rightmostActual));
        }
        if (expectedTypesDeque.size() != 0 && actualTypesDeque.size() != 0 && !(expectedTypesDeque.peekFirst() instanceof PyVariadicType) && (rightmostActual = actualTypesDeque.peekFirst()) instanceof PyVariadicType) {
            PyUnpackedTupleType actualUnpackedTupleType;
            PyVariadicType variadic = (PyVariadicType)rightmostActual;
            if (variadic instanceof PyUnpackedTupleType && (actualUnpackedTupleType = (PyUnpackedTupleType)variadic).isUnbound()) {
                while (expectedTypesDeque.size() != 0 && !(expectedTypesDeque.peekFirst() instanceof PyVariadicType)) {
                    PyType repeatedActualType = actualUnpackedTupleType.getElementTypes().get(0);
                    leftMappedTypes.add(Couple.of((Object)expectedTypesDeque.peekFirst(), (Object)repeatedActualType));
                    expectedTypesDeque.removeFirst();
                }
            } else {
                splittingTypeVarTuple = true;
            }
        }
        if (splittingTypeVarTuple) {
            return null;
        }
        if (expectedTypesDeque.size() == 0) {
            boolean allActualTypesMatched = actualTypesDeque.size() == 0;
            boolean onlySingleActualVariadicLeft = actualTypesDeque.size() == 1 && actualTypesDeque.peekFirst() instanceof PyVariadicType;
            sizeMismatch = !allActualTypesMatched && !onlySingleActualVariadicLeft;
        } else if (expectedTypesDeque.size() == 1) {
            PyType onlyLeftExpectedType = expectedTypesDeque.peekFirst();
            if (onlyLeftExpectedType instanceof PyVariadicType) {
                if (actualTypesDeque.size() == 1 && (unpackedTupleType = actualTypesDeque.peekFirst()) instanceof PyVariadicType) {
                    PyVariadicType variadicType = (PyVariadicType)unpackedTupleType;
                    centerMappedTypes.add((Couple<PyType>)Couple.of((Object)onlyLeftExpectedType, (Object)variadicType));
                } else {
                    PyTypeVarTupleType typeVarTupleType;
                    List<PyType> unmatchedActualTypes = actualTypesDeque.toList();
                    if (optionSet.contains((Object)Option.USE_DEFAULTS) && onlyLeftExpectedType instanceof PyTypeVarTupleType && (typeVarTupleType = (PyTypeVarTupleType)onlyLeftExpectedType).getDefaultType() != null && unmatchedActualTypes.isEmpty()) {
                        centerMappedTypes.add((Couple<PyType>)Couple.of((Object)onlyLeftExpectedType, (Object)typeVarTupleType.getDefaultType()));
                    } else {
                        centerMappedTypes.add((Couple<PyType>)Couple.of((Object)onlyLeftExpectedType, (Object)PyUnpackedTupleTypeImpl.create(unmatchedActualTypes)));
                    }
                }
                sizeMismatch = false;
            } else {
                sizeMismatch = PyTypeParameterMapping.handleSizeMismatch(onlyLeftExpectedType, centerMappedTypes, optionSet);
            }
        } else {
            sizeMismatch = true;
            for (PyType unmatchedType : expectedTypesDeque.toList()) {
                sizeMismatch = PyTypeParameterMapping.handleSizeMismatch(unmatchedType, centerMappedTypes, optionSet);
            }
        }
        if (sizeMismatch) {
            return null;
        }
        ArrayList<Couple<PyType>> resultMapping = new ArrayList<Couple<PyType>>(leftMappedTypes);
        resultMapping.addAll(centerMappedTypes);
        Collections.reverse(rightMappedTypes);
        resultMapping.addAll(rightMappedTypes);
        return new PyTypeParameterMapping(resultMapping);
    }

    private static boolean handleSizeMismatch(@Nullable PyType unmatchedType, @NotNull List<Couple<PyType>> centerMappedTypes, @NotNull EnumSet<Option> optionSet) {
        boolean sizeMismatch;
        if (centerMappedTypes == null) {
            PyTypeParameterMapping.$$$reportNull$$$0(7);
        }
        if (optionSet == null) {
            PyTypeParameterMapping.$$$reportNull$$$0(8);
        }
        if (optionSet.contains((Object)Option.USE_DEFAULTS)) {
            PyTypeParameterType typeParameterType;
            if (unmatchedType instanceof PyTypeParameterType && (typeParameterType = (PyTypeParameterType)unmatchedType).getDefaultType() != null) {
                centerMappedTypes.add((Couple<PyType>)Couple.of((Object)unmatchedType, (Object)typeParameterType.getDefaultType()));
                sizeMismatch = false;
            } else if (optionSet.contains((Object)Option.MAP_UNMATCHED_EXPECTED_TYPES_TO_ANY)) {
                sizeMismatch = false;
                centerMappedTypes.add((Couple<PyType>)Couple.of((Object)unmatchedType, null));
            } else {
                sizeMismatch = true;
            }
        } else if (optionSet.contains((Object)Option.MAP_UNMATCHED_EXPECTED_TYPES_TO_ANY) && !optionSet.contains((Object)Option.USE_DEFAULTS)) {
            centerMappedTypes.add((Couple<PyType>)Couple.of((Object)unmatchedType, null));
            sizeMismatch = false;
        } else {
            sizeMismatch = true;
        }
        return sizeMismatch;
    }

    @NotNull
    private static List<PyType> flattenUnpackedTupleTypes(List<? extends PyType> types) {
        List list = ContainerUtil.flatMap(types, type2 -> {
            PyUnpackedTupleType unpackedTupleType;
            if (type2 instanceof PyUnpackedTupleType && !(unpackedTupleType = (PyUnpackedTupleType)type2).isUnbound()) {
                return PyTypeParameterMapping.flattenUnpackedTupleTypes(unpackedTupleType.getElementTypes());
            }
            return Collections.singletonList(type2);
        });
        if (list == null) {
            PyTypeParameterMapping.$$$reportNull$$$0(9);
        }
        return list;
    }

    @NotNull
    public List<Couple<PyType>> getMappedTypes() {
        List<Couple<PyType>> list = Collections.unmodifiableList(this.myMappedTypes);
        if (list == null) {
            PyTypeParameterMapping.$$$reportNull$$$0(10);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapping";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedParameterTypes";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actualParameters";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedTypes";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actualTypes";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "centerMappedTypes";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "optionSet";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/types/PyTypeParameterMapping";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/types/PyTypeParameterMapping";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "flattenUnpackedTupleTypes";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getMappedTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "mapWithParameterList";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "mapByShape";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "handleSizeMismatch";
                break;
            }
            case 9: 
            case 10: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 9, 10 -> new IllegalStateException(string);
        };
    }

    public static enum Option {
        MAP_UNMATCHED_EXPECTED_TYPES_TO_ANY,
        USE_DEFAULTS;

    }

    private static final class NullTolerantDeque<T> {
        private final Deque<Ref<T>> myDeque;

        private NullTolerantDeque(@NotNull Collection<? extends @Nullable T> collection) {
            if (collection == null) {
                NullTolerantDeque.$$$reportNull$$$0(0);
            }
            this.myDeque = new ArrayDeque<Ref<T>>(ContainerUtil.map(collection, Ref::create));
        }

        @Nullable
        public T peekFirst() {
            if (this.myDeque.isEmpty()) {
                throw new NoSuchElementException();
            }
            return (T)Ref.deref(this.myDeque.peekFirst());
        }

        @Nullable
        public T peekLast() {
            if (this.myDeque.isEmpty()) {
                throw new NoSuchElementException();
            }
            return (T)Ref.deref(this.myDeque.peekLast());
        }

        public void removeFirst() {
            if (this.myDeque.isEmpty()) {
                throw new NoSuchElementException();
            }
            this.myDeque.removeFirst();
        }

        public void removeLast() {
            if (this.myDeque.isEmpty()) {
                throw new NoSuchElementException();
            }
            this.myDeque.removeLast();
        }

        public int size() {
            return this.myDeque.size();
        }

        public @NotNull List<@Nullable T> toList() {
            List list = ContainerUtil.map(this.myDeque, Ref::deref);
            if (list == null) {
                NullTolerantDeque.$$$reportNull$$$0(1);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "collection";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/psi/types/PyTypeParameterMapping$NullTolerantDeque";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/psi/types/PyTypeParameterMapping$NullTolerantDeque";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toList";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

