/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.testing;

import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.testframework.sm.runner.SMTestLocator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.stubs.PyClassNameIndex;
import com.jetbrains.python.psi.stubs.PyFunctionNameIndex;
import com.jetbrains.python.testing.PyPsiLocationWithFixedClass;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PythonUnitTestTestIdUrlProvider
implements SMTestLocator,
DumbAware {
    public static final String PROTOCOL_ID = "python_uttestid";
    public static final PythonUnitTestTestIdUrlProvider INSTANCE = new PythonUnitTestTestIdUrlProvider();

    @NotNull
    public List<Location> getLocation(@NotNull String protocol, @NotNull String path2, @NotNull Project project, @NotNull GlobalSearchScope scope) {
        if (protocol == null) {
            PythonUnitTestTestIdUrlProvider.$$$reportNull$$$0(0);
        }
        if (path2 == null) {
            PythonUnitTestTestIdUrlProvider.$$$reportNull$$$0(1);
        }
        if (project == null) {
            PythonUnitTestTestIdUrlProvider.$$$reportNull$$$0(2);
        }
        if (scope == null) {
            PythonUnitTestTestIdUrlProvider.$$$reportNull$$$0(3);
        }
        if (!PROTOCOL_ID.equals(protocol)) {
            List<Location> list = Collections.emptyList();
            if (list == null) {
                PythonUnitTestTestIdUrlProvider.$$$reportNull$$$0(4);
            }
            return list;
        }
        List list = StringUtil.split((String)path2, (String)".");
        if (list.isEmpty()) {
            List<Location> list2 = Collections.emptyList();
            if (list2 == null) {
                PythonUnitTestTestIdUrlProvider.$$$reportNull$$$0(5);
            }
            return list2;
        }
        int listSize = list.size();
        if (listSize == 2) {
            List<Location> list3 = PythonUnitTestTestIdUrlProvider.findLocations(project, (String)list.get(0), (String)list.get(1), null);
            if (list3 == null) {
                PythonUnitTestTestIdUrlProvider.$$$reportNull$$$0(6);
            }
            return list3;
        }
        if (listSize > 2) {
            String className = (String)list.get(listSize - 2);
            String methodName = (String)list.get(listSize - 1);
            String fileName = (String)list.get(listSize - 3);
            List<Location> locations = PythonUnitTestTestIdUrlProvider.findLocations(project, fileName, className, methodName);
            if (locations.size() > 0) {
                List<Location> list4 = locations;
                if (list4 == null) {
                    PythonUnitTestTestIdUrlProvider.$$$reportNull$$$0(7);
                }
                return list4;
            }
            List<Location> list5 = PythonUnitTestTestIdUrlProvider.findLocations(project, (String)list.get(listSize - 2), (String)list.get(listSize - 1), null);
            if (list5 == null) {
                PythonUnitTestTestIdUrlProvider.$$$reportNull$$$0(8);
            }
            return list5;
        }
        List<Location> list6 = Collections.emptyList();
        if (list6 == null) {
            PythonUnitTestTestIdUrlProvider.$$$reportNull$$$0(9);
        }
        return list6;
    }

    public static List<Location> findLocations(@NotNull Project project, @NotNull String fileName, @Nullable String className, @Nullable String methodName) {
        ArrayList<Location> locations;
        block10: {
            block9: {
                if (project == null) {
                    PythonUnitTestTestIdUrlProvider.$$$reportNull$$$0(10);
                }
                if (fileName == null) {
                    PythonUnitTestTestIdUrlProvider.$$$reportNull$$$0(11);
                }
                if (fileName.contains("%")) {
                    fileName = fileName.substring(0, fileName.lastIndexOf("%"));
                }
                locations = new ArrayList<Location>();
                if (methodName == null && className == null) {
                    VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(fileName);
                    if (virtualFile == null) {
                        return locations;
                    }
                    PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(virtualFile);
                    if (psiFile != null) {
                        locations.add((Location)new PsiLocation(project, (PsiElement)psiFile));
                    }
                }
                if (className == null) break block9;
                for (PyClass cls : PyClassNameIndex.find(className, project, false)) {
                    ProgressManager.checkCanceled();
                    PsiFile containingFile = cls.getContainingFile();
                    VirtualFile virtualFile = containingFile.getVirtualFile();
                    String clsFileName = virtualFile == null ? containingFile.getName() : virtualFile.getPath();
                    String clsFileNameWithoutExt = FileUtilRt.getNameWithoutExtension((String)clsFileName);
                    if (!clsFileNameWithoutExt.endsWith(fileName) && !fileName.equals(clsFileName)) continue;
                    if (methodName == null) {
                        locations.add((Location)new PsiLocation(project, (PsiElement)cls));
                        continue;
                    }
                    PyFunction method = cls.findMethodByName(methodName, true, null);
                    if (method == null) continue;
                    locations.add((Location)new PyPsiLocationWithFixedClass(project, method, cls));
                }
                break block10;
            }
            if (methodName == null) break block10;
            for (PyFunction function : PyFunctionNameIndex.find(methodName, project)) {
                PsiFile containingFile;
                VirtualFile virtualFile;
                String clsFileName;
                String clsFileNameWithoutExt;
                ProgressManager.checkCanceled();
                if (function.getContainingClass() != null || !(clsFileNameWithoutExt = FileUtilRt.getNameWithoutExtension((String)(clsFileName = (virtualFile = (containingFile = function.getContainingFile()).getVirtualFile()) == null ? containingFile.getName() : virtualFile.getPath()))).endsWith(fileName)) continue;
                locations.add((Location)new PsiLocation(project, (PsiElement)function));
            }
        }
        return locations;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 7, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "protocol";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/testing/PythonUnitTestTestIdUrlProvider";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/testing/PythonUnitTestTestIdUrlProvider";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLocation";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findLocations";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 7, 8, 9 -> new IllegalStateException(string);
        };
    }
}

