/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.llmInstaller.ui.promo;

import com.intellij.codeInsight.inline.completion.options.InlineCompletionConfigurable;
import com.intellij.icons.AllIcons;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.laf.LafManagerImpl;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.llmInstaller.LLMIcons;
import com.intellij.llmInstaller.LLMInstallerBundle;
import com.intellij.llmInstaller.ui.promo.AiPromoContent;
import com.intellij.llmInstaller.ui.promo.AiPromoScopeHolder;
import com.intellij.llmInstaller.ui.promo.AiPromoWindowKt;
import com.intellij.llmInstaller.ui.promo.AiPromoWindowStatistics;
import com.intellij.llmInstaller.ui.promo.AiPromoWindowStatisticsSink;
import com.intellij.llmInstaller.ui.promo.AnimatedComponentBuilder;
import com.intellij.llmInstaller.ui.promo.AnimatedOptionChooser;
import com.intellij.llmInstaller.ui.promo.ColorsKt;
import com.intellij.llmInstaller.ui.promo.CommentLabel;
import com.intellij.llmInstaller.ui.promo.EnableButtonColors;
import com.intellij.llmInstaller.ui.promo.GradientImages;
import com.intellij.llmInstaller.ui.promo.OptionPanel;
import com.intellij.llmInstaller.ui.promo.SlideCarousel;
import com.intellij.llmInstaller.ui.promo.SlideInfo;
import com.intellij.llmInstaller.ui.welcome.components.DisclosureButtonUI;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.observable.properties.AtomicBooleanProperty;
import com.intellij.openapi.observable.properties.ObservableBooleanProperty;
import com.intellij.openapi.observable.properties.ObservableProperty;
import com.intellij.openapi.observable.util.PropertyOperationUtil;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Disposer;
import com.intellij.platform.util.coroutines.CoroutineScopeKt;
import com.intellij.ui.AnimatedIcon;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KFunction;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001:\u0001%B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\n\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0014J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0016J\b\u0010#\u001a\u00020 H\u0016J\n\u0010$\u001a\u0004\u0018\u00010\u001dH\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u000e\u0010\u001e\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/intellij/llmInstaller/ui/promo/AiPromoWindow;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "gradientImages", "Lcom/intellij/llmInstaller/ui/promo/GradientImages;", "content", "Lcom/intellij/llmInstaller/ui/promo/AiPromoContent;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/llmInstaller/ui/promo/GradientImages;Lcom/intellij/llmInstaller/ui/promo/AiPromoContent;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getGradientImages", "()Lcom/intellij/llmInstaller/ui/promo/GradientImages;", "getContent", "()Lcom/intellij/llmInstaller/ui/promo/AiPromoContent;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "statisticsSink", "Lcom/intellij/llmInstaller/ui/promo/AiPromoWindowStatisticsSink;", "getStatisticsSink", "()Lcom/intellij/llmInstaller/ui/promo/AiPromoWindowStatisticsSink;", "closed", "", "getClosed", "()Z", "setClosed", "(Z)V", "createSouthPanel", "Ljavax/swing/JComponent;", "trackWindowNotFit", "fitToScreen", "", "rect", "Ljava/awt/Rectangle;", "show", "createCenterPanel", "ContentDoesntFitOnScreenException", "intellij.llmInstaller"})
@SourceDebugExtension(value={"SMAP\nAiPromoWindow.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AiPromoWindow.kt\ncom/intellij/llmInstaller/ui/promo/AiPromoWindow\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,400:1\n31#2,2:401\n24#3:403\n*S KotlinDebug\n*F\n+ 1 AiPromoWindow.kt\ncom/intellij/llmInstaller/ui/promo/AiPromoWindow\n*L\n55#1:401,2\n104#1:403\n*E\n"})
final class AiPromoWindow
extends DialogWrapper {
    @NotNull
    private final Project project;
    @NotNull
    private final GradientImages gradientImages;
    @NotNull
    private final AiPromoContent content;
    @NotNull
    private final CoroutineScope scope;
    @NotNull
    private final AiPromoWindowStatisticsSink statisticsSink;
    private boolean closed;
    private boolean trackWindowNotFit;

    public AiPromoWindow(@NotNull Project project, @NotNull GradientImages gradientImages, @NotNull AiPromoContent content) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)gradientImages, (String)"gradientImages");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        super(project);
        this.project = project;
        this.gradientImages = gradientImages;
        this.content = content;
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<AiPromoScopeHolder> serviceClass$iv = AiPromoScopeHolder.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        this.scope = CoroutineScopeKt.childScope$default((CoroutineScope)((AiPromoScopeHolder)object).getScope(), (String)"AI Promo Window Animations", null, (boolean)false, (int)6, null);
        this.statisticsSink = new AiPromoWindowStatisticsSink();
        this.setModal(false);
        Disposer.register((Disposable)this.myDisposable, () -> AiPromoWindow._init_$lambda$0(this));
        Disposer.register((Disposable)this.myDisposable, () -> AiPromoWindow._init_$lambda$1(this));
        this.init();
        this.setTitle(LLMInstallerBundle.INSTANCE.message("ai.promo.window.title", new Object[0]));
        this.setResizable(false);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final GradientImages getGradientImages() {
        return this.gradientImages;
    }

    @NotNull
    public final AiPromoContent getContent() {
        return this.content;
    }

    @NotNull
    public final AiPromoWindowStatisticsSink getStatisticsSink() {
        return this.statisticsSink;
    }

    public final boolean getClosed() {
        return this.closed;
    }

    public final void setClosed(boolean bl) {
        this.closed = bl;
    }

    @Nullable
    protected JComponent createSouthPanel() {
        return null;
    }

    public void fitToScreen(@NotNull Rectangle rect) {
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        if (!this.trackWindowNotFit) {
            super.fitToScreen(rect);
        } else {
            Rectangle before = new Rectangle(rect);
            super.fitToScreen(rect);
            if (before.width > rect.width || before.height > rect.height) {
                throw ContentDoesntFitOnScreenException.INSTANCE;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void show() {
        try {
            this.trackWindowNotFit = true;
            super.show();
        }
        catch (ContentDoesntFitOnScreenException contentDoesntFitOnScreenException) {
            AiPromoWindow $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(AiPromoWindow.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("AI Promo Window doesn't fit to the screen. We cannot show it. Skipping");
            Disposer.dispose((Disposable)this.myDisposable);
            return;
        }
        finally {
            this.trackWindowNotFit = false;
        }
        PropertiesComponent.getInstance().setValue("ai.promo.window.was.actually.shown", true);
        this.statisticsSink.windowShown();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        CoroutineScope coroutineScope;
        KFunction kFunction;
        AnimatedOptionChooser animatedOptionChooser;
        LafManager lafManager = LafManager.getInstance();
        Intrinsics.checkNotNull((Object)lafManager, (String)"null cannot be cast to non-null type com.intellij.ide.ui.laf.LafManagerImpl");
        JBFont jBFont = JBFont.create((Font)((LafManagerImpl)lafManager).getDefaultFont(), (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)jBFont, (String)"create(...)");
        JBFont labelFont = jBFont;
        Disposable disposable = this.getDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"getDisposable(...)");
        AnimatedOptionChooser it = new AnimatedOptionChooser(this.scope, disposable);
        boolean bl = false;
        if (this.content.getLocal().isEmpty()) {
            animatedOptionChooser = it;
        } else {
            kFunction = this.content.getLocal();
            coroutineScope = this.scope;
            Image image = this.gradientImages.getDescription();
            KFunction kFunction2 = (KFunction)new Function2<String, Integer, Unit>((Object)this.statisticsSink){

                public final void invoke(String p0, int p1) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    ((AiPromoWindowStatisticsSink)this.receiver).slideShown(p0, p1);
                }
            };
            JBFont jBFont2 = labelFont.asBold();
            Intrinsics.checkNotNullExpressionValue((Object)jBFont2, (String)"asBold(...)");
            JBFont jBFont3 = jBFont2;
            animatedOptionChooser = it.withOption(new SlideCarousel((List)kFunction, coroutineScope, image, jBFont3, 0L, 0L, (Function2)kFunction2, 48, null), (Function0<Unit>)((Function0)() -> AiPromoWindow.createCenterPanel$lambda$12$lambda$2(this)), (Function2<? super AnimatedComponentBuilder, ? super ObservableBooleanProperty, ? extends JComponent>)((Function2)(arg_0, arg_1) -> AiPromoWindow.createCenterPanel$lambda$12$lambda$11(labelFont, this, arg_0, arg_1)));
        }
        List<SlideInfo> list = this.content.getCloud();
        CoroutineScope coroutineScope2 = this.scope;
        Image image = this.gradientImages.getDescription();
        kFunction = (KFunction)new Function2<String, Integer, Unit>((Object)this.statisticsSink){

            public final void invoke(String p0, int p1) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                ((AiPromoWindowStatisticsSink)this.receiver).slideShown(p0, p1);
            }
        };
        JBFont jBFont4 = labelFont.asBold();
        Intrinsics.checkNotNullExpressionValue((Object)jBFont4, (String)"asBold(...)");
        coroutineScope = jBFont4;
        AnimatedOptionChooser animatedOptionChooser2 = animatedOptionChooser.withOption(new SlideCarousel(list, coroutineScope2, image, (JBFont)coroutineScope, 0L, 0L, (Function2)kFunction, 48, null), (Function0<Unit>)((Function0)() -> AiPromoWindow.createCenterPanel$lambda$13(this)), (Function2<? super AnimatedComponentBuilder, ? super ObservableBooleanProperty, ? extends JComponent>)((Function2)(arg_0, arg_1) -> AiPromoWindow.createCenterPanel$lambda$26(labelFont, this, arg_0, arg_1)));
        list = this.content.getEnterprise();
        coroutineScope2 = this.scope;
        image = (KFunction)new Function2<String, Integer, Unit>((Object)this.statisticsSink){

            public final void invoke(String p0, int p1) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                ((AiPromoWindowStatisticsSink)this.receiver).slideShown(p0, p1);
            }
        };
        JBFont jBFont5 = labelFont.asBold();
        Intrinsics.checkNotNullExpressionValue((Object)jBFont5, (String)"asBold(...)");
        kFunction = jBFont5;
        return animatedOptionChooser2.withOption(new SlideCarousel(list, coroutineScope2, null, (JBFont)kFunction, 0L, 0L, (Function2)image, 48, null), (Function0<Unit>)((Function0)() -> AiPromoWindow.createCenterPanel$lambda$27(this)), (Function2<? super AnimatedComponentBuilder, ? super ObservableBooleanProperty, ? extends JComponent>)((Function2)(arg_0, arg_1) -> AiPromoWindow.createCenterPanel$lambda$35(labelFont, this, arg_0, arg_1))).selectByDefault(this.content.getLocal().isEmpty() ? 0 : 1);
    }

    private static final void _init_$lambda$0(AiPromoWindow this$0) {
        kotlinx.coroutines.CoroutineScopeKt.cancel$default((CoroutineScope)this$0.scope, null, (int)1, null);
    }

    private static final void _init_$lambda$1(AiPromoWindow this$0) {
        if (this$0.getExitCode() == 1) {
            this$0.statisticsSink.windowClosed();
        }
        this$0.closed = true;
    }

    private static final Unit createCenterPanel$lambda$12$lambda$2(AiPromoWindow this$0) {
        this$0.statisticsSink.sectionSelected(AiPromoWindowStatistics.Section.Local);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit createCenterPanel$lambda$12$lambda$11$lambda$5$lambda$4(JBFont $labelFont, AnimatedComponentBuilder $this_withOption, ObservableBooleanProperty $isSelected, Row $this$row) {
        void $this$createCenterPanel_u24lambda_u2412_u24lambda_u2411_u24lambda_u245_u24lambda_u244_u24lambda_u243;
        Cell cell;
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        ((JLabel)$this$row.label(LLMInstallerBundle.INSTANCE.message("ai.promo.window.local.title", new Object[0])).getComponent()).setFont((Font)AiPromoWindowKt.access$h2($labelFont).asBold());
        Cell cell2 = cell = $this$row.label(LLMInstallerBundle.INSTANCE.message("ai.promo.window.local.status", new Object[0]));
        AnimatedComponentBuilder animatedComponentBuilder = $this_withOption;
        AnimatedComponentBuilder animatedComponentBuilder2 = $this_withOption;
        boolean bl = false;
        ((JLabel)$this$createCenterPanel_u24lambda_u2412_u24lambda_u2411_u24lambda_u245_u24lambda_u244_u24lambda_u243.getComponent()).setForeground(JBUI.CurrentTheme.RunWidget.RUNNING_BACKGROUND);
        ((JLabel)$this$createCenterPanel_u24lambda_u2412_u24lambda_u2411_u24lambda_u245_u24lambda_u244_u24lambda_u243.getComponent()).setIcon(AllIcons.General.GreenCheckmark);
        ((JLabel)$this$createCenterPanel_u24lambda_u2412_u24lambda_u2411_u24lambda_u245_u24lambda_u244_u24lambda_u243.getComponent()).setFont((Font)$labelFont);
        Unit unit = Unit.INSTANCE;
        animatedComponentBuilder2.fadeIcon(animatedComponentBuilder.fadeForeground(cell.align((Align)AlignX.RIGHT.INSTANCE))).visibleIf((ObservableProperty)$isSelected);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$12$lambda$11$lambda$5(AnimatedComponentBuilder $this_withOption, ObservableBooleanProperty $isSelected, JBFont $labelFont, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, arg_0 -> AiPromoWindow.createCenterPanel$lambda$12$lambda$11$lambda$5$lambda$4($labelFont, $this_withOption, $isSelected, arg_0), (int)1, null);
        Icon icon = LLMIcons.Promo.AiLocalCompletion;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"AiLocalCompletion");
        $this_withOption.rowWithIconAndText($this$panel, icon, LLMInstallerBundle.INSTANCE.message("ai.promo.window.local.completion.label", new Object[0])).visibleIf((ObservableProperty)$isSelected);
        Icon icon2 = LLMIcons.Promo.AiLocalDisconnected;
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"AiLocalDisconnected");
        $this_withOption.rowWithIconAndText($this$panel, icon2, LLMInstallerBundle.INSTANCE.message("ai.promo.window.local.disconnected.label", new Object[0])).visibleIf((ObservableProperty)$isSelected);
        Icon icon3 = LLMIcons.Promo.AiLocalLicensed;
        Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"AiLocalLicensed");
        $this_withOption.rowWithIconAndText($this$panel, icon3, LLMInstallerBundle.INSTANCE.message("ai.promo.window.local.licensed.label", new Object[0])).visibleIf((ObservableProperty)$isSelected);
        Icon icon4 = LLMIcons.Promo.AiLocalPrivacy;
        Intrinsics.checkNotNullExpressionValue((Object)icon4, (String)"AiLocalPrivacy");
        $this_withOption.rowWithIconAndText($this$panel, icon4, LLMInstallerBundle.INSTANCE.message("ai.promo.window.privacy.label", new Object[0])).visibleIf((ObservableProperty)$isSelected);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$12$lambda$11$lambda$9$lambda$8$lambda$6(AiPromoWindow this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.statisticsSink.buttonClicked(AiPromoWindowStatistics.SectionButtonType.LocalConfigure);
        ShowSettingsUtil.getInstance().showSettingsDialog(this$0.project, InlineCompletionConfigurable.class);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit createCenterPanel$lambda$12$lambda$11$lambda$9$lambda$8(AnimatedComponentBuilder $this_withOption, AiPromoWindow this$0, JBFont $labelFont, Row $this$row) {
        void $this$createCenterPanel_u24lambda_u2412_u24lambda_u2411_u24lambda_u249_u24lambda_u248_u24lambda_u247;
        Cell cell;
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Cell cell2 = cell = $this$row.button(LLMInstallerBundle.INSTANCE.message("ai.promo.window.local.configure.button", new Object[0]), arg_0 -> AiPromoWindow.createCenterPanel$lambda$12$lambda$11$lambda$9$lambda$8$lambda$6(this$0, arg_0));
        AnimatedComponentBuilder animatedComponentBuilder = $this_withOption;
        AnimatedComponentBuilder animatedComponentBuilder2 = $this_withOption;
        boolean bl = false;
        JButton jButton = (JButton)$this$createCenterPanel_u24lambda_u2412_u24lambda_u2411_u24lambda_u249_u24lambda_u248_u24lambda_u247.getComponent();
        Color color = (Color)DisclosureButtonUI.Companion.getDEFAULT_BACKGROUND$intellij_llmInstaller();
        Color color2 = UIUtil.getPanelBackground();
        Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"getPanelBackground(...)");
        jButton.putClientProperty("JButton.backgroundColor", ColorsKt.getOpaqueBackground(color, color2));
        ((JButton)$this$createCenterPanel_u24lambda_u2412_u24lambda_u2411_u24lambda_u249_u24lambda_u248_u24lambda_u247.getComponent()).putClientProperty("JButton.borderColor", JBUI.CurrentTheme.Button.buttonOutlineColorStart((boolean)false));
        ((JButton)$this$createCenterPanel_u24lambda_u2412_u24lambda_u2411_u24lambda_u249_u24lambda_u248_u24lambda_u247.getComponent()).setFont((Font)$labelFont);
        Unit unit = Unit.INSTANCE;
        animatedComponentBuilder2.focusedWhenSelected(animatedComponentBuilder.fadeButton(cell));
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$12$lambda$11$lambda$9(ObservableBooleanProperty $isSelected, AnimatedComponentBuilder $this_withOption, AiPromoWindow this$0, JBFont $labelFont, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, arg_0 -> AiPromoWindow.createCenterPanel$lambda$12$lambda$11$lambda$9$lambda$8($this_withOption, this$0, $labelFont, arg_0), (int)1, null).visibleIf((ObservableProperty)$isSelected);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$12$lambda$11$lambda$10(OptionPanel component2, float f) {
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        component2.animateDeselection(f);
        return Unit.INSTANCE;
    }

    private static final JComponent createCenterPanel$lambda$12$lambda$11(JBFont $labelFont, AiPromoWindow this$0, AnimatedComponentBuilder $this$withOption, ObservableBooleanProperty isSelected) {
        Intrinsics.checkNotNullParameter((Object)$this$withOption, (String)"$this$withOption");
        Intrinsics.checkNotNullParameter((Object)isSelected, (String)"isSelected");
        Color color = (Color)DisclosureButtonUI.Companion.getDEFAULT_BACKGROUND$intellij_llmInstaller();
        Color color2 = UIUtil.getPanelBackground();
        Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"getPanelBackground(...)");
        $this$withOption.setDeselectedBackground(ColorsKt.getOpaqueBackground(color, color2));
        $this$withOption.setRowFont($labelFont.lessOn(1.0f));
        return $this$withOption.animate((JComponent)new OptionPanel(isSelected, this$0.gradientImages.getLocal(), (JPanel)BuilderKt.panel(arg_0 -> AiPromoWindow.createCenterPanel$lambda$12$lambda$11$lambda$5($this$withOption, isSelected, $labelFont, arg_0)), (JPanel)BuilderKt.panel(arg_0 -> AiPromoWindow.createCenterPanel$lambda$12$lambda$11$lambda$9(isSelected, $this$withOption, this$0, $labelFont, arg_0)), (Color)new JBColor(ColorUtil.fromHex((String)"#57965C"), ColorUtil.fromHex((String)"#57965C"))), AiPromoWindow::createCenterPanel$lambda$12$lambda$11$lambda$10);
    }

    private static final Unit createCenterPanel$lambda$13(AiPromoWindow this$0) {
        this$0.statisticsSink.sectionSelected(AiPromoWindowStatistics.Section.Cloud);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit createCenterPanel$lambda$26$lambda$16$lambda$15(JBFont $labelFont, AnimatedComponentBuilder $this_withOption, ObservableBooleanProperty $isSelected, Row $this$row) {
        void $this$createCenterPanel_u24lambda_u2426_u24lambda_u2416_u24lambda_u2415_u24lambda_u2414;
        Cell cell;
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        ((JLabel)$this$row.label(LLMInstallerBundle.INSTANCE.message("ai.promo.window.cloud.title", new Object[0])).getComponent()).setFont((Font)AiPromoWindowKt.access$h2($labelFont).asBold());
        Cell cell2 = cell = $this$row.label(LLMInstallerBundle.INSTANCE.message("ai.promo.window.cloud.status", new Object[0]));
        AnimatedComponentBuilder animatedComponentBuilder = $this_withOption;
        boolean bl = false;
        ((JLabel)$this$createCenterPanel_u24lambda_u2426_u24lambda_u2416_u24lambda_u2415_u24lambda_u2414.getComponent()).setForeground(JBUI.CurrentTheme.Advertiser.foreground());
        ((JLabel)$this$createCenterPanel_u24lambda_u2426_u24lambda_u2416_u24lambda_u2415_u24lambda_u2414.getComponent()).setFont((Font)$labelFont);
        animatedComponentBuilder.fadeForeground(cell).align((Align)AlignX.RIGHT.INSTANCE).visibleIf((ObservableProperty)$isSelected);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$26$lambda$16(AnimatedComponentBuilder $this_withOption, ObservableBooleanProperty $isSelected, JBFont $labelFont, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, arg_0 -> AiPromoWindow.createCenterPanel$lambda$26$lambda$16$lambda$15($labelFont, $this_withOption, $isSelected, arg_0), (int)1, null);
        Icon icon = LLMIcons.Promo.AiCloudModels;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"AiCloudModels");
        $this_withOption.rowWithIconAndText($this$panel, icon, LLMInstallerBundle.INSTANCE.message("ai.promo.window.cloud.models.label", new Object[0])).visibleIf((ObservableProperty)$isSelected);
        Icon icon2 = LLMIcons.Promo.AiCloudFeatures;
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"AiCloudFeatures");
        $this_withOption.rowWithIconAndText($this$panel, icon2, LLMInstallerBundle.INSTANCE.message("ai.promo.window.cloud.features.label", new Object[0])).visibleIf((ObservableProperty)$isSelected);
        Icon icon3 = LLMIcons.Promo.AiCloudPrivacy;
        Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"AiCloudPrivacy");
        $this_withOption.rowWithIconAndText($this$panel, icon3, LLMInstallerBundle.INSTANCE.message("ai.promo.window.privacy.label", new Object[0])).visibleIf((ObservableProperty)$isSelected);
        return Unit.INSTANCE;
    }

    private static final void createCenterPanel$lambda$26$lambda$24$lambda$19$lambda$18$lambda$17(HyperlinkEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        BrowserUtil.browse((String)"https://www.jetbrains.com/legal/docs/terms/jetbrains-ai-service/");
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit createCenterPanel$lambda$26$lambda$24$lambda$19(AnimatedComponentBuilder $this_withOption, JBFont $labelFont, Row $this$row) {
        void $this$createCenterPanel_u24lambda_u2426_u24lambda_u2424_u24lambda_u2419_u24lambda_u2418;
        String[] stringArray;
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String[] stringArray2 = stringArray = $this$row.cell((JComponent)new CommentLabel(LLMInstallerBundle.INSTANCE.message("ai.promo.window.cloud.terms.comment", new Object[0]))).align((Align)AlignX.FILL.INSTANCE);
        AnimatedComponentBuilder animatedComponentBuilder = $this_withOption;
        AnimatedComponentBuilder animatedComponentBuilder2 = $this_withOption;
        boolean bl = false;
        ((CommentLabel)$this$createCenterPanel_u24lambda_u2426_u24lambda_u2424_u24lambda_u2419_u24lambda_u2418.getComponent()).putClientProperty("commentLabel.linkColor", JBUI.CurrentTheme.Link.Foreground.ENABLED);
        ((CommentLabel)$this$createCenterPanel_u24lambda_u2426_u24lambda_u2424_u24lambda_u2419_u24lambda_u2418.getComponent()).setAction(AiPromoWindow::createCenterPanel$lambda$26$lambda$24$lambda$19$lambda$18$lambda$17);
        ((CommentLabel)$this$createCenterPanel_u24lambda_u2426_u24lambda_u2424_u24lambda_u2419_u24lambda_u2418.getComponent()).setFont((Font)$labelFont.lessOn(1.0f));
        Unit unit = Unit.INSTANCE;
        Cell cell = animatedComponentBuilder.fadeForeground(stringArray);
        stringArray = new String[]{"commentLabel.linkColor"};
        animatedComponentBuilder2.fadeProperties(cell, stringArray);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$26$lambda$24$lambda$23$lambda$21$lambda$20(AiPromoWindow this$0) {
        this$0.close(0);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$26$lambda$24$lambda$23$lambda$21(AiPromoWindow this$0, AtomicBooleanProperty $activationStarted, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.statisticsSink.buttonClicked(AiPromoWindowStatistics.SectionButtonType.CloudEnable);
        $activationStarted.set(true);
        AiPromoWindowKt.access$installPluginFromButton(this$0.project, () -> AiPromoWindow.createCenterPanel$lambda$26$lambda$24$lambda$23$lambda$21$lambda$20(this$0));
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit createCenterPanel$lambda$26$lambda$24$lambda$23(AnimatedComponentBuilder $this_withOption, AiPromoWindow this$0, JBFont $labelFont, Row $this$row) {
        void $this$createCenterPanel_u24lambda_u2426_u24lambda_u2424_u24lambda_u2423_u24lambda_u2422;
        Cell cell;
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        AtomicBooleanProperty activationStarted = new AtomicBooleanProperty(false);
        Cell cell2 = cell = $this$row.button(LLMInstallerBundle.INSTANCE.message("ai.promo.window.cloud.enable.button", new Object[0]), arg_0 -> AiPromoWindow.createCenterPanel$lambda$26$lambda$24$lambda$23$lambda$21(this$0, activationStarted, arg_0));
        AnimatedComponentBuilder animatedComponentBuilder = $this_withOption;
        AnimatedComponentBuilder animatedComponentBuilder2 = $this_withOption;
        boolean bl = false;
        ((JButton)$this$createCenterPanel_u24lambda_u2426_u24lambda_u2424_u24lambda_u2423_u24lambda_u2422.getComponent()).putClientProperty("JButton.backgroundColor", EnableButtonColors.INSTANCE.getBackgroundColor());
        ((JButton)$this$createCenterPanel_u24lambda_u2426_u24lambda_u2424_u24lambda_u2423_u24lambda_u2422.getComponent()).setForeground(JBUI.CurrentTheme.Button.defaultButtonForeground());
        ((JButton)$this$createCenterPanel_u24lambda_u2426_u24lambda_u2424_u24lambda_u2423_u24lambda_u2422.getComponent()).putClientProperty("JButton.borderColor", EnableButtonColors.INSTANCE.getBorderColor());
        ((JButton)$this$createCenterPanel_u24lambda_u2426_u24lambda_u2424_u24lambda_u2423_u24lambda_u2422.getComponent()).setFont((Font)$labelFont);
        Unit unit = Unit.INSTANCE;
        animatedComponentBuilder2.focusedWhenSelected(animatedComponentBuilder.fadeButton(cell)).enabledIf(PropertyOperationUtil.not((ObservableProperty)((ObservableProperty)activationStarted)));
        AnimatedIcon animatedIcon = AnimatedIcon.Default.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)animatedIcon, (String)"INSTANCE");
        $this$row.icon((Icon)animatedIcon).visibleIf((ObservableProperty)activationStarted);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$26$lambda$24(ObservableBooleanProperty $isSelected, AnimatedComponentBuilder $this_withOption, JBFont $labelFont, AiPromoWindow this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, arg_0 -> AiPromoWindow.createCenterPanel$lambda$26$lambda$24$lambda$19($this_withOption, $labelFont, arg_0), (int)1, null).visibleIf((ObservableProperty)$isSelected);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> AiPromoWindow.createCenterPanel$lambda$26$lambda$24$lambda$23($this_withOption, this$0, $labelFont, arg_0), (int)1, null).visibleIf((ObservableProperty)$isSelected);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$26$lambda$25(OptionPanel component2, float t) {
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        component2.animateDeselection(t);
        return Unit.INSTANCE;
    }

    private static final JComponent createCenterPanel$lambda$26(JBFont $labelFont, AiPromoWindow this$0, AnimatedComponentBuilder $this$withOption, ObservableBooleanProperty isSelected) {
        Intrinsics.checkNotNullParameter((Object)$this$withOption, (String)"$this$withOption");
        Intrinsics.checkNotNullParameter((Object)isSelected, (String)"isSelected");
        Color color = (Color)DisclosureButtonUI.Companion.getDEFAULT_BACKGROUND$intellij_llmInstaller();
        Color color2 = UIUtil.getPanelBackground();
        Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"getPanelBackground(...)");
        $this$withOption.setDeselectedBackground(ColorsKt.getOpaqueBackground(color, color2));
        $this$withOption.setRowFont($labelFont.lessOn(1.0f));
        return $this$withOption.animate((JComponent)new OptionPanel(isSelected, this$0.gradientImages.getCloud(), (JPanel)BuilderKt.panel(arg_0 -> AiPromoWindow.createCenterPanel$lambda$26$lambda$16($this$withOption, isSelected, $labelFont, arg_0)), (JPanel)BuilderKt.panel(arg_0 -> AiPromoWindow.createCenterPanel$lambda$26$lambda$24(isSelected, $this$withOption, $labelFont, this$0, arg_0)), (Color)new JBColor(ColorUtil.fromHex((String)"#465FF3"), ColorUtil.fromHex((String)"#465FF3"))), AiPromoWindow::createCenterPanel$lambda$26$lambda$25);
    }

    private static final Unit createCenterPanel$lambda$27(AiPromoWindow this$0) {
        this$0.statisticsSink.sectionSelected(AiPromoWindowStatistics.Section.Enterprise);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$35$lambda$29$lambda$28(JBFont $labelFont, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        ((JLabel)$this$row.label(LLMInstallerBundle.INSTANCE.message("ai.promo.window.enterprise.title", new Object[0])).getComponent()).setFont((Font)AiPromoWindowKt.access$h2($labelFont).asBold());
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$35$lambda$29(AnimatedComponentBuilder $this_withOption, ObservableBooleanProperty $isSelected, JBFont $labelFont, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, arg_0 -> AiPromoWindow.createCenterPanel$lambda$35$lambda$29$lambda$28($labelFont, arg_0), (int)1, null);
        Icon icon = LLMIcons.Promo.AiEnterpriseModels;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"AiEnterpriseModels");
        $this_withOption.rowWithIconAndText($this$panel, icon, LLMInstallerBundle.INSTANCE.message("ai.promo.window.enterprise.models.label", new Object[0])).visibleIf((ObservableProperty)$isSelected);
        Icon icon2 = LLMIcons.Promo.AiEnterpriseOrg;
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"AiEnterpriseOrg");
        $this_withOption.rowWithIconAndText($this$panel, icon2, LLMInstallerBundle.INSTANCE.message("ai.promo.window.enterprise.organization.label", new Object[0])).visibleIf((ObservableProperty)$isSelected);
        Icon icon3 = LLMIcons.Promo.AiEnterprisePrivacy;
        Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"AiEnterprisePrivacy");
        $this_withOption.rowWithIconAndText($this$panel, icon3, LLMInstallerBundle.INSTANCE.message("ai.promo.window.enterprise.privacy.label", new Object[0])).visibleIf((ObservableProperty)$isSelected);
        Icon icon4 = LLMIcons.Promo.AiEnterpriseZdr;
        Intrinsics.checkNotNullExpressionValue((Object)icon4, (String)"AiEnterpriseZdr");
        $this_withOption.rowWithIconAndText($this$panel, icon4, LLMInstallerBundle.INSTANCE.message("ai.promo.window.enterprise.zdr.label", new Object[0])).visibleIf((ObservableProperty)$isSelected);
        Icon icon5 = LLMIcons.Promo.AiEnterpriseLicensed;
        Intrinsics.checkNotNullExpressionValue((Object)icon5, (String)"AiEnterpriseLicensed");
        $this_withOption.rowWithIconAndText($this$panel, icon5, LLMInstallerBundle.INSTANCE.message("ai.promo.window.enterprise.liability.label", new Object[0])).visibleIf((ObservableProperty)$isSelected);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$35$lambda$33$lambda$32$lambda$30(AiPromoWindow this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.statisticsSink.buttonClicked(AiPromoWindowStatistics.SectionButtonType.EnterpriseLearnMore);
        BrowserUtil.browse((String)"https://www.jetbrains.com/ai/enterprise/");
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit createCenterPanel$lambda$35$lambda$33$lambda$32(AnimatedComponentBuilder $this_withOption, AiPromoWindow this$0, JBFont $labelFont, Row $this$row) {
        void $this$createCenterPanel_u24lambda_u2435_u24lambda_u2433_u24lambda_u2432_u24lambda_u2431;
        Cell cell;
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Cell cell2 = cell = $this$row.button(LLMInstallerBundle.INSTANCE.message("ai.promo.window.enterprise.more.button", new Object[0]), arg_0 -> AiPromoWindow.createCenterPanel$lambda$35$lambda$33$lambda$32$lambda$30(this$0, arg_0));
        AnimatedComponentBuilder animatedComponentBuilder = $this_withOption;
        AnimatedComponentBuilder animatedComponentBuilder2 = $this_withOption;
        boolean bl = false;
        JButton jButton = (JButton)$this$createCenterPanel_u24lambda_u2435_u24lambda_u2433_u24lambda_u2432_u24lambda_u2431.getComponent();
        Color color = (Color)DisclosureButtonUI.Companion.getDEFAULT_BACKGROUND$intellij_llmInstaller();
        Color color2 = UIUtil.getPanelBackground();
        Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"getPanelBackground(...)");
        jButton.putClientProperty("JButton.backgroundColor", ColorsKt.getOpaqueBackground(color, color2));
        ((JButton)$this$createCenterPanel_u24lambda_u2435_u24lambda_u2433_u24lambda_u2432_u24lambda_u2431.getComponent()).putClientProperty("JButton.borderColor", JBUI.CurrentTheme.Button.buttonOutlineColorStart((boolean)false));
        ((JButton)$this$createCenterPanel_u24lambda_u2435_u24lambda_u2433_u24lambda_u2432_u24lambda_u2431.getComponent()).setFont((Font)$labelFont);
        Unit unit = Unit.INSTANCE;
        animatedComponentBuilder2.focusedWhenSelected(animatedComponentBuilder.fadeButton(cell));
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$35$lambda$33(ObservableBooleanProperty $isSelected, AnimatedComponentBuilder $this_withOption, AiPromoWindow this$0, JBFont $labelFont, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, arg_0 -> AiPromoWindow.createCenterPanel$lambda$35$lambda$33$lambda$32($this_withOption, this$0, $labelFont, arg_0), (int)1, null).visibleIf((ObservableProperty)$isSelected);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$35$lambda$34(OptionPanel component2, float t) {
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        component2.animateDeselection(t);
        return Unit.INSTANCE;
    }

    private static final JComponent createCenterPanel$lambda$35(JBFont $labelFont, AiPromoWindow this$0, AnimatedComponentBuilder $this$withOption, ObservableBooleanProperty isSelected) {
        Intrinsics.checkNotNullParameter((Object)$this$withOption, (String)"$this$withOption");
        Intrinsics.checkNotNullParameter((Object)isSelected, (String)"isSelected");
        Color color = (Color)DisclosureButtonUI.Companion.getDEFAULT_BACKGROUND$intellij_llmInstaller();
        Color color2 = UIUtil.getPanelBackground();
        Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"getPanelBackground(...)");
        $this$withOption.setDeselectedBackground(ColorsKt.getOpaqueBackground(color, color2));
        $this$withOption.setRowFont($labelFont.lessOn(1.0f));
        return $this$withOption.animate((JComponent)new OptionPanel(isSelected, this$0.gradientImages.getCloud(), (JPanel)BuilderKt.panel(arg_0 -> AiPromoWindow.createCenterPanel$lambda$35$lambda$29($this$withOption, isSelected, $labelFont, arg_0)), (JPanel)BuilderKt.panel(arg_0 -> AiPromoWindow.createCenterPanel$lambda$35$lambda$33(isSelected, $this$withOption, this$0, $labelFont, arg_0)), (Color)new JBColor(ColorUtil.fromHex((String)"#465FF3"), ColorUtil.fromHex((String)"#465FF3"))), AiPromoWindow::createCenterPanel$lambda$35$lambda$34);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\u00060\u0001j\u0002`\u0002B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lcom/intellij/llmInstaller/ui/promo/AiPromoWindow$ContentDoesntFitOnScreenException;", "Ljava/lang/RuntimeException;", "Lkotlin/RuntimeException;", "<init>", "()V", "intellij.llmInstaller"})
    private static final class ContentDoesntFitOnScreenException
    extends RuntimeException {
        @NotNull
        public static final ContentDoesntFitOnScreenException INSTANCE = new ContentDoesntFitOnScreenException();

        private ContentDoesntFitOnScreenException() {
        }
    }
}

