/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.html;

import com.vladsch.flexmark.util.html.Attribute;
import com.vladsch.flexmark.util.html.MutableAttribute;
import com.vladsch.flexmark.util.html.MutableAttributeImpl;
import com.vladsch.flexmark.util.sequence.BasedSequence;

public class AttributeImpl
implements Attribute {
    private final String name;
    private final char valueListDelimiter;
    private final char valueNameDelimiter;
    private final String value;

    private AttributeImpl(CharSequence name, CharSequence value2, char valueListDelimiter, char valueNameDelimiter) {
        this.name = String.valueOf(name);
        this.valueListDelimiter = valueListDelimiter;
        this.valueNameDelimiter = valueNameDelimiter;
        this.value = value2 == null ? "" : String.valueOf(value2);
    }

    @Override
    public MutableAttribute toMutable() {
        return MutableAttributeImpl.of(this);
    }

    @Override
    public char getValueListDelimiter() {
        return this.valueListDelimiter;
    }

    @Override
    public char getValueNameDelimiter() {
        return this.valueNameDelimiter;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public boolean isNonRendering() {
        return this.name.indexOf(32) != -1 || this.value.isEmpty() && NON_RENDERING_WHEN_EMPTY.contains(this.name);
    }

    public static int indexOfValue(CharSequence value2, CharSequence valueName, char valueListDelimiter, char valueNameDelimiter) {
        int pos;
        if (valueName.length() == 0 || value2.length() == 0) {
            return -1;
        }
        if (valueListDelimiter == '\u0000') {
            return value2.equals(valueName) ? 0 : -1;
        }
        int lastPos = 0;
        BasedSequence subSeq = BasedSequence.of(value2);
        while (lastPos < value2.length() && (pos = subSeq.indexOf(valueName, lastPos)) != -1) {
            int endPos = pos + valueName.length();
            if ((pos == 0 || value2.charAt(pos - 1) == valueListDelimiter || valueNameDelimiter != '\u0000' && value2.charAt(pos - 1) == valueNameDelimiter) && (endPos >= value2.length() || value2.charAt(endPos) == valueListDelimiter || valueNameDelimiter != '\u0000' && value2.charAt(endPos) == valueNameDelimiter)) {
                return pos;
            }
            lastPos = endPos + 1;
        }
        return -1;
    }

    @Override
    public boolean containsValue(CharSequence value2) {
        return AttributeImpl.indexOfValue(this.value, value2, this.valueListDelimiter, this.valueNameDelimiter) != -1;
    }

    @Override
    public Attribute replaceValue(CharSequence value2) {
        return value2.equals(this.value) ? this : AttributeImpl.of(this.name, value2, this.valueListDelimiter, this.valueNameDelimiter);
    }

    @Override
    public Attribute setValue(CharSequence value2) {
        MutableAttribute mutable = this.toMutable().setValue(value2);
        return mutable.equals(this) ? this : (Attribute)mutable.toImmutable();
    }

    @Override
    public Attribute removeValue(CharSequence value2) {
        MutableAttribute mutable = this.toMutable().removeValue(value2);
        return mutable.equals(this) ? this : (Attribute)mutable.toImmutable();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Attribute)) {
            return false;
        }
        Attribute attribute = (Attribute)o;
        if (!this.name.equals(attribute.getName())) {
            return false;
        }
        return this.value.equals(attribute.getValue());
    }

    public int hashCode() {
        int result2 = this.name.hashCode();
        result2 = 31 * result2 + this.value.hashCode();
        return result2;
    }

    public String toString() {
        return "AttributeImpl { name='" + this.name + "', value='" + this.value + "' }";
    }

    public static AttributeImpl of(Attribute other) {
        return AttributeImpl.of(other.getName(), other.getValue(), other.getValueListDelimiter(), other.getValueNameDelimiter());
    }

    public static AttributeImpl of(CharSequence attrName) {
        return AttributeImpl.of(attrName, attrName, '\u0000', '\u0000');
    }

    public static AttributeImpl of(CharSequence attrName, CharSequence value2) {
        return AttributeImpl.of(attrName, value2, '\u0000', '\u0000');
    }

    public static AttributeImpl of(CharSequence attrName, CharSequence value2, char valueListDelimiter) {
        return AttributeImpl.of(attrName, value2, valueListDelimiter, '\u0000');
    }

    public static AttributeImpl of(CharSequence attrName, CharSequence value2, char valueListDelimiter, char valueNameDelimiter) {
        if (attrName.equals("class")) {
            return new AttributeImpl(attrName, value2, ' ', '\u0000');
        }
        if (attrName.equals("style")) {
            return new AttributeImpl(attrName, value2, ';', ':');
        }
        return new AttributeImpl(attrName, value2, valueListDelimiter, valueNameDelimiter);
    }
}

