/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.staticAnalysis.inspections.runner;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.qodana.staticAnalysis.EnvKt;
import org.jetbrains.qodana.staticAnalysis.inspections.runner.OutputFormat;
import org.jetbrains.qodana.staticAnalysis.inspections.runner.QodanaException;
import org.jetbrains.qodana.staticAnalysis.stat.UsageCollector;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u0010\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\b\u0010\u0006\u001a\u00020\u0003H\u0000\u001a\b\u0010\u0007\u001a\u00020\u0001H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\b"}, d2={"QODANA_FORMAT", "", "DEFAULT_OUTPUT_FORMAT", "Lorg/jetbrains/qodana/staticAnalysis/inspections/runner/OutputFormat;", "getDEFAULT_OUTPUT_FORMAT", "()Lorg/jetbrains/qodana/staticAnalysis/inspections/runner/OutputFormat;", "getOutputFormat", "getOutputFormatName", "intellij.qodana"})
public final class OutputFormatKt {
    @NotNull
    public static final String QODANA_FORMAT = "qodana.format";
    @NotNull
    private static final OutputFormat DEFAULT_OUTPUT_FORMAT = OutputFormat.SARIF_AND_PROJECT_STRUCTURE;

    @NotNull
    public static final OutputFormat getDEFAULT_OUTPUT_FORMAT() {
        return DEFAULT_OUTPUT_FORMAT;
    }

    @NotNull
    public static final OutputFormat getOutputFormat() {
        String formatName = OutputFormatKt.getOutputFormatName();
        try {
            return OutputFormat.valueOf(formatName);
        }
        catch (IllegalArgumentException e) {
            String validValues = ArraysKt.joinToString$default((Object[])OutputFormat.values(), null, null, null, (int)0, null, OutputFormatKt::getOutputFormat$lambda$0, (int)31, null);
            throw new QodanaException("Invalid format '" + formatName + "' in system property 'qodana.format'. Valid values are " + validValues + ".");
        }
    }

    private static final String getOutputFormatName() {
        UsageCollector.Environment environment2;
        String formatName = System.getProperties().getProperty(QODANA_FORMAT);
        if (formatName != null) {
            return formatName;
        }
        String string = EnvKt.qodanaEnv().getQODANA_ENV().getValue();
        if (string == null) {
            string = "";
        }
        return Intrinsics.areEqual((Object)(environment2 = UsageCollector.INSTANCE.splitEnv$intellij_qodana(string)).getSystem(), (Object)"teamcity") ? "INSPECT_SH_FORMAT" : DEFAULT_OUTPUT_FORMAT.name();
    }

    private static final CharSequence getOutputFormat$lambda$0(OutputFormat it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        return "'" + it + "'";
    }
}

