/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.ui;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColorUtil;
import com.jetbrains.rd.ide.model.AbstractColor;
import com.jetbrains.rd.ide.model.EffectStyle;
import com.jetbrains.rd.ide.model.FontStyle;
import com.jetbrains.rd.ide.model.RgbColor;
import com.jetbrains.rd.ide.model.RichStringModel;
import com.jetbrains.rd.ide.model.RichTextBlockModel;
import com.jetbrains.rd.ide.model.RichTextModel;
import com.jetbrains.rd.platform.colors.ColorHostKt;
import com.jetbrains.rd.ui.util.ColorUtilsKt;
import java.awt.Color;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\f\u0010\u0003\u001a\u00020\u0004*\u00020\u0005H\u0007\u001a \u0010\u0006\u001a\u0018\u0012\t\u0012\u00070\u0004\u00a2\u0006\u0002\b\b\u0012\t\u0012\u00070\u0004\u00a2\u0006\u0002\b\b0\u0007*\u00020\u0005\u001a\u001e\u0010\t\u001a\u00020\n*\u00020\u00052\n\u0010\u000b\u001a\u00060\fj\u0002`\r2\u0006\u0010\u000e\u001a\u00020\u000f\u001a\u001e\u0010\t\u001a\u00020\n*\u00020\u00102\n\u0010\u000b\u001a\u00060\fj\u0002`\r2\u0006\u0010\u000e\u001a\u00020\u000f\u001a\u0012\u0010\t\u001a\u00020\u0004*\u00020\u00102\u0006\u0010\u000e\u001a\u00020\u000f\u00a8\u0006\u0011"}, d2={"isGrayed", "", "Lcom/jetbrains/rd/ide/model/RgbColor;", "toSimpleText", "", "Lcom/jetbrains/rd/ide/model/RichTextModel;", "splitByGrayColor", "Lkotlin/Pair;", "Lorg/jetbrains/annotations/Nls;", "toHtml", "", "stringBuilder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "bgColor", "Ljava/awt/Color;", "Lcom/jetbrains/rd/ide/model/RichTextBlockModel;", "intellij.rd.ui"})
public final class ProtocolUIKt {
    public static final boolean isGrayed(@NotNull RgbColor $this$isGrayed) {
        Intrinsics.checkNotNullParameter((Object)$this$isGrayed, (String)"<this>");
        return $this$isGrayed.getRed() == $this$isGrayed.getGreen() && $this$isGrayed.getGreen() == $this$isGrayed.getBlue() && $this$isGrayed.getRed() < 255 && $this$isGrayed.getRed() > 0;
    }

    @Nls
    @NotNull
    public static final String toSimpleText(@NotNull RichTextModel $this$toSimpleText) {
        Intrinsics.checkNotNullParameter((Object)$this$toSimpleText, (String)"<this>");
        return CollectionsKt.joinToString$default((Iterable)$this$toSimpleText.getParts(), (CharSequence)"", null, null, (int)0, null, ProtocolUIKt::toSimpleText$lambda$0, (int)30, null);
    }

    @NotNull
    public static final Pair<String, String> splitByGrayColor(@NotNull RichTextModel $this$splitByGrayColor) {
        Intrinsics.checkNotNullParameter((Object)$this$splitByGrayColor, (String)"<this>");
        StringBuilder appender = new StringBuilder();
        StringBuilder grayBuilder = new StringBuilder();
        for (RichStringModel part : $this$splitByGrayColor.getParts()) {
            StringBuilder stringBuilder;
            RgbColor foregroundColor;
            AbstractColor abstractColor = part.getForegroundColor();
            RgbColor rgbColor = foregroundColor = abstractColor instanceof RgbColor ? (RgbColor)abstractColor : null;
            if (foregroundColor != null && ProtocolUIKt.isGrayed(foregroundColor)) {
                stringBuilder = grayBuilder.append(part.getText());
                continue;
            }
            if (((CharSequence)grayBuilder).length() > 0) {
                return new Pair((Object)ProtocolUIKt.toSimpleText($this$splitByGrayColor), (Object)"");
            }
            stringBuilder = appender.append(part.getText());
        }
        return new Pair((Object)appender.toString(), (Object)grayBuilder.toString());
    }

    public static final void toHtml(@NotNull RichTextModel $this$toHtml, @NotNull StringBuilder stringBuilder, @NotNull Color bgColor) {
        Intrinsics.checkNotNullParameter((Object)$this$toHtml, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)stringBuilder, (String)"stringBuilder");
        Intrinsics.checkNotNullParameter((Object)bgColor, (String)"bgColor");
        for (RichStringModel part : $this$toHtml.getParts()) {
            FontStyle fs;
            EffectStyle effectStyle;
            Color fgColor;
            stringBuilder.append("<span style=\"");
            stringBuilder.append("background-color:").append(ColorUtil.toHtmlColor((Color)bgColor)).append(";");
            AbstractColor abstractColor = part.getForegroundColor();
            Color color = fgColor = abstractColor != null ? ColorHostKt.toColor(abstractColor) : null;
            if (fgColor != null) {
                Color contrastedFgColor = ColorUtilsKt.getContrastedForegroundIfNotThemed(bgColor, fgColor, true);
                stringBuilder.append("color:").append(ColorUtil.toHtmlColor((Color)contrastedFgColor)).append(';');
            }
            if ((effectStyle = part.getEffectStyle()) != EffectStyle.None) {
                switch (WhenMappings.$EnumSwitchMapping$0[effectStyle.ordinal()]) {
                    case 1: {
                        StringBuilder stringBuilder2 = stringBuilder.append("text-decoration: underline;");
                        break;
                    }
                    case 2: {
                        StringBuilder stringBuilder2 = stringBuilder.append("text-decoration: underline;");
                        break;
                    }
                    case 3: {
                        StringBuilder stringBuilder2 = stringBuilder.append("text-decoration: line-through;");
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException(effectStyle + " is unsupported effect.");
                    }
                }
            }
            if ((fs = part.getFontStyle()) != FontStyle.Regular) {
                if (fs == FontStyle.Bold) {
                    stringBuilder.append("font-weight: bold;");
                }
                if (fs == FontStyle.Italic) {
                    stringBuilder.append("font-style: italic;");
                }
                if (fs == FontStyle.Strikeout) {
                    stringBuilder.append("text-decoration: line-through;");
                }
                if (fs == FontStyle.Underline) {
                    stringBuilder.append("text-decoration: underline;");
                }
            }
            stringBuilder.append("\">").append(StringUtil.escapeXmlEntities((String)part.getText())).append("</span>");
        }
    }

    public static final void toHtml(@NotNull RichTextBlockModel $this$toHtml, @NotNull StringBuilder stringBuilder, @NotNull Color bgColor) {
        Intrinsics.checkNotNullParameter((Object)$this$toHtml, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)stringBuilder, (String)"stringBuilder");
        Intrinsics.checkNotNullParameter((Object)bgColor, (String)"bgColor");
        Iterator iterator = ((Iterable)$this$toHtml.getLines()).iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int i2 = n++;
            RichTextModel line = (RichTextModel)iterator.next();
            boolean bl = 1 <= i2 ? i2 < $this$toHtml.getLines().size() : false;
            if (bl) {
                stringBuilder.append("<br/>");
            }
            ProtocolUIKt.toHtml(line, stringBuilder, bgColor);
        }
    }

    @NotNull
    public static final String toHtml(@NotNull RichTextBlockModel $this$toHtml, @NotNull Color bgColor) {
        Intrinsics.checkNotNullParameter((Object)$this$toHtml, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)bgColor, (String)"bgColor");
        StringBuilder builder = new StringBuilder();
        ProtocolUIKt.toHtml($this$toHtml, builder, bgColor);
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private static final CharSequence toSimpleText$lambda$0(RichStringModel it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getText();
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[EffectStyle.values().length];
            try {
                nArray[EffectStyle.StraightUnderline.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EffectStyle.WeavyUnderline.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EffectStyle.StrikeOut.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

