/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.java.jdk;

import com.intellij.codeWithMe.ClientId;
import com.intellij.indexing.shared.download.SharedIndexId;
import com.intellij.indexing.shared.java.jdk.JdkIndexLookupRequest;
import com.intellij.indexing.shared.java.jdk.SharedJdkChunkStore;
import com.intellij.indexing.shared.java.jdk.SharedJdkIndexChunkLocatorKt;
import com.intellij.indexing.shared.java.jdk.SharedJdkIndexSuggestion;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkInstallRequest;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.io.DigestUtil;
import com.intellij.util.io.DigestUtilKt;
import java.security.MessageDigest;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000/\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003*\u0001\u0006\u001a\b\u0010\u0000\u001a\u00020\u0001H\u0002\u001a\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u001d\u0010\u0002\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u00a2\u0006\u0002\u0010\u000b\u001a\u000e\u0010\f\u001a\u0004\u0018\u00010\n*\u00020\rH\u0002\u001a\u000e\u0010\f\u001a\u0004\u0018\u00010\n*\u00020\u0005H\u0002\u001a\u001c\u0010\f\u001a\u00020\n2\b\u0010\u000e\u001a\u0004\u0018\u00010\b2\b\u0010\u000f\u001a\u0004\u0018\u00010\bH\u0002\u00a8\u0006\u0010"}, d2={"isEnabled", "", "newJdkSuggestion", "Lcom/intellij/indexing/shared/java/jdk/SharedJdkIndexSuggestion;", "jdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "com/intellij/indexing/shared/java/jdk/SharedJdkIndexChunkLocatorKt$newJdkSuggestion$1", "jdkName", "", "id", "Lcom/intellij/indexing/shared/download/SharedIndexId;", "(Ljava/lang/String;Lcom/intellij/indexing/shared/download/SharedIndexId;)Lcom/intellij/indexing/shared/java/jdk/SharedJdkIndexChunkLocatorKt$newJdkSuggestion$1;", "toSharedIndexId", "Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkInstallRequest;", "homePath", "versionString", "intellij.indexing.shared.java"})
@SourceDebugExtension(value={"SMAP\nSharedJdkIndexChunkLocator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SharedJdkIndexChunkLocator.kt\ncom/intellij/indexing/shared/java/jdk/SharedJdkIndexChunkLocatorKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,183:1\n1#2:184\n*E\n"})
public final class SharedJdkIndexChunkLocatorKt {
    private static final boolean isEnabled() {
        return !ApplicationManager.getApplication().isUnitTestMode() && Registry.Companion.is("shared.indexes.download") && Registry.Companion.is("shared.indexes.jdk.download");
    }

    @Nullable
    public static final SharedJdkIndexSuggestion newJdkSuggestion(@NotNull Sdk jdk) {
        Intrinsics.checkNotNullParameter((Object)jdk, (String)"jdk");
        String string = jdk.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String jdkName = string;
        SharedIndexId sharedIndexId = SharedJdkIndexChunkLocatorKt.toSharedIndexId(jdk);
        if (sharedIndexId == null) {
            return null;
        }
        SharedIndexId id = sharedIndexId;
        return SharedJdkIndexChunkLocatorKt.newJdkSuggestion(jdkName, id);
    }

    private static final newJdkSuggestion.1 newJdkSuggestion(String jdkName, SharedIndexId id) {
        return new SharedJdkIndexSuggestion(jdkName, id){
            private final String sdkName;
            private final SharedIndexId sharedIndexId;
            final /* synthetic */ String $jdkName;
            final /* synthetic */ SharedIndexId $id;
            {
                this.$jdkName = $jdkName;
                this.$id = $id;
                this.sdkName = $jdkName;
                this.sharedIndexId = $id;
            }

            public String getSdkName() {
                return this.sdkName;
            }

            public SharedIndexId getSharedIndexId() {
                return this.sharedIndexId;
            }

            public JdkIndexLookupRequest resolveRequest(ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                Sdk sdk = ProjectJdkTable.getInstance().findJdk(this.$jdkName);
                if (sdk == null) {
                    return null;
                }
                Sdk jdk = sdk;
                boolean $i$f$service = false;
                Class<SharedJdkChunkStore> serviceClass$iv = SharedJdkChunkStore.class;
                Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
                if (object == null) {
                    throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
                }
                return ((SharedJdkChunkStore)((Object)object)).getOrComputeJdkRequest(jdk);
            }

            public String toString() {
                return "JdkSharedIndexSuggestion(" + this.$id + ", lazy)";
            }
        };
    }

    private static final SharedIndexId toSharedIndexId(JdkInstallRequest $this$toSharedIndexId) {
        Object object;
        Object object2 = $this$toSharedIndexId;
        try {
            JdkInstallRequest $this$toSharedIndexId_u24lambda_u240 = object2;
            boolean bl = false;
            object = Result.constructor-impl((Object)SharedJdkIndexChunkLocatorKt.toSharedIndexId(((Object)$this$toSharedIndexId_u24lambda_u240.getInstallDir()).toString(), $this$toSharedIndexId_u24lambda_u240.getItem().getVersionString()));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        object2 = object;
        return (SharedIndexId)(Result.isFailure-impl((Object)object2) ? null : object2);
    }

    private static final SharedIndexId toSharedIndexId(Sdk $this$toSharedIndexId) {
        Object object;
        Object object2 = $this$toSharedIndexId;
        try {
            Object object3;
            Sdk $this$toSharedIndexId_u24lambda_u242 = object2;
            boolean bl = false;
            Object object4 = $this$toSharedIndexId_u24lambda_u242;
            String string = $this$toSharedIndexId_u24lambda_u242.getHomePath();
            try {
                Sdk $this$toSharedIndexId_u24lambda_u242_u24lambda_u241 = object4;
                boolean bl2 = false;
                object3 = Result.constructor-impl((Object)$this$toSharedIndexId_u24lambda_u242_u24lambda_u241.getVersionString());
            }
            catch (Throwable throwable) {
                object3 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            object4 = object3;
            object = Result.constructor-impl((Object)SharedJdkIndexChunkLocatorKt.toSharedIndexId(string, (String)(Result.isFailure-impl((Object)object4) ? null : object4)));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        object2 = object;
        return (SharedIndexId)(Result.isFailure-impl((Object)object2) ? null : object2);
    }

    private static final SharedIndexId toSharedIndexId(String homePath, String versionString) {
        String string;
        block5: {
            block4: {
                string = homePath;
                if (string == null) break block4;
                String it = string;
                boolean bl = false;
                String string2 = FileUtil.toSystemIndependentName((String)it);
                string = string2;
                if (string2 != null) break block5;
            }
            string = "no home path";
        }
        String string3 = DigestUtilKt.hashToHexString((String)string, (MessageDigest)DigestUtil.sha256());
        String string4 = versionString;
        if (string4 == null) {
            string4 = "no version";
        }
        String indexId = string3 + "#" + string4;
        return new SharedIndexId("jdk", JdkIndexLookupRequest.Companion.getBaseJdkUrl(), indexId);
    }

    public static final /* synthetic */ SharedIndexId access$toSharedIndexId(JdkInstallRequest $receiver) {
        return SharedJdkIndexChunkLocatorKt.toSharedIndexId($receiver);
    }

    public static final /* synthetic */ boolean access$isEnabled() {
        return SharedJdkIndexChunkLocatorKt.isEnabled();
    }
}

