/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.platform.impl;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.RemovalCause;
import com.intellij.indexing.shared.platform.impl.FileContentHashIndexExtension;
import com.intellij.indexing.shared.platform.impl.HashIndexKey;
import com.intellij.indexing.shared.platform.impl.SharedIndexChunkConfigurationImpl;
import com.intellij.indexing.shared.platform.impl.SharedIndexInfrastructure;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.ByteArraySequence;
import com.intellij.openapi.vfs.newvfs.AttributeOutputStream;
import com.intellij.openapi.vfs.newvfs.persistent.FSRecords;
import com.intellij.util.SystemProperties;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import com.intellij.util.indexing.impl.forward.AbstractForwardIndexAccessor;
import com.intellij.util.indexing.impl.forward.ForwardIndex;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.MeasurableIndexStore;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterable;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.ExecutorsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u0000 \u00172\u00020\u00012\u00020\u0002:\u0005\u0017\u0018\u0019\u001a\u001bB\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\nH\u0016J\b\u0010\u000e\u001a\u00020\fH\u0016J\b\u0010\u000f\u001a\u00020\nH\u0016J\u001a\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016J\u0013\u0010\u0015\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0011\u001a\u00020\u0012H\u0096\u0002J\b\u0010\u0016\u001a\u00020\u0012H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/indexing/shared/platform/impl/AttrBasedFileContentHashForwardIndex;", "Lcom/intellij/util/indexing/impl/forward/ForwardIndex;", "Lcom/intellij/util/io/MeasurableIndexStore;", "hashIndexId", "Lcom/intellij/indexing/shared/platform/impl/HashIndexKey;", "<init>", "(Lcom/intellij/indexing/shared/platform/impl/HashIndexKey;)V", "indexVersion", "Ljava/util/concurrent/atomic/AtomicInteger;", "close", "", "isClosed", "", "force", "isDirty", "clear", "put", "fileId", "", "value", "Lcom/intellij/openapi/util/io/ByteArraySequence;", "get", "keysCountApproximately", "Companion", "IndexData", "MultiHashes", "MultiHashesExternalizer", "ReindexCountFile", "intellij.indexing.shared"})
@SourceDebugExtension(value={"SMAP\nAttrBasedFileContentHashForwardIndex.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AttrBasedFileContentHashForwardIndex.kt\ncom/intellij/indexing/shared/platform/impl/AttrBasedFileContentHashForwardIndex\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,395:1\n1755#2,3:396\n14#3:399\n*S KotlinDebug\n*F\n+ 1 AttrBasedFileContentHashForwardIndex.kt\ncom/intellij/indexing/shared/platform/impl/AttrBasedFileContentHashForwardIndex\n*L\n361#1:396,3\n69#1:399\n*E\n"})
public final class AttrBasedFileContentHashForwardIndex
implements ForwardIndex,
MeasurableIndexStore {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final HashIndexKey hashIndexId;
    @NotNull
    private volatile AtomicInteger indexVersion;
    @NotNull
    private static final Logger LOG;
    private static final boolean USE_COROUTINE_DISPATCHER;
    @NotNull
    private static final com.intellij.openapi.vfs.newvfs.FileAttribute FILE_ATTRIBUTE;
    @NotNull
    private static final ConcurrentHashMap<Integer, MultiHashes> unsavedMultiHashes;
    @NotNull
    private static final Executor cacheHousekeepingExecutor;
    private static final Cache<Integer, MultiHashes> cachedMultiHashes;
    @NotNull
    private static final ConcurrentHashMap<HashIndexKey, AtomicInteger> indexVersions;
    @NotNull
    private static final ReindexCountFile indexVersionFile;

    public AttrBasedFileContentHashForwardIndex(@NotNull HashIndexKey hashIndexId) {
        Intrinsics.checkNotNullParameter((Object)((Object)hashIndexId), (String)"hashIndexId");
        this.hashIndexId = hashIndexId;
        this.indexVersion = AttrBasedFileContentHashForwardIndex.Companion.getForwardIndexVersion(this.hashIndexId);
    }

    public void close() {
        this.force();
    }

    public boolean isClosed() {
        return false;
    }

    public void force() {
        AttrBasedFileContentHashForwardIndex.Companion.flush();
    }

    public boolean isDirty() {
        boolean bl;
        block3: {
            Iterable $this$any$iv = cachedMultiHashes.asMap().values();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    MultiHashes it = (MultiHashes)element$iv;
                    boolean bl2 = false;
                    if (!it.isDirty()) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public void clear() {
        Companion.bumpForwardIndexVersion(this.hashIndexId);
        try {
            this.force();
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    public void put(int fileId, @Nullable ByteArraySequence value) {
        cachedMultiHashes.asMap().compute(fileId, (arg_0, arg_1) -> AttrBasedFileContentHashForwardIndex.put$lambda$1(fileId, this, value, arg_0, arg_1));
    }

    @Nullable
    public ByteArraySequence get(int fileId) {
        return ((MultiHashes)cachedMultiHashes.get((Object)fileId, arg_0 -> AttrBasedFileContentHashForwardIndex.get$lambda$3(arg_0 -> AttrBasedFileContentHashForwardIndex.get$lambda$2(fileId, arg_0), arg_0))).getSerializedHash(this.hashIndexId.getUniqueId(), this.indexVersion.get());
    }

    public int keysCountApproximately() {
        return (int)cachedMultiHashes.estimatedSize();
    }

    private static final MultiHashes put$lambda$1(int $fileId, AttrBasedFileContentHashForwardIndex this$0, ByteArraySequence $value, Integer n, MultiHashes hashes) {
        return (hashes == null ? AttrBasedFileContentHashForwardIndex.Companion.readMultiHashes($fileId) : hashes).setSerializedHash(this$0.hashIndexId.getUniqueId(), $value, this$0.indexVersion.get());
    }

    private static final MultiHashes get$lambda$2(int $fileId, Integer it) {
        return AttrBasedFileContentHashForwardIndex.Companion.readMultiHashes($fileId);
    }

    private static final MultiHashes get$lambda$3(Function1 $tmp0, Object p0) {
        return (MultiHashes)$tmp0.invoke(p0);
    }

    private static final Unit cachedMultiHashes$lambda$4(Integer fileId, MultiHashes multiHashes, RemovalCause removalCause) {
        if (fileId != null && multiHashes != null) {
            AttrBasedFileContentHashForwardIndex.Companion.writeHashes(fileId, multiHashes);
        }
        return Unit.INSTANCE;
    }

    private static final void cachedMultiHashes$lambda$5(Function3 $tmp0, Object p0, Object p1, RemovalCause p2) {
        $tmp0.invoke(p0, p1, (Object)p2);
    }

    @JvmStatic
    public static final synchronized void bumpForwardIndexVersion(@NotNull HashIndexKey hashIndexId) {
        Companion.bumpForwardIndexVersion(hashIndexId);
    }

    @JvmStatic
    public static final void disposeAllCaches() {
        Companion.disposeAllCaches();
    }

    @JvmStatic
    public static final void readVersions() {
        Companion.readVersions();
    }

    @JvmStatic
    public static final void bumpBaseVersion() {
        Companion.bumpBaseVersion();
    }

    static {
        Executor executor;
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(AttrBasedFileContentHashForwardIndex.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        USE_COROUTINE_DISPATCHER = SystemProperties.getBooleanProperty((String)"AttrBasedFileContentHashForwardIndex.USE_COROUTINE_DISPATCHER", (boolean)false);
        FILE_ATTRIBUTE = new com.intellij.openapi.vfs.newvfs.FileAttribute("file.content.hash.forward.multi.index", 1, false);
        unsavedMultiHashes = new ConcurrentHashMap();
        if (USE_COROUTINE_DISPATCHER) {
            executor = ExecutorsKt.asExecutor((CoroutineDispatcher)Dispatchers.getIO().limitedParallelism(1));
        } else {
            ExecutorService executorService = SequentialTaskExecutor.createSequentialApplicationPoolExecutor((String)"Shared Index Hash Index Flushing Queue");
            Intrinsics.checkNotNull((Object)executorService);
            executor = executorService;
        }
        cacheHousekeepingExecutor = executor;
        cachedMultiHashes = Caffeine.newBuilder().maximumSize(128L).executor(cacheHousekeepingExecutor).removalListener((arg_0, arg_1, arg_2) -> AttrBasedFileContentHashForwardIndex.cachedMultiHashes$lambda$5(AttrBasedFileContentHashForwardIndex::cachedMultiHashes$lambda$4, arg_0, arg_1, arg_2)).build();
        indexVersions = new ConcurrentHashMap();
        Path path = SharedIndexChunkConfigurationImpl.getSharedIndexConfigurationRoot().resolve("forward.index.versions");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        indexVersionFile = new ReindexCountFile(path);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\rH\u0002J\u0010\u0010\u001d\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\fH\u0002J\b\u0010\u001e\u001a\u00020\rH\u0002J\u0012\u0010\u001f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0016\u001a\u00020\fH\u0002J\u0010\u0010 \u001a\u00020\f2\u0006\u0010!\u001a\u00020\u0019H\u0002J\u0010\u0010\"\u001a\u00020\u00152\u0006\u0010!\u001a\u00020\u0019H\u0007J\u0010\u0010#\u001a\u00020\u001a2\u0006\u0010!\u001a\u00020\u0019H\u0002J\u0010\u0010$\u001a\u00020\f2\u0006\u0010!\u001a\u00020\u0019H\u0002J\b\u0010%\u001a\u00020\u0015H\u0007J\b\u0010&\u001a\u00020\u0015H\u0002J\b\u0010'\u001a\u00020\u0015H\u0007J\b\u0010(\u001a\u00020\u0015H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000RP\u0010\u0010\u001aB\u0012\f\u0012\n \u0012*\u0004\u0018\u00010\f0\f\u0012\f\u0012\n \u0012*\u0004\u0018\u00010\r0\r \u0012* \u0012\f\u0012\n \u0012*\u0004\u0018\u00010\f0\f\u0012\f\u0012\n \u0012*\u0004\u0018\u00010\r0\r\u0018\u00010\u00110\u0011X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0013R\u001a\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001a0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/intellij/indexing/shared/platform/impl/AttrBasedFileContentHashForwardIndex$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "USE_COROUTINE_DISPATCHER", "", "FILE_ATTRIBUTE", "Lcom/intellij/openapi/vfs/newvfs/FileAttribute;", "unsavedMultiHashes", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lcom/intellij/indexing/shared/platform/impl/AttrBasedFileContentHashForwardIndex$MultiHashes;", "cacheHousekeepingExecutor", "Ljava/util/concurrent/Executor;", "cachedMultiHashes", "Lcom/github/benmanes/caffeine/cache/Cache;", "kotlin.jvm.PlatformType", "Lcom/github/benmanes/caffeine/cache/Cache;", "writeHashes", "", "fileId", "multiHashes", "indexVersions", "Lcom/intellij/indexing/shared/platform/impl/HashIndexKey;", "Ljava/util/concurrent/atomic/AtomicInteger;", "indexVersionFile", "Lcom/intellij/indexing/shared/platform/impl/AttrBasedFileContentHashForwardIndex$ReindexCountFile;", "readMultiHashes", "newMultiHashes", "readFromAttrs", "calculateForwardIndexVersion", "hashIndexId", "bumpForwardIndexVersion", "getForwardIndexVersion", "getCurrentReindexCount", "disposeAllCaches", "flush", "readVersions", "bumpBaseVersion", "intellij.indexing.shared"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void writeHashes(int fileId, MultiHashes multiHashes) {
            block10: {
                try {
                    if (!multiHashes.isDirty()) break block10;
                    try {
                        Closeable closeable = (Closeable)FSRecords.writeAttribute((int)fileId, (com.intellij.openapi.vfs.newvfs.FileAttribute)FILE_ATTRIBUTE);
                        Throwable throwable = null;
                        try {
                            AttributeOutputStream it = (AttributeOutputStream)closeable;
                            boolean bl = false;
                            Intrinsics.checkNotNull((Object)it);
                            MultiHashesExternalizer.INSTANCE.save((DataOutput)it, multiHashes);
                            Unit unit = Unit.INSTANCE;
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                        }
                    }
                    catch (Throwable e) {
                        LOG.error(e);
                        throw e;
                    }
                }
                finally {
                    unsavedMultiHashes.remove(fileId, multiHashes);
                }
            }
        }

        private final MultiHashes readMultiHashes(int fileId) {
            MultiHashes multiHashes = unsavedMultiHashes.compute(fileId, (arg_0, arg_1) -> Companion.readMultiHashes$lambda$1(fileId, arg_0, arg_1));
            Intrinsics.checkNotNull((Object)multiHashes);
            return multiHashes;
        }

        private final MultiHashes newMultiHashes() {
            Int2ObjectMap int2ObjectMap = Int2ObjectMaps.synchronize((Int2ObjectMap)((Int2ObjectMap)new Int2ObjectOpenHashMap()));
            Intrinsics.checkNotNull((Object)int2ObjectMap, (String)"null cannot be cast to non-null type it.unimi.dsi.fastutil.ints.Int2ObjectMap<com.intellij.indexing.shared.platform.impl.AttrBasedFileContentHashForwardIndex.IndexData>");
            return new MultiHashes((Int2ObjectMap<IndexData>)int2ObjectMap);
        }

        private final MultiHashes readFromAttrs(int fileId) {
            return (MultiHashes)FSRecords.readAttributeRawWithLock((int)fileId, (com.intellij.openapi.vfs.newvfs.FileAttribute)FILE_ATTRIBUTE, Companion::readFromAttrs$lambda$2);
        }

        private final int calculateForwardIndexVersion(HashIndexKey hashIndexId) {
            return this.getCurrentReindexCount(hashIndexId) + SharedIndexInfrastructure.SHARED_INDEX_INFRASTRUCTURE_VERSION;
        }

        @JvmStatic
        public final synchronized void bumpForwardIndexVersion(@NotNull HashIndexKey hashIndexId) {
            Intrinsics.checkNotNullParameter((Object)((Object)hashIndexId), (String)"hashIndexId");
            indexVersionFile.bumpVersion(hashIndexId);
            indexVersions.computeIfAbsent(hashIndexId, arg_0 -> Companion.bumpForwardIndexVersion$lambda$4(Companion::bumpForwardIndexVersion$lambda$3, arg_0)).set(this.calculateForwardIndexVersion(hashIndexId));
        }

        private final AtomicInteger getForwardIndexVersion(HashIndexKey hashIndexId) {
            AtomicInteger atomicInteger = indexVersions.computeIfAbsent(hashIndexId, arg_0 -> Companion.getForwardIndexVersion$lambda$6(arg_0 -> Companion.getForwardIndexVersion$lambda$5(hashIndexId, arg_0), arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)atomicInteger, (String)"computeIfAbsent(...)");
            return atomicInteger;
        }

        private final int getCurrentReindexCount(HashIndexKey hashIndexId) {
            return indexVersionFile.getIndexVersion(hashIndexId) + indexVersionFile.getBaseVersion();
        }

        @JvmStatic
        public final void disposeAllCaches() {
            indexVersions.clear();
            this.flush();
        }

        private final void flush() {
            cachedMultiHashes.invalidateAll();
            CompletableFuture flusher = new CompletableFuture();
            cacheHousekeepingExecutor.execute(() -> Companion.flush$lambda$7(flusher));
            for (int i = 0; i < 11; ++i) {
                try {
                    flusher.get(1L, TimeUnit.MINUTES);
                }
                catch (TimeoutException timeoutException) {
                }
                catch (RejectedExecutionException rejectedExecutionException) {
                    // empty catch block
                }
                if (flusher.isDone()) break;
            }
            if (!flusher.isDone() && !((Map)unsavedMultiHashes).isEmpty()) {
                LOG.error("Too long flush operation. Trying to flush manually...");
                Iterator iterator = unsavedMultiHashes.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry;
                    Intrinsics.checkNotNullExpressionValue(iterator.next(), (String)"next(...)");
                    Object k = entry.getKey();
                    Intrinsics.checkNotNullExpressionValue(k, (String)"component1(...)");
                    Integer fileId = (Integer)k;
                    Object v = entry.getValue();
                    Intrinsics.checkNotNullExpressionValue(v, (String)"component2(...)");
                    MultiHashes multiHashes = (MultiHashes)v;
                    this.writeHashes(fileId, multiHashes);
                }
            }
        }

        @JvmStatic
        public final void readVersions() {
            indexVersionFile.readVersions();
        }

        @JvmStatic
        public final void bumpBaseVersion() {
            indexVersionFile.bumpBaseVersion();
        }

        private static final MultiHashes readMultiHashes$lambda$1(int $fileId, Integer n, MultiHashes oldUnsavedHashes) {
            MultiHashes multiHashes;
            Intrinsics.checkNotNullParameter((Object)n, (String)"<unused var>");
            if (oldUnsavedHashes == null) {
                multiHashes = Companion.readFromAttrs($fileId);
                if (multiHashes == null) {
                    multiHashes = Companion.newMultiHashes();
                }
            } else {
                multiHashes = oldUnsavedHashes.copy();
            }
            return multiHashes;
        }

        private static final MultiHashes readFromAttrs$lambda$2(ByteBuffer input) {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            return MultiHashesExternalizer.INSTANCE.read(input);
        }

        private static final AtomicInteger bumpForwardIndexVersion$lambda$3(HashIndexKey it) {
            Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
            return new AtomicInteger();
        }

        private static final AtomicInteger bumpForwardIndexVersion$lambda$4(Function1 $tmp0, Object p0) {
            return (AtomicInteger)$tmp0.invoke(p0);
        }

        private static final AtomicInteger getForwardIndexVersion$lambda$5(HashIndexKey $hashIndexId, HashIndexKey it) {
            Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
            return new AtomicInteger(Companion.calculateForwardIndexVersion($hashIndexId));
        }

        private static final AtomicInteger getForwardIndexVersion$lambda$6(Function1 $tmp0, Object p0) {
            return (AtomicInteger)$tmp0.invoke(p0);
        }

        private static final void flush$lambda$7(CompletableFuture $flusher) {
            $flusher.complete(null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001:\u0001\u0015B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lcom/intellij/indexing/shared/platform/impl/AttrBasedFileContentHashForwardIndex$IndexData;", "", "version", "", "hashId", "", "<init>", "(IJ)V", "getVersion", "()I", "getHashId", "()J", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "EXTERNALIZER", "intellij.indexing.shared"})
    private static final class IndexData {
        private final int version;
        private final long hashId;

        public IndexData(int version, long hashId) {
            this.version = version;
            this.hashId = hashId;
        }

        public final int getVersion() {
            return this.version;
        }

        public final long getHashId() {
            return this.hashId;
        }

        public final int component1() {
            return this.version;
        }

        public final long component2() {
            return this.hashId;
        }

        @NotNull
        public final IndexData copy(int version, long hashId) {
            return new IndexData(version, hashId);
        }

        public static /* synthetic */ IndexData copy$default(IndexData indexData, int n, long l, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = indexData.version;
            }
            if ((n2 & 2) != 0) {
                l = indexData.hashId;
            }
            return indexData.copy(n, l);
        }

        @NotNull
        public String toString() {
            return "IndexData(version=" + this.version + ", hashId=" + this.hashId + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.version);
            result = result * 31 + Long.hashCode(this.hashId);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof IndexData)) {
                return false;
            }
            IndexData indexData = (IndexData)other;
            if (this.version != indexData.version) {
                return false;
            }
            return this.hashId == indexData.hashId;
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0002H\u0016J\u0010\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u000e\u0010\n\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000e\u00a8\u0006\u000f"}, d2={"Lcom/intellij/indexing/shared/platform/impl/AttrBasedFileContentHashForwardIndex$IndexData$EXTERNALIZER;", "Lcom/intellij/util/io/DataExternalizer;", "Lcom/intellij/indexing/shared/platform/impl/AttrBasedFileContentHashForwardIndex$IndexData;", "<init>", "()V", "save", "", "out", "Ljava/io/DataOutput;", "value", "read", "in", "Ljava/io/DataInput;", "input", "Ljava/nio/ByteBuffer;", "intellij.indexing.shared"})
        public static final class EXTERNALIZER
        implements DataExternalizer<IndexData> {
            @NotNull
            public static final EXTERNALIZER INSTANCE = new EXTERNALIZER();

            private EXTERNALIZER() {
            }

            public void save(@NotNull DataOutput out, @NotNull IndexData value) {
                Intrinsics.checkNotNullParameter((Object)out, (String)"out");
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                DataInputOutputUtil.writeINT((DataOutput)out, (int)value.getVersion());
                DataInputOutputUtil.writeLONG((DataOutput)out, (long)value.getHashId());
            }

            @NotNull
            public IndexData read(@NotNull DataInput in) {
                Intrinsics.checkNotNullParameter((Object)in, (String)"in");
                return new IndexData(DataInputOutputUtil.readINT((DataInput)in), DataInputOutputUtil.readLONG((DataInput)in));
            }

            @NotNull
            public final IndexData read(@NotNull ByteBuffer input) {
                Intrinsics.checkNotNullParameter((Object)input, (String)"input");
                return new IndexData(DataInputOutputUtil.readINT((ByteBuffer)input), DataInputOutputUtil.readLONG((ByteBuffer)input));
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011J \u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0014\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0012\u001a\u00020\u0011J\u0006\u0010\u0015\u001a\u00020\u0000R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u0016"}, d2={"Lcom/intellij/indexing/shared/platform/impl/AttrBasedFileContentHashForwardIndex$MultiHashes;", "", "hashes", "Lit/unimi/dsi/fastutil/ints/Int2ObjectMap;", "Lcom/intellij/indexing/shared/platform/impl/AttrBasedFileContentHashForwardIndex$IndexData;", "<init>", "(Lit/unimi/dsi/fastutil/ints/Int2ObjectMap;)V", "getHashes", "()Lit/unimi/dsi/fastutil/ints/Int2ObjectMap;", "isDirty", "", "()Z", "setDirty", "(Z)V", "getSerializedHash", "Lcom/intellij/openapi/util/io/ByteArraySequence;", "indexId", "", "forwardIndexVersion", "setSerializedHash", "serializedHashId", "copy", "intellij.indexing.shared"})
    private static final class MultiHashes {
        @NotNull
        private final Int2ObjectMap<IndexData> hashes;
        private volatile boolean isDirty;

        public MultiHashes(@NotNull Int2ObjectMap<IndexData> hashes) {
            Intrinsics.checkNotNullParameter(hashes, (String)"hashes");
            this.hashes = hashes;
        }

        @NotNull
        public final Int2ObjectMap<IndexData> getHashes() {
            return this.hashes;
        }

        public final boolean isDirty() {
            return this.isDirty;
        }

        public final void setDirty(boolean bl) {
            this.isDirty = bl;
        }

        @Nullable
        public final ByteArraySequence getSerializedHash(int indexId, int forwardIndexVersion) {
            IndexData indexData = (IndexData)this.hashes.get(indexId);
            if (indexData == null) {
                return null;
            }
            IndexData hashData = indexData;
            if (hashData.getVersion() != forwardIndexVersion) {
                return null;
            }
            return AbstractForwardIndexAccessor.serializeKeyToByteSeq((Object)hashData.getHashId(), (DataExternalizer)((DataExternalizer)FileContentHashIndexExtension.HASH_ID_DESCRIPTOR), (int)8);
        }

        @NotNull
        public final MultiHashes setSerializedHash(int indexId, @Nullable ByteArraySequence serializedHashId, int forwardIndexVersion) {
            if (serializedHashId == null) {
                IndexData oldData = (IndexData)this.hashes.remove(indexId);
                if (!this.isDirty && oldData != null) {
                    this.isDirty = true;
                }
                return this;
            }
            Long hashId = (Long)AbstractForwardIndexAccessor.deserializeFromByteSeq((ByteArraySequence)serializedHashId, (DataExternalizer)((DataExternalizer)FileContentHashIndexExtension.HASH_ID_DESCRIPTOR));
            Intrinsics.checkNotNull((Object)hashId);
            IndexData indexData = new IndexData(forwardIndexVersion, hashId);
            IndexData oldIndexData = (IndexData)this.hashes.put(indexId, (Object)indexData);
            if (!this.isDirty && !Intrinsics.areEqual((Object)oldIndexData, (Object)indexData)) {
                this.isDirty = true;
            }
            return this;
        }

        @NotNull
        public final MultiHashes copy() {
            return new MultiHashes(this.hashes);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0002H\u0016J\u0010\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u000e\u0010\n\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000e\u00a8\u0006\u000f"}, d2={"Lcom/intellij/indexing/shared/platform/impl/AttrBasedFileContentHashForwardIndex$MultiHashesExternalizer;", "Lcom/intellij/util/io/DataExternalizer;", "Lcom/intellij/indexing/shared/platform/impl/AttrBasedFileContentHashForwardIndex$MultiHashes;", "<init>", "()V", "save", "", "out", "Ljava/io/DataOutput;", "data", "read", "in", "Ljava/io/DataInput;", "input", "Ljava/nio/ByteBuffer;", "intellij.indexing.shared"})
    private static final class MultiHashesExternalizer
    implements DataExternalizer<MultiHashes> {
        @NotNull
        public static final MultiHashesExternalizer INSTANCE = new MultiHashesExternalizer();

        private MultiHashesExternalizer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void save(@NotNull DataOutput out, @NotNull MultiHashes data) {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            Int2ObjectMap<IndexData> int2ObjectMap = data.getHashes();
            synchronized (int2ObjectMap) {
                boolean bl = false;
                DataInputOutputUtil.writeINT((DataOutput)out, (int)data.getHashes().size());
                ObjectIterator objectIterator = data.getHashes().int2ObjectEntrySet().iterator();
                Intrinsics.checkNotNullExpressionValue((Object)objectIterator, (String)"iterator(...)");
                ObjectIterator objectIterator2 = objectIterator;
                while (objectIterator2.hasNext()) {
                    Int2ObjectMap.Entry entry = (Int2ObjectMap.Entry)objectIterator2.next();
                    int indexId = entry.getIntKey();
                    IndexData indexData = (IndexData)entry.getValue();
                    DataInputOutputUtil.writeINT((DataOutput)out, (int)indexId);
                    Intrinsics.checkNotNull((Object)indexData);
                    IndexData.EXTERNALIZER.INSTANCE.save(out, indexData);
                }
                Unit unit = Unit.INSTANCE;
            }
        }

        @NotNull
        public MultiHashes read(@NotNull DataInput in) {
            Intrinsics.checkNotNullParameter((Object)in, (String)"in");
            int size = DataInputOutputUtil.readINT((DataInput)in);
            Int2ObjectOpenHashMap result = new Int2ObjectOpenHashMap(size);
            int n = 0;
            while (n < size) {
                int it = n++;
                boolean bl = false;
                result.put(DataInputOutputUtil.readINT((DataInput)in), (Object)IndexData.EXTERNALIZER.INSTANCE.read(in));
            }
            Int2ObjectMap int2ObjectMap = Int2ObjectMaps.synchronize((Int2ObjectMap)((Int2ObjectMap)result));
            Intrinsics.checkNotNull((Object)int2ObjectMap, (String)"null cannot be cast to non-null type it.unimi.dsi.fastutil.ints.Int2ObjectMap<com.intellij.indexing.shared.platform.impl.AttrBasedFileContentHashForwardIndex.IndexData>");
            return new MultiHashes((Int2ObjectMap<IndexData>)int2ObjectMap);
        }

        @NotNull
        public final MultiHashes read(@NotNull ByteBuffer input) {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            int size = DataInputOutputUtil.readINT((ByteBuffer)input);
            Int2ObjectOpenHashMap result = new Int2ObjectOpenHashMap(size);
            int n = 0;
            while (n < size) {
                int it = n++;
                boolean bl = false;
                result.put(DataInputOutputUtil.readINT((ByteBuffer)input), (Object)IndexData.EXTERNALIZER.INSTANCE.read(input));
            }
            Int2ObjectMap int2ObjectMap = Int2ObjectMaps.synchronize((Int2ObjectMap)((Int2ObjectMap)result));
            Intrinsics.checkNotNull((Object)int2ObjectMap, (String)"null cannot be cast to non-null type it.unimi.dsi.fastutil.ints.Int2ObjectMap<com.intellij.indexing.shared.platform.impl.AttrBasedFileContentHashForwardIndex.IndexData>");
            return new MultiHashes((Int2ObjectMap<IndexData>)int2ObjectMap);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\t\u001a\u00020\nJ\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0006\u0010\u0010\u001a\u00020\nJ\u000e\u0010\u0011\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/indexing/shared/platform/impl/AttrBasedFileContentHashForwardIndex$ReindexCountFile;", "", "file", "Ljava/nio/file/Path;", "<init>", "(Ljava/nio/file/Path;)V", "idToVersion", "Lit/unimi/dsi/fastutil/objects/Object2IntMap;", "", "readVersions", "", "getBaseVersion", "", "getIndexVersion", "key", "Lcom/intellij/indexing/shared/platform/impl/HashIndexKey;", "bumpBaseVersion", "bumpVersion", "Companion", "intellij.indexing.shared"})
    private static final class ReindexCountFile {
        @NotNull
        private static final Companion Companion = new Companion(null);
        @NotNull
        private final Path file;
        private Object2IntMap<String> idToVersion;
        @NotNull
        private static final String BASE_VERSION_PROPERTY_NAME = "shared.index.file.content.hash.forward.index.base";

        public ReindexCountFile(@NotNull Path file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            this.file = file;
        }

        public final synchronized void readVersions() {
            this.idToVersion = ReindexCountFile.Companion.readFile(this.file);
        }

        public final synchronized int getBaseVersion() {
            Object2IntMap<String> object2IntMap = this.idToVersion;
            if (object2IntMap == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"idToVersion");
                object2IntMap = null;
            }
            return object2IntMap.getInt((Object)BASE_VERSION_PROPERTY_NAME);
        }

        public final synchronized int getIndexVersion(@NotNull HashIndexKey key) {
            Intrinsics.checkNotNullParameter((Object)((Object)key), (String)"key");
            Object2IntMap<String> object2IntMap = this.idToVersion;
            if (object2IntMap == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"idToVersion");
                object2IntMap = null;
            }
            return object2IntMap.getInt((Object)ReindexCountFile.Companion.versionPropertyName(key));
        }

        public final synchronized void bumpBaseVersion() {
            Object2IntMap<String> object2IntMap = this.idToVersion;
            if (object2IntMap == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"idToVersion");
                object2IntMap = null;
            }
            Map map = (Map)object2IntMap;
            String string = BASE_VERSION_PROPERTY_NAME;
            Integer n = (short)System.currentTimeMillis();
            map.put(string, n);
            Object2IntMap<String> object2IntMap2 = this.idToVersion;
            if (object2IntMap2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"idToVersion");
                object2IntMap2 = null;
            }
            ReindexCountFile.Companion.writeFile(this.file, (Object2IntMap<String>)object2IntMap2);
        }

        public final synchronized void bumpVersion(@NotNull HashIndexKey key) {
            Intrinsics.checkNotNullParameter((Object)((Object)key), (String)"key");
            Object2IntMap<String> object2IntMap = this.idToVersion;
            if (object2IntMap == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"idToVersion");
                object2IntMap = null;
            }
            object2IntMap.mergeInt((Object)ReindexCountFile.Companion.versionPropertyName(key), 1, ReindexCountFile::bumpVersion$lambda$0);
            Object2IntMap<String> object2IntMap2 = this.idToVersion;
            if (object2IntMap2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"idToVersion");
                object2IntMap2 = null;
            }
            ReindexCountFile.Companion.writeFile(this.file, (Object2IntMap<String>)object2IntMap2);
        }

        private static final int bumpVersion$lambda$0(int x, int y) {
            return Math.addExact(x, y);
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00050\nH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/indexing/shared/platform/impl/AttrBasedFileContentHashForwardIndex$ReindexCountFile$Companion;", "", "<init>", "()V", "BASE_VERSION_PROPERTY_NAME", "", "versionPropertyName", "hashIndexId", "Lcom/intellij/indexing/shared/platform/impl/HashIndexKey;", "readFile", "Lit/unimi/dsi/fastutil/objects/Object2IntMap;", "file", "Ljava/nio/file/Path;", "setupNewFile", "writeFile", "", "versions", "intellij.indexing.shared"})
        @SourceDebugExtension(value={"SMAP\nAttrBasedFileContentHashForwardIndex.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AttrBasedFileContentHashForwardIndex.kt\ncom/intellij/indexing/shared/platform/impl/AttrBasedFileContentHashForwardIndex$ReindexCountFile$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,395:1\n1863#2,2:396\n1557#2:398\n1628#2,3:399\n*S KotlinDebug\n*F\n+ 1 AttrBasedFileContentHashForwardIndex.kt\ncom/intellij/indexing/shared/platform/impl/AttrBasedFileContentHashForwardIndex$ReindexCountFile$Companion\n*L\n325#1:396,2\n348#1:398\n348#1:399,3\n*E\n"})
        private static final class Companion {
            private Companion() {
            }

            private final String versionPropertyName(HashIndexKey hashIndexId) {
                return "shared.index.file.content.hash.forward.index." + hashIndexId;
            }

            private final Object2IntMap<String> readFile(Path file) {
                Object2IntMap<String> object2IntMap;
                LinkOption[] linkOptionArray = new LinkOption[]{};
                if (!Files.exists(file, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                    return this.setupNewFile(file);
                }
                try {
                    Object2IntOpenHashMap versions = new Object2IntOpenHashMap();
                    List<String> list = Files.readAllLines(file, Charsets.UTF_8);
                    Intrinsics.checkNotNullExpressionValue(list, (String)"readAllLines(...)");
                    Iterable $this$forEach$iv = list;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        String it = (String)element$iv;
                        boolean bl = false;
                        Intrinsics.checkNotNull((Object)it);
                        String name = StringsKt.substringBeforeLast$default((String)it, (String)":", null, (int)2, null);
                        int version = Integer.parseInt(StringsKt.substringAfterLast$default((String)it, (String)":", null, (int)2, null));
                        Integer n = version;
                        ((Map)versions).put(name, n);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    object2IntMap = this.setupNewFile(file);
                }
                catch (IOException iOException) {
                    object2IntMap = this.setupNewFile(file);
                }
                return object2IntMap;
            }

            private final Object2IntMap<String> setupNewFile(Path file) {
                Object2IntOpenHashMap versions = new Object2IntOpenHashMap();
                this.writeFile(file, (Object2IntMap<String>)((Object2IntMap)versions));
                return (Object2IntMap)versions;
            }

            /*
             * WARNING - void declaration
             */
            private final void writeFile(Path file, Object2IntMap<String> versions) {
                void $this$mapTo$iv$iv;
                Files.createDirectories(file.getParent(), new FileAttribute[0]);
                ObjectIterable objectIterable = Object2IntMaps.fastIterable(versions);
                Intrinsics.checkNotNullExpressionValue((Object)objectIterable, (String)"fastIterable(...)");
                Iterable $this$map$iv = (Iterable)objectIterable;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Object2IntMap.Entry entry = (Object2IntMap.Entry)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.getKey() + ":" + it.getIntValue());
                }
                List lines = (List)destination$iv$iv;
                Files.write(file, (Iterable<? extends CharSequence>)lines, Charsets.UTF_8, new OpenOption[0]);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

