/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.ast;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.PyElementTypes;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.PythonDialectsTokenSetProvider;
import com.jetbrains.python.ast.PyAstCallExpression;
import com.jetbrains.python.ast.PyAstElement;
import com.jetbrains.python.ast.PyAstElementVisitor;
import com.jetbrains.python.ast.PyAstExpression;
import com.jetbrains.python.ast.PyAstKeywordArgument;
import com.jetbrains.python.ast.PyAstReferenceExpression;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public interface PyAstArgumentList
extends PyAstElement {
    @NotNull
    default public Collection<? extends PyAstExpression> getArgumentExpressions() {
        PyAstExpression[] arguments = this.getArguments();
        ArrayList<PyAstExpression> result = new ArrayList<PyAstExpression>(arguments.length);
        for (PyAstExpression expression : arguments) {
            if (expression instanceof PyAstKeywordArgument) {
                PyAstExpression valueExpression = ((PyAstKeywordArgument)expression).getValueExpression();
                result.add(valueExpression);
            }
            if (!(expression instanceof PyAstReferenceExpression)) continue;
            result.add(expression);
        }
        ArrayList<PyAstExpression> arrayList = result;
        if (arrayList == null) {
            PyAstArgumentList.$$$reportNull$$$0(0);
        }
        return arrayList;
    }

    default public PyAstExpression @NotNull [] getArguments() {
        PyAstExpression[] pyAstExpressionArray = (PyAstExpression[])this.childrenToPsi(PythonDialectsTokenSetProvider.getInstance().getExpressionTokens(), PyAstExpression.EMPTY_ARRAY);
        if (pyAstExpressionArray == null) {
            PyAstArgumentList.$$$reportNull$$$0(1);
        }
        return pyAstExpressionArray;
    }

    @Nullable
    default public PyAstKeywordArgument getKeywordArgument(String name) {
        for (ASTNode node = this.getNode().getFirstChildNode(); node != null; node = node.getTreeNext()) {
            PyAstKeywordArgument arg;
            String keyword;
            if (node.getElementType() != PyElementTypes.KEYWORD_ARGUMENT_EXPRESSION || (keyword = (arg = (PyAstKeywordArgument)node.getPsi()).getKeyword()) == null || !keyword.equals(name)) continue;
            return arg;
        }
        return null;
    }

    @Nullable
    default public PyAstCallExpression getCallExpression() {
        return (PyAstCallExpression)PsiTreeUtil.getParentOfType((PsiElement)this, PyAstCallExpression.class);
    }

    @Nullable
    default public ASTNode getClosingParen() {
        ASTNode node = this.getNode();
        ASTNode[] children = node.getChildren(TokenSet.create((IElementType[])new IElementType[]{PyTokenTypes.RPAR}));
        return children.length == 0 ? null : children[children.length - 1];
    }

    @Override
    default public void acceptPyVisitor(PyAstElementVisitor pyVisitor) {
        pyVisitor.visitPyArgumentList(this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/jetbrains/python/ast/PyAstArgumentList";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getArgumentExpressions";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getArguments";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

