/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh.process;

import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Key;
import com.intellij.remote.BaseRemoteProcessHandler;
import com.intellij.ssh.process.SshProcess;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CapturingSshProcessHandler
extends BaseRemoteProcessHandler<SshProcess<?>> {
    private static final Logger LOG = Logger.getInstance(CapturingSshProcessHandler.class);
    private final ProcessOutput myOutput;

    public CapturingSshProcessHandler(@NotNull SshProcess<?> process, @Nullable Charset charset, @NotNull String commandLine) {
        if (process == null) {
            CapturingSshProcessHandler.$$$reportNull$$$0(0);
        }
        if (commandLine == null) {
            CapturingSshProcessHandler.$$$reportNull$$$0(1);
        }
        super(process, commandLine, charset);
        this.myOutput = new ProcessOutput();
        this.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (outputType == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (outputType == ProcessOutputTypes.STDOUT) {
                    CapturingSshProcessHandler.this.myOutput.appendStdout(event.getText());
                }
                if (outputType == ProcessOutputTypes.STDERR) {
                    CapturingSshProcessHandler.this.myOutput.appendStderr(event.getText());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "event";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "outputType";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/ssh/process/CapturingSshProcessHandler$1";
                objectArray[2] = "onTextAvailable";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @NotNull
    public ProcessOutput runProcess() {
        this.startNotify();
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        if (indicator != null) {
            while (!this.waitFor(300L)) {
                if (!indicator.isCanceled()) continue;
                this.destroyProcess();
                throw new ProcessCanceledException();
            }
        } else if (!this.waitFor()) {
            LOG.info("runProcess: exit value unavailable");
            ProcessOutput processOutput = this.myOutput;
            if (processOutput == null) {
                CapturingSshProcessHandler.$$$reportNull$$$0(2);
            }
            return processOutput;
        }
        this.myOutput.setExitCode(((SshProcess)((Object)this.getProcess())).exitValue());
        ProcessOutput processOutput = this.myOutput;
        if (processOutput == null) {
            CapturingSshProcessHandler.$$$reportNull$$$0(3);
        }
        return processOutput;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ssh/process/CapturingSshProcessHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ssh/process/CapturingSshProcessHandler";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "runProcess";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }
}

