/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.grammar.strategy;

import com.intellij.grazie.grammar.strategy.GrammarCheckingStrategy;
import com.intellij.grazie.ide.language.LanguageGrammarChecking;
import com.intellij.grazie.utils.Text;
import com.intellij.lang.LanguageExtensionPoint;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtilKt;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\"\n\u0002\u0010\f\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\b\u001a\u0012\u0012\u0004\u0012\u0002H\t0\u0005j\b\u0012\u0004\u0012\u0002H\t`\u0007\"\u0004\b\u0000\u0010\tJ\u001b\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\u000eJ\u001e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0010J,\u0010\u0014\u001a\u0012\u0012\u0004\u0012\u00020\u00150\u0005j\b\u0012\u0004\u0012\u00020\u0015`\u00072\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019J\u0015\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0016\u001a\u00020\u0017H\u0000\u00a2\u0006\u0002\b\u001dR\u001e\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u00060\u0005j\b\u0012\u0004\u0012\u00020\u0006`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/grazie/grammar/strategy/StrategyUtils;", "", "<init>", "()V", "EMPTY_LINKED_SET", "Ljava/util/LinkedHashSet;", "", "Lcom/intellij/grazie/utils/LinkedSet;", "emptyLinkedSet", "T", "getStrategyExtensionPoint", "Lcom/intellij/lang/LanguageExtensionPoint;", "Lcom/intellij/grazie/grammar/strategy/GrammarCheckingStrategy;", "strategy", "getStrategyExtensionPoint$intellij_grazie_core", "getTextDomainOrDefault", "Lcom/intellij/grazie/grammar/strategy/GrammarCheckingStrategy$TextDomain;", "root", "Lcom/intellij/psi/PsiElement;", "default", "indentIndexes", "Lkotlin/ranges/IntRange;", "str", "", "chars", "", "", "quotesOffset", "", "quotesOffset$intellij_grazie_core", "intellij.grazie.core"})
public final class StrategyUtils {
    @NotNull
    public static final StrategyUtils INSTANCE = new StrategyUtils();
    @NotNull
    private static final LinkedHashSet EMPTY_LINKED_SET = new LinkedHashSet();

    private StrategyUtils() {
    }

    @NotNull
    public final <T> LinkedHashSet<T> emptyLinkedSet() {
        LinkedHashSet linkedHashSet = EMPTY_LINKED_SET;
        Intrinsics.checkNotNull((Object)linkedHashSet, (String)"null cannot be cast to non-null type java.util.LinkedHashSet<T of com.intellij.grazie.grammar.strategy.StrategyUtils.emptyLinkedSet>");
        return linkedHashSet;
    }

    @NotNull
    public final LanguageExtensionPoint<GrammarCheckingStrategy> getStrategyExtensionPoint$intellij_grazie_core(@NotNull GrammarCheckingStrategy strategy) {
        Intrinsics.checkNotNullParameter((Object)strategy, (String)"strategy");
        LanguageExtensionPoint<GrammarCheckingStrategy> languageExtensionPoint = LanguageGrammarChecking.INSTANCE.getExtensionPointByStrategy(strategy);
        if (languageExtensionPoint == null) {
            throw new IllegalStateException("Strategy is not registered".toString());
        }
        return languageExtensionPoint;
    }

    @NotNull
    public final GrammarCheckingStrategy.TextDomain getTextDomainOrDefault(@NotNull GrammarCheckingStrategy strategy, @NotNull PsiElement root, @NotNull GrammarCheckingStrategy.TextDomain textDomain) {
        Intrinsics.checkNotNullParameter((Object)strategy, (String)"strategy");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)((Object)textDomain), (String)"default");
        LanguageExtensionPoint<GrammarCheckingStrategy> extension = this.getStrategyExtensionPoint$intellij_grazie_core(strategy);
        if (!Intrinsics.areEqual((Object)extension.language, (Object)root.getLanguage().getID())) {
            return textDomain;
        }
        ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(root.getLanguage());
        if (parserDefinition == null) {
            return textDomain;
        }
        ParserDefinition parser = parserDefinition;
        return parser.getStringLiteralElements().contains(PsiTreeUtilKt.getElementType((PsiElement)root)) ? GrammarCheckingStrategy.TextDomain.LITERALS : (parser.getCommentTokens().contains(PsiTreeUtilKt.getElementType((PsiElement)root)) ? GrammarCheckingStrategy.TextDomain.COMMENTS : textDomain);
    }

    @NotNull
    public final LinkedHashSet<IntRange> indentIndexes(@NotNull CharSequence str, @NotNull Set<Character> chars) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        Intrinsics.checkNotNullParameter(chars, (String)"chars");
        LinkedHashSet<IntRange> result2 = new LinkedHashSet<IntRange>();
        int from = -1;
        for (int i = 0; i < str.length(); ++i) {
            int index = i;
            char c = str.charAt(i);
            if ((Text.INSTANCE.isNewline(c) || index == 0 && chars.contains(Character.valueOf(c))) && from == -1) {
                from = index + (Text.INSTANCE.isNewline(c) ? 1 : 0);
                continue;
            }
            if (from == -1 || chars.contains(Character.valueOf(c))) continue;
            if (index > from) {
                result2.add(new IntRange(from, index - 1));
            }
            from = Text.INSTANCE.isNewline(c) ? index + 1 : -1;
        }
        if (from != -1) {
            result2.add(new IntRange(from, str.length() - 1));
        }
        return result2;
    }

    public final int quotesOffset$intellij_grazie_core(@NotNull CharSequence str) {
        int index;
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        for (index = 0; index < str.length() / 2; ++index) {
            if (str.charAt(index) == str.charAt(str.length() - index - 1) && Text.INSTANCE.isQuote(str.charAt(index))) continue;
            return index;
        }
        return index;
    }
}

