/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.diff.impl.patch.ApplyPatchContext;
import com.intellij.openapi.diff.impl.patch.ApplyPatchStatus;
import com.intellij.openapi.diff.impl.patch.apply.ApplyFilePatchBase;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsApplicationSettings;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchDifferentiatedDialog;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchUtil;
import com.intellij.openapi.vcs.changes.patch.PatchFileType;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.io.File;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ApplyPatchAction
extends DumbAwareAction {
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ApplyPatchAction.$$$reportNull$$$0(0);
        }
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (e.isFromContextMenu()) {
            VirtualFile vFile = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
            e.getPresentation().setEnabledAndVisible(project != null && PatchFileType.isPatchFile(vFile));
        } else {
            e.getPresentation().setVisible(true);
            e.getPresentation().setEnabled(project != null);
        }
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            ApplyPatchAction.$$$reportNull$$$0(1);
        }
        return actionUpdateThread;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            ApplyPatchAction.$$$reportNull$$$0(2);
        }
        if ((project = (Project)e.getData(CommonDataKeys.PROJECT)) == null) {
            return;
        }
        if (ChangeListManager.getInstance((Project)project).isFreezedWithNotification(VcsBundle.message((String)"patch.apply.cannot.apply.now", (Object[])new Object[0]))) {
            return;
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        VirtualFile vFile = null;
        if (e.isFromContextMenu() || e.isFromMainMenu()) {
            vFile = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        }
        if (PatchFileType.isPatchFile(vFile)) {
            ApplyPatchAction.showApplyPatch(project, vFile);
        } else {
            FileChooserDescriptor descriptor = ApplyPatchDifferentiatedDialog.createSelectPatchDescriptor();
            VcsApplicationSettings settings = VcsApplicationSettings.getInstance();
            VirtualFile toSelect = settings.PATCH_STORAGE_LOCATION == null ? null : LocalFileSystem.getInstance().refreshAndFindFileByIoFile(new File(settings.PATCH_STORAGE_LOCATION));
            FileChooser.chooseFile((FileChooserDescriptor)descriptor, (Project)project, (VirtualFile)toSelect, file -> {
                VirtualFile parent = file.getParent();
                if (parent != null) {
                    settings.PATCH_STORAGE_LOCATION = parent.getPath();
                }
                ApplyPatchAction.showApplyPatch(project, file);
            });
        }
    }

    public static void showApplyPatch(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            ApplyPatchAction.$$$reportNull$$$0(3);
        }
        if (file == null) {
            ApplyPatchAction.$$$reportNull$$$0(4);
        }
        ApplyPatchUtil.showApplyPatch(project, file);
    }

    @Deprecated
    @RequiresEdt
    public static Boolean showAndGetApplyPatch(@NotNull Project project, @NotNull File file) {
        if (project == null) {
            ApplyPatchAction.$$$reportNull$$$0(5);
        }
        if (file == null) {
            ApplyPatchAction.$$$reportNull$$$0(6);
        }
        ThreadingAssertions.assertEventDispatchThread();
        return ApplyPatchUtil.showAndGetApplyPatch(project, file);
    }

    @Deprecated
    @ApiStatus.Internal
    @NotNull
    public static ApplyPatchStatus applyContent(@NotNull Project project, @NotNull ApplyFilePatchBase<?> patch, @Nullable ApplyPatchContext context, @NotNull VirtualFile file, @Nullable CommitContext commitContext, boolean reverse, @Nullable String leftPanelTitle, @Nullable String rightPanelTitle) {
        if (project == null) {
            ApplyPatchAction.$$$reportNull$$$0(7);
        }
        if (patch == null) {
            ApplyPatchAction.$$$reportNull$$$0(8);
        }
        if (file == null) {
            ApplyPatchAction.$$$reportNull$$$0(9);
        }
        ApplyPatchStatus applyPatchStatus = ApplyPatchUtil.applyContent(project, patch, context, file, commitContext, reverse, leftPanelTitle, rightPanelTitle);
        if (applyPatchStatus == null) {
            ApplyPatchAction.$$$reportNull$$$0(10);
        }
        return applyPatchStatus;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/patch/ApplyPatchAction";
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patch";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/patch/ApplyPatchAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "applyContent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: 
            case 10: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "showApplyPatch";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "showAndGetApplyPatch";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "applyContent";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 10 -> new IllegalStateException(string);
        };
    }
}

