/*
 * Decompiled with CFR 0.152.
 */
package com.intellij;

import com.intellij.tests.IgnoreException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestListener;
import org.junit.runner.Describable;
import org.junit.runner.Description;

public final class OutOfProcessRetries {
    public static OutOfProcessRetryListener getListenerForOutOfProcessRetry() {
        String property = System.getProperty("intellij.build.test.retries.failedClasses.file");
        if (property == null) {
            return null;
        }
        return new OutOfProcessRetryListener(property);
    }

    public static class OutOfProcessRetryListener
    implements TestListener {
        private final String myFileWithFailedClassesPath;
        private final Collection<String> myRetryClasses = new LinkedHashSet<String>();

        private OutOfProcessRetryListener(String fileWithFailedClassesPath) {
            this.myFileWithFailedClassesPath = fileWithFailedClassesPath;
        }

        public void addError(String className, Throwable e) {
            if (IgnoreException.isIgnoringThrowable(e)) {
                return;
            }
            this.myRetryClasses.add(className);
        }

        public void save() throws IOException {
            this.myRetryClasses.remove("_FirstInSuiteTest");
            this.myRetryClasses.remove("_LastInSuiteTest");
            Path path = Path.of(this.myFileWithFailedClassesPath, new String[0]);
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            Files.write(path, this.myRetryClasses, new OpenOption[0]);
        }

        public void addError(Test test, Throwable e) {
            if (IgnoreException.isIgnoringThrowable(e)) {
                return;
            }
            String className = OutOfProcessRetryListener.getClassName(test);
            this.myRetryClasses.add(className);
        }

        public void addFailure(Test test, AssertionFailedError e) {
            this.addError(test, (Throwable)e);
        }

        public void endTest(Test test) {
        }

        public void startTest(Test test) {
        }

        private static String getClassName(Test test) {
            Description description;
            String name;
            if (test instanceof Describable && (name = OutOfProcessRetryListener.getClassName(description = ((Describable)test).getDescription())) != null) {
                return name;
            }
            return test.getClass().getName();
        }

        private static String getClassName(Description description) {
            try {
                return description.getClassName();
            }
            catch (NoSuchMethodError e) {
                String displayName = description.getDisplayName();
                Matcher matcher = Pattern.compile("(.*)\\((.*)\\)").matcher(displayName);
                return matcher.matches() ? matcher.group(2) : displayName;
            }
        }
    }
}

