/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.language.schema.parser.handlers.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.editorconfig.language.schema.descriptors.EditorConfigDescriptor;
import org.editorconfig.language.schema.descriptors.impl.EditorConfigDeclarationDescriptor;
import org.editorconfig.language.schema.parser.EditorConfigJsonSchemaException;
import org.editorconfig.language.schema.parser.EditorConfigJsonSchemaParser;
import org.editorconfig.language.schema.parser.handlers.EditorConfigDescriptorParseHandlerBase;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0011"}, d2={"Lorg/editorconfig/language/schema/parser/handlers/impl/EditorConfigDeclarationDescriptorParseHandler;", "Lorg/editorconfig/language/schema/parser/handlers/EditorConfigDescriptorParseHandlerBase;", "<init>", "()V", "requiredKeys", "", "", "getRequiredKeys", "()Ljava/util/List;", "optionalKeys", "getOptionalKeys", "doHandle", "Lorg/editorconfig/language/schema/descriptors/EditorConfigDescriptor;", "jsonObject", "Lcom/google/gson/JsonObject;", "parser", "Lorg/editorconfig/language/schema/parser/EditorConfigJsonSchemaParser;", "intellij.editorconfig"})
public final class EditorConfigDeclarationDescriptorParseHandler
extends EditorConfigDescriptorParseHandlerBase {
    @NotNull
    private final List<String> requiredKeys;
    @NotNull
    private final List<String> optionalKeys;

    public EditorConfigDeclarationDescriptorParseHandler() {
        Object[] objectArray = new String[]{"type", "id"};
        this.requiredKeys = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"needs_references", "required"};
        this.optionalKeys = CollectionsKt.plus((Collection)super.getOptionalKeys(), (Iterable)CollectionsKt.listOf((Object[])objectArray));
    }

    @Override
    @NotNull
    protected List<String> getRequiredKeys() {
        return this.requiredKeys;
    }

    @Override
    @NotNull
    protected List<String> getOptionalKeys() {
        return this.optionalKeys;
    }

    @Override
    @NotNull
    protected EditorConfigDescriptor doHandle(@NotNull JsonObject jsonObject, @NotNull EditorConfigJsonSchemaParser parser) {
        Intrinsics.checkNotNullParameter((Object)jsonObject, (String)"jsonObject");
        Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
        JsonElement rawId = jsonObject.get("id");
        if (!rawId.isJsonPrimitive()) {
            throw new EditorConfigJsonSchemaException((JsonElement)jsonObject);
        }
        String id = rawId.getAsString();
        String documentation = this.tryGetString(jsonObject, "documentation");
        String deprecation = this.tryGetString(jsonObject, "deprecated");
        Boolean bl = this.tryGetBoolean(jsonObject, "needs_references");
        boolean needsReferences = bl != null ? bl : true;
        Boolean bl2 = this.tryGetBoolean(jsonObject, "required");
        boolean required = bl2 != null ? bl2 : false;
        Intrinsics.checkNotNull((Object)id);
        return new EditorConfigDeclarationDescriptor(id, needsReferences, required, documentation, deprecation);
    }
}

